(ns atomist.zip
  (:require [clojure.java.io :as io])
  (:import
   (java.io File)
   (java.util.zip ZipOutputStream ZipEntry)))

(defn gcloud-files [f]
  (->> (file-seq f)
       (filter (complement #(clojure.string/includes? (.getCanonicalPath %) ".git")))
       (filter (complement #(clojure.string/includes? (.getCanonicalPath %) ".idea")))
       (filter (complement #(clojure.string/includes? (.getCanonicalPath %) ".shadow-cljs")))
       (filter (complement #(clojure.string/includes? (.getCanonicalPath %) ".cpcache")))
       (filter (complement #(clojure.string/includes? (.getCanonicalPath %) "node_modules")))
       (filter (complement #(clojure.string/includes? (.getCanonicalPath %) "/test/")))
       (filter (complement #(clojure.string/includes? (.getCanonicalPath %) "__pycache__")))
       (filter (complement #(clojure.string/includes? (.getCanonicalPath %) "archive.zip")))
       (filter (complement #(clojure.string/includes? (.getCanonicalPath %) "venv")))
       (filter (complement #(clojure.string/includes? (.getCanonicalPath %) "README.md")))
       (filter (complement #(.isDirectory %)))))

(defn entry-name [^File base-dir ^File f]
  (let [relative-path (clojure.string/replace-first (.getPath f) (.getPath base-dir) "")]
    (if (clojure.string/starts-with? relative-path "/")
      (.substring relative-path 1)
      relative-path)))

(defmacro ^:private with-entry
  [zip entry-name & body]
  `(let [^ZipOutputStream zip# ~zip]
     (.putNextEntry zip# (ZipEntry. ~entry-name))
     ~@body
     (flush)
     (.closeEntry zip#)))

(defn zip-root [{:keys [git-root zip-file] :as req}]
  (with-open [zip (ZipOutputStream. zip-file)
              wrt (io/writer zip)]
    (binding [*out* wrt]
      (doseq [f (gcloud-files git-root)]
        (doto zip
          (with-entry (entry-name git-root f) (println (slurp f))))))))