(ns atomist.functions.bundle
  (:require [atomist.functions.package :refer [add-metadata create-zip check-environment parse-args read-atomist-payload add-repo-details request->atomist-skill-input]]
            [clojure.tools.logging :as log]
            [atomist.api :as api]
            [clojure.java.io :as io]
            [clj-yaml.core :as yaml]))

(defn ensure-dot-atomist [handler]
  (fn [request]
    (.mkdir (io/file (:git-root request) ".atomist"))
    (handler request)))

(defn write-atomist-yaml [handler]
  (fn [request]
    (let [d (request->atomist-skill-input request)]
      (->> (yaml/generate-string d :dumper-options {:flow-style :block})
           (spit (io/file (:git-root request) ".atomist" "skill.yaml"))))))

(defn -main [& args]
  (try
    (log/infof "correlation-id: %s" (or (System/getenv "CORRELATION_ID") (System/getenv "ATOMIST_CORRELATION_ID")))
    ((-> (fn [request] (log/info "finished successfully"))
         (write-atomist-yaml)
         (add-metadata)
         (create-zip)
         (ensure-dot-atomist)
         (parse-args)) {:args (into [] args)
                        :git-root (io/file ".")
                        :zip-file ".atomist/archive.zip"
                        :correlation-id (or (System/getenv "CORRELATION_ID") (System/getenv "ATOMIST_CORRELATION_ID"))})
    (System/exit 0)
    (catch Throwable t
      (log/error t)
      (System/exit 1))))