(ns atomist.buckets
  (:require [clojure.tools.logging :as log]
            [clojure.java.io :as io]
            [atomist.json :as json]
            [clojure.pprint :refer [pprint]]
            [clojure.data]
            [ring.util.codec :as codec]
            [clojure.java.shell :as sh])
  (:import (java.io File)
           (java.nio.file Files Paths)
           (com.google.cloud.storage Storage StorageOptions BlobId BlobInfo Storage$BlobTargetOption)))

(defn gcf-archive-object [team-id owner-name repo-name sha]
  (format "%s/%s/%s/%s-gcf.zip" team-id owner-name repo-name sha))

(defn gcf-archive-url [bucket-name team-id owner-name repo-name sha]
  (format "gs://%s/%s" bucket-name (gcf-archive-object team-id owner-name repo-name sha)))

(defn insert-object
  " bucket - str name of bucket
    object - object name
    zip-file - string name of local file containing zip content to store"
  [bucket object git-root zip-file]
  (let [storage (.getService (StorageOptions/getDefaultInstance))
        blob-id (BlobId/of bucket object)
        blob-info (.build (BlobInfo/newBuilder blob-id))]
    (.create storage blob-info (Files/readAllBytes (Paths/get (.toURI (File. git-root zip-file)))) (into-array Storage$BlobTargetOption []))))
