(ns com.atomist.git.schemas
  (:require [schema.core :as s]))

(s/defschema EditInstruction {:file-pattern s/Str :editor s/Any})
(s/defschema EditorInstruction {:editor s/Any})
(s/defschema WriteInstruction {:to s/Str :contents s/Str})
(s/defschema CopyInstruction {:from s/Str :to s/Str})
(s/defschema MkdirInstruction {:for s/Str})
(s/defschema GitAdd {:file-pattern s/Str})
(s/defschema GitCheckout {:branch s/Str})
(s/defschema GitBranchCreate {:branch s/Str})
(s/defschema GitCommit {:message s/Str (s/optional-key :author) {:email s/Str :name s/Str}})
(s/defschema GitTag {:name s/Str :message s/Str})
(s/defschema GitPush {:remote s/Str :branch s/Str (s/optional-key :oauth-token) s/Str (s/optional-key :spec) s/Str})
(s/defschema GitClone {:org s/Str :repo-name s/Str :oauth-token s/Str :try-fetch? s/Bool :force? s/Bool :branch s/Str})
(s/defschema ErrorInstruction {:error s/Str})
(s/defschema NoOp {:noop s/Any})
(s/defschema Instruction (s/named (s/either WriteInstruction CopyInstruction MkdirInstruction EditInstruction EditorInstruction ErrorInstruction GitAdd GitCommit GitTag GitClone GitPush GitCheckout GitBranchCreate NoOp) "Instruction"))
