(ns atomist.cljs-log
  (:require [goog.string :as gstring]
            [goog.string.format]
            [cljs.pprint]
            ["@atomist/skill-logging/lib/logging" :as skill-logging]))

(def logger js/console)
(def atomist-logger)

(defn create-logger [correlation-id event-id workspace-id]
  (let [skill-logger ((. skill-logging -createLogger) #js {:correlationId correlation-id
                                                           :eventId event-id
                                                           :workspaceId workspace-id})]
    (set! atomist-logger skill-logger)))

(defn atomist-log [s k]
  (.catch
   (.then
    (.log atomist-logger s (case k
                             :info (.. skill-logging -Severity -INFO)
                             :warning (.. skill-logging -Severity -WARNING)
                             :error (.. skill-logging -Severity -ERROR)))
    (fn [v]))
   (fn [error]
     (.error js/console (gstring/format "error logging:  %s" error)))))

(defn- ->log [k & args]
  (cond
    (and atomist-logger (#{:info :error :warning} k))
    (atomist-log (apply str args) k)
    :else
    (case k
      :info (.info logger (apply str args))
      :error (.error logger (apply str args))
      :warning (.warn logger (apply str args))
      :debug (.debug logger (apply str args))
      :trace (.trace logger (apply str args))
      (.info logger (apply str args))))
  nil)

(defn- log [& args]
  (apply ->log :info args))

(defn warn [& args]
  (apply ->log :warning args))

(def info log)

(defn error [& args]
  (apply ->log :error args))

(defn debug [& args]
  (apply ->log :debug args))

(defn trace [& args]
  (apply ->log :trace args))

(defn infof [s & args]
  (info (apply gstring/format s (map #(or % nil) args))))

(defn warnf [s & args]
  (warn (apply gstring/format s (map #(or % nil) args))))

(defn debugf [s & args]
  (debug (apply gstring/format s (map #(or % nil) args))))

(defn errorf [ex s & args]
  (error (.-message ex))
  (error (.-stack ex))
  (error (apply gstring/format s (map #(or % nil) args))))

(defn ptrace [x]
  (trace (with-out-str (cljs.pprint/pprint x)))
  x)

(comment
  (str (.-stack (ex-info "what" {})))
  (create-logger "correlation-id" "event-id" "workspace-id")
  (infof "hey %s" "Jude"))
