(ns atomist.shell
  (:require ["shell-quote" :as shell-quote]
            [clojure.tools.cli :refer [parse-opts]]
            [cljs.core.async :refer [>! <! timeout chan] :as async]
            [cljs.test :refer [deftest is run-tests]])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(def quote (. shell-quote -quote))
(def parse (. shell-quote -parse))

(defn parse-raw-string
  "  returns coll-of string"
  [s]
  (->> (parse s)
       (js->clj)
       (map #(cond
               (string? %) %
               (map? %) (cond
                          (= "glob" (get % "op"))
                          (get % "pattern")
                          (contains? % "comment")
                          (str "#" (get % "comment"))
                          :else
                          %)
               :else %))))

(defn raw-message->options [request options]
  (parse-opts (-> request :raw_message (parse-raw-string)) options))

(deftest glob-tests
  (is (=
       {:url true :glob-pattern "**/*"}
       (:options (raw-message->options
                  {:raw_message "find-by-regex --url --glob-pattern=**/*"}
                  [[nil "--url" nil]
                   [nil "--glob-pattern PATTERN" "glob pattern"]])))))

(deftest channel-tests
  (is (= ["#git-chatops-skill"]
         (:arguments (raw-message->options {:raw_message "#git-chatops-skill"} [[nil "--slack"]])))))
