(ns atomist.json)

(defn json->clj
  "JSON decode an object from `s`."
  [s]
  (if-let [v (js/JSON.parse s)]
    (js->clj v :keywordize-keys true)))

(defn clj->json
  [x]
  (js/JSON.stringify (clj->js x) nil 2))

(defn ->obj [s & {:keys [keywordize-keys] :or {keywordize-keys true}}]

  (js->clj (js/JSON.parse s) :keywordize-keys keywordize-keys))

(defn ->str
  ([obj] (js/JSON.stringify (clj->js obj) nil 2))
  ([obj & {:keys [keyword-fn]
           :or {keyword-fn name}}]
   (js/JSON.stringify (clj->js obj :keyword-fn keyword-fn) nil 2)))
