(ns atomist.exports
  (:require [hasch.core :as hasch]
            [clojure.walk :as w]))

(defn ^:export hasch
  "Calculate a consistent hach of an arbitrary js object"
  [some-obj]
  (str (hasch/uuid (w/postwalk
                    (fn [e]
                      ;; convert vectors to lists because this is what js expects so clojure folks be careful here!
                      (if (vector? e)
                        (apply list e)
                        e))
                    (if (or (object? some-obj) (array? some-obj))
                      (js->clj some-obj)
                      some-obj)))))
