(ns atomist.topics
  (:require ["@google-cloud/pubsub" :as pubsub]
            [atomist.cljs-log :as log]))

(def PubSub (new (. ^js pubsub -PubSub)))

(defn sendreponse [topic-name correlation-id obj]
  (let [topic (.topic ^js PubSub topic-name (clj->js {:messageOrdering true}))
        message-buffer (.from js/Buffer (js/JSON.stringify obj) "utf8")]
    (.catch
     (.then
      (.publishMessage ^js topic (clj->js {:data message-buffer
                                       :orderingKey correlation-id}))
      (fn [result]
        (log/debugf "published to %s:  %s" topic-name result)))
     (fn [error]
       (log/errorf "error publishing to %s:  %s" topic-name error)))))
