(ns atomist.cli
  (:require [atomist.local-runner :as lr]
            [atomist.middleware :as mw]
            [clojure.tools.cli :as tc]
            [atomist.cljs-log :as log]))

(defn repo-promise [f]
  (fn [repo]
    (js/Promise.
     (fn [accept reject]
       (accept (f repo))))))

(defn ^:export visitRepo
  "Set an environment and reate a fake command handler
    returns Promise that will fulfill when the work is done"
  [{:keys [env team f]}]
  (lr/set-env (keyword env))
  (-> (lr/fake-command-handler team "sync" "raw-message" nil nil)
      (lr/add-configuration {:name "default"
                             :parameters []})
      (lr/call-event-handler
       (mw/handler #js {:sync (fn [request]
                                (.withRepoIterator request (repo-promise f) #js {:clone true}))}))))

(def cli-options [["-e" "--env ENV" "Environment Name"
                   :default "custom"
                   :validate [#{"custom" "prod" "staging" "prod-github-auth"}
                              "only these environments are supported"]]
                  ["-t" "--team TEAM" "workspace id"]
                  ["-h" "--help" nil]])

(defn ^:export main []
  (let [{:keys [options summary errors]}
        (tc/parse-opts (. js/process -argv) cli-options)]
    (cond
      (contains? options :help)
      (do
        (log/info summary)
        (.exit js/process 0))
      (and errors (not (empty? errors)))
      (do
        (log/error errors)
        (log/info summary)
        (.exit js/process 1))
      :else
      (.then
       (visitRepo options)
       (fn [_] (.exit js/process 0))))))

(comment
 (visitRepo
  {:team "AEIB5886C"
   :env "prod-github-auth"
   :f (fn [repo] (. repo -basedir))}))