(ns atomist.slack.block-messages
  (:require [goog.string :as gstring]
            [goog.string.format]
            [com.rpl.specter :as specter :refer-macros [select transform declarepath providepath]]))

(defn empty-text-string [blocks]
  (specter/transform [specter/ALL
                      (specter/pred #(= "section" (:type %)))
                      :text
                      :text
                      #(or (nil? %) (= "" %))]
                     (constantly "warning - empty-string")
                     blocks))

(defn- js-action-pred [m]
  (or (:atomist_action m) (:atomist_modal m)))

(defn- action-pred [m]
  (or (:atomist/action m) (:atomist/modal m)))

(specter/declarepath ACTION)
(specter/providepath ACTION (specter/cond-path
                              (specter/must :atomist/action) [:atomist/action]
                              (specter/must :atomist/modal) [:atomist/modal]))

(def base-path
  [specter/ALL
   (specter/pred #(#{"section" "actions"} (:type %)))
   (specter/cond-path (specter/must :accessory) [:accessory]
                      (specter/must :elements) [:elements specter/ALL])])

(def action-path
  [specter/ALL
   (specter/pred #(#{"section" "actions"} (:type %)))
   (specter/cond-path (specter/must :accessory) [:accessory ACTION]
                      (specter/must :elements) [:elements specter/ALL ACTION])])

(defn fix-js-naming-for-actions [blocks]
  (specter/transform (conj base-path (specter/pred js-action-pred))
                     (fn [m]
                       (-> m
                           (cond-> (:atomist_action m) (assoc :atomist/action (:atomist_action m))
                                   (:atomist_modal m) (assoc :atomist/modal (:atomist_modal m)))
                           (dissoc :atomist_action :atomist_modal)))
                     blocks))

(defn add-action-ids [blocks]
  (specter/transform (conj base-path (specter/pred action-pred))
                     (fn [m]
                       (-> m
                           (cond-> (:atomist/action m) (assoc :action_id (gstring/format "command::%s" (-> m :atomist/action :id name)))
                                   (:atomist/modal m) (assoc :action_id (gstring/format "modal::%s" (-> m :atomist/modal :id name))))
                           (dissoc :atomist/action :atomist/modal)))
                     blocks))

(defn extract-actions [blocks]
  (let [actions (specter/select action-path blocks)]
    (->> actions
         (filter identity)
         (map (fn [m]
                {:id (-> m :id name)
                 :command (if-let [k (or (-> m :command) (-> m :id))]
                            (name k))
                 :parameters (or (-> m :parameters) [])})))))
