(ns atomist.schemata
  (:require [cljs.spec.alpha :as s]))

(s/def ::id string?)
(s/def ::name string?)
(s/def ::value string?)
(s/def ::timestamp int?)
(s/def ::ttl int?)
(s/def ::id-and-name (s/keys :req-un [::id]
                             :opt-un [::name]))

(s/def :chat/channel ::id-and-name)
(s/def :chat/user ::id-and-name)
(s/def :chat/team ::id-and-name)
(s/def :destination/slack (s/keys :req-un [:chat/team]
                                  :opt-un [:chat/channel :chat/user :slack/thread_ts]))
(s/def :destination/user_agent #{"slack"})
(s/def :response/destination (s/keys :req-un [:destination/user_agent]
                                     :opt-un [:destination/slack]))
(s/def :response/destinations (s/coll-of :response/destination))
(s/def :action/parameter (s/keys :req-un [::name ::value]))
(s/def :action/parameters (s/coll-of :action/parameter))
(s/def :action/command string?)
(s/def :response/action (s/keys :req-un [::id :action/command :action/parameters]))
(s/def :response/actions (s/coll-of :response/action))
(s/def :response/code int?)
(s/def :response/reason string?)
(s/def :response/status (s/keys :req-un [:response/code :response/reason]))
(s/def :response/body string?)

(s/def :response/content_type #{"application/x-atomist-slack+json"
                                "application/x-atomist-slack-file+json"
                                "application/x-atomist-status+json"
                                "application/x-atomist-continuation+json"
                                "application/x-atomist-delete"
                                "text/plain"
                                "application/json"})

(s/def :response/post_mode #{"ttl" "update_only" "always"})
(s/def :api/api_version #(= "1" %))
(s/def :api/correlation_id string?)

(s/def :response/message (s/keys :req-un [:api/api_version :api/correlation_id]
                                 :opt-un [:response/destinations
                                          :response/status
                                          ::id
                                          ::timestamp
                                          ::ttl
                                          :response/content_type
                                          :response/body
                                          :response/actions
                                          :response/post_mode]))

(s/def :ref/nil-or-string #(or (nil? %) (string? %)))
(s/def :ref/owner string?)
(s/def :ref/repo string?)
(s/def :ref/sha string?)
(s/def :ref/branch :ref/nil-or-string)
(s/def :ref/owner-id :ref/nil-or-string)
(s/def :ref/repo-id :ref/nil-or-string)
(s/def :atomist/ref-with-sha (s/keys :req-un [:ref/owner :ref/repo :ref/sha]
                                     :opt-un [:ref/owner-id :ref/repo-id :ref/branch]))
