(ns atomist.middleware
  (:require [atomist.promise :as promise]
            [cljs.core.async :refer [<!] :refer-macros [go]]
            [atomist.api :as api]
            [atomist.json :as json]
            [atomist.cljs-log :as log]
            [clojure.string :as s]))

(defn destination [request s]
  (cond
    (s/starts-with? s "#") (api/user request (apply str (rest s)))
    (s/starts-with? s "@") (api/channel request (apply str (rest s)))
    :else (throw (ex-info "destinations must start with # or @" request))))

(defn ^:export withSlack
  "Make a handler ready to send block messages

    param
      handler - async function (data, send-blocks) => Void

    returns Promise"
  [handler]
  (fn [data callback]
    (api/make-request
     data callback
     (-> (fn [request]
           (go
             (let [handler-response (<! (promise/from-promise
                                         (handler
                                          (-> request (dissoc :sendreponse) (clj->js))
                                          (fn [channel-or-user json-blocks]
                                            (try
                                              (let [blocks (-> json-blocks (json/->obj) :blocks)]
                                                (-> request
                                                    (destination channel-or-user)
                                                    (api/block-message blocks)))
                                              (catch :default ex
                                                (log/error ex "invalid application/json blocks")
                                                {:failed ex}))))))]
               (if (:failed handler-response)
                 (<! (api/finish request :failure (str "handler failure " (str (:failed handler-response)))))
                 (assoc request :handler-response handler-response)))))
         (api/add-slack-source-to-event)
         (api/create-ref-from-event)
         (api/status)))))
