(ns atomist.local-runner
  "convenience functions when REPLing
     - relies on environment variables like API_KEY_PROD, API_KEY_STAGING, API_KEY_PROD_GITHUB_AUTH, GITHUB_TOKEN"
  (:require [atomist.cljs-log :as log]))

(def environment (atom nil))
(defn set-env
  [x]
  {:pre [(#{:prod :staging :prod-github-auth} x)]}
  (swap! environment (constantly x)))
(defn token []
  (if (not @environment)
    (throw (ex-info "select environment before running" {}))
    (case @environment
      :prod (.. js/process -env -API_KEY_PROD)
      :staging (.. js/process -env -API_KEY_STAGING)
      :prod-github-auth (.. js/process -env -API_KEY_PROD_GITHUB_AUTH))))

(defn call-event-handler [event-data h]
  (let [fake-handler (fn [& args] (log/info args))]
    (.catch
     (.then
      (h (clj->js event-data) fake-handler)
      (fn [v] (log/info "INFO:VALUE " v)))
     (fn [error] (log/error "ERROR " error)))))

(defn fake-schedule [team-id]
  {:data {:OnSchedule {}}
   :secrets [{:uri "atomist://api-key" :value (token)}]
   :extensions {:team_id team-id
                :correlation_id "corrid"}})

(defn fake-push [team-id org repo branch]
  {:data {:Push [{:branch branch
                  :repo {:name repo
                         :org {:owner org
                               :scmProvider {:providerId "zjlmxjzwhurspem"
                                             :credential {:secret (.. js/process -env -GITHUB_TOKEN)}}}}
                  :after {:message ""}}]}
   :secrets [{:uri "atomist://api-key" :value (token)}]
   :extensions {:team_id team-id
                :correlation_id "corrid"}})

(defn fake-command-handler [team-id command raw-message channel-id user-id]
  {:command command
   :source {:slack {:channel {:id channel-id}
                    :user {:id user-id}}}
   :team {:id team-id}
   :raw_message raw-message
   :secrets [{:uri "atomist://api-key" :value (token)}]})
