(ns atomist.shell
  (:require ["shell-quote" :as shell-quote]
            [clojure.tools.cli :refer [parse-opts]]
            [cljs.core.async :refer [>! <! timeout chan] :as async])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(def quote (. shell-quote -quote))
(def parse (. shell-quote -parse))

(defn parse-raw-string
  "  returns coll-of string"
  [s]
  (js->clj (parse s)))

(defn raw-message->options [request options]
  (parse-opts (-> request :raw_message (parse-raw-string)) options))
