(ns atomist.schemata
  (:require [cljs.spec.alpha :as s]))

(s/def ::id string?)
(s/def ::name string?)
(s/def ::value string?)
(s/def ::timestamp int?)
(s/def ::ttl int?)
(s/def ::id-name-name (s/keys :req-un [::id ::name]))

(s/def :chat/channel ::id-and-name)
(s/def :chat/user ::id-and-name)
(s/def :chat/team ::id-and-name)
(s/def :destination/slack (s/keys :req-un [:chat/team]
                                  :opt-un [:chat/channel :chat/user :slack/thread_ts]))
(s/def :destination/user_agent #{"slack"})
(s/def :response/destination (s/keys :req-un [:destination/user_agent]
                                     :opt-un [:destination/slack]))
(s/def :response/destinations (s/coll-of :response/destination))
(s/def :action/parameter (s/keys :req-un [::name ::value]))
(s/def :action/parameters (s/coll-of :action/parameter))
(s/def :action/command string?)
(s/def :response/action (s/keys :req-un [::id :action/command :action/parameters]))
(s/def :response/actions (s/coll-of :response/action))
(s/def :response/code int?)
(s/def :response/reason string?)
(s/def :response/status (s/keys :req-un [:response/code :response/reason]))
(s/def :response/body string?)

(s/def :response/content_type #{"application/x-atomist-slack+json"
                                "application/x-atomist-slack-file+json"
                                "application/x-atomist-status+json"
                                "application/x-atomist-continuation+json"
                                "application/x-atomist-delete"
                                "text/plain"
                                "application/json"})

(s/def :response/post_mode #{"ttl" "update_only" "always"})
(s/def :api/api_version #(= "1" %))
(s/def :api/correlation_id string?)

(s/def :response/message (s/keys :req-un [:api/api_version :api/correlation_id]
                                 :opt-un [:response/destinations
                                          :response/status
                                          ::id
                                          ::timestamp
                                          ::ttl
                                          :response/content_type
                                          :response/body
                                          :response/actions
                                          :response/post_mode]))
