(ns atomist.github
  (:require [http.client :as client]
            [goog.string :as gstring]
            [goog.string.format]
            [atomist.cljs-log :as log]
            [cljs.core.async :refer [<!]])
  (:require-macros [cljs.core.async.macros :refer [go]]))

(defn pr-channel [request branch-name]
  (go
   (try
     (let [response (<! (client/get
                         (gstring/format "https://api.github.com/repos/%s/%s/pulls" (-> request :ref :owner) (-> request :ref :repo))
                         {:query-params {:state "open"
                                         :head (gstring/format "%s:%s" (-> request :ref :owner) branch-name)}
                          :headers {"User-Agent" "atomist"
                                    "Authorization" (gstring/format "Bearer %s" (:token request))}}))]
       (if (= 200 (:status response))
         (-> response :body first)
         (log/warn "no PR found")))
     (catch :default ex
       (log/error "raised exception " ex)))))
