(ns atomist.cljs-log
  (:require [goog.string :as gstring]
            [goog.string.format]
            [cljs.pprint]))

(def logger js/console)

(defn- log [& args]
  (.info logger (apply str args)))

(defn warn [& args]
  (.warn logger (apply str args)))

(def info log)

(defn error [& args]
  (.error logger (apply str args)))

(defn debug [& args]
  (.debug logger (apply str args)))

(defn infof [s & args]
  (info (apply gstring/format s args)))

(defn warnf [s & args]
  (warn (apply gstring/format s args)))

(defn errorf [ex s & args]
  (error (.-message ex))
  (error (apply gstring/format s args)))

(defn ptrace [x]
  (log (with-out-str (cljs.pprint/pprint x)))
  x)
