(ns atomist.graphql)

(def linkedScmId
  "query linkedScmId ($chatUserId: String!) {
     ChatId(userId: $chatUserId) {
        person {
                scmId {
                       provider {
                                 providerId
                                 providerType
                                 }
                       login
                       credential {
                                   secret
                                   }
                       }
                }
        }
     }")

(def linkedRepos
  "query linkedRepos ($channelId: String!) {
    ChatChannel(channelId: $channelId) {
       repos {
              id
              name
              org {
                   owner
                   id
                   scmProvider {
                                providerId
                                providerType
                                }
                   }
              }
       }
    }")

(def scmProviders
  "query {SCMProvider {id providerId providerType}}")

(def githubAppInstallationByOwner
  "query GitHubAppInstallationByOwner($name: String!) {
      GitHubAppInstallation(owner: $name) {
        token {
          secret
        }
      }
  }")

(def repo
  "query repo ($name: String!) {
      Repo(name: $name) {
                         id
                         defaultBranch
                         org {
                              owner
                              scmProvider {
                                           providerId
                                           credential {
                                                       secret
                                                       }
                                           }
                              }
                         }
      }")

(def send-fingerprints
  "mutation AddFingerprints(
     $type: String!,
     $additions: [FingerprintInput!]!,
     $branchId: String!,
     $sha: String!,
     $repoId: String!,
     $isDefaultBranch: Boolean!)
     {setCommitFingerprints (
       add: $additions,
       isDefaultBranch: $isDefaultBranch,
       isHeadCommit: true,
       type: $type,
       branchId: $branchId,
       commitSha: $sha,
       repoId: $repoId,
     )
   }")

(def repo-branch-ids
  "query RepoBranchIds(
     $owner: String!,
     $repo: String!,
     $branch: String!)
   {
     Repo(
        name: $repo,
        owner: $owner)
     {
        id
        defaultBranch
        branches(name: $branch)
        {
          id
        }
     }
   }")

(def query-latest-semver
  "query semver ($type: String!, $name: String!) {
     fingerprintAggregates(type: $type, name: $name) {
       latestSemVerUsed {
         inRepos
         fingerprint {
           displayValue
           name
           sha
           data
         }
       }
       latestSemVerAvailable {
         displayValue
         name
         sha
         data
       }
     }
  }"
  )