(ns atomist.graphql)

(def linkedScmId
  "query linkedScmId ($chatUserId: String!) {
     ChatId(userId: $chatUserId) {
        person {
                scmId {
                       provider {
                                 providerId
                                 providerType
                                 }
                       login
                       credential {
                                   secret
                                   }
                       }
                }
        }
     }")

(def linkedRepos
  "query linkedRepos ($channelId: String!) {
    ChatChannel(channelId: $channelId) {
       repos {
              id
              name
              org {
                   owner
                   id
                   scmProvider {
                                providerId
                                providerType
                                }
                   }
              }
       }
    }")

(def repo
  "query repo ($name: String!) {
      Repo(name: $name) {
                         id
                         defaultBranch
                         org {
                              owner
                              scmProvider {
                                           providerId
                                           credential {
                                                       secret
                                                       }
                                           }
                              }
                         }
      }")