/*
 * Decompiled with CFR 0.152.
 */
package clojure.contrib.http;

import clojure.contrib.http.agent$buffer_bytes;
import clojure.contrib.http.agent$bytes;
import clojure.contrib.http.agent$client_error_QMARK_;
import clojure.contrib.http.agent$connection_success_QMARK_;
import clojure.contrib.http.agent$disconnect;
import clojure.contrib.http.agent$done_QMARK_;
import clojure.contrib.http.agent$error_QMARK_;
import clojure.contrib.http.agent$get_byte_buffer;
import clojure.contrib.http.agent$handle_response;
import clojure.contrib.http.agent$headers;
import clojure.contrib.http.agent$headers_seq;
import clojure.contrib.http.agent$http_agent;
import clojure.contrib.http.agent$loading__4410__auto__;
import clojure.contrib.http.agent$message;
import clojure.contrib.http.agent$method;
import clojure.contrib.http.agent$open_response;
import clojure.contrib.http.agent$redirect_QMARK_;
import clojure.contrib.http.agent$request_body;
import clojure.contrib.http.agent$request_headers;
import clojure.contrib.http.agent$request_uri;
import clojure.contrib.http.agent$result;
import clojure.contrib.http.agent$server_error_QMARK_;
import clojure.contrib.http.agent$setup_http_connection;
import clojure.contrib.http.agent$start_request;
import clojure.contrib.http.agent$status;
import clojure.contrib.http.agent$status_in_range_QMARK_;
import clojure.contrib.http.agent$stream;
import clojure.contrib.http.agent$string;
import clojure.contrib.http.agent$success_QMARK_;
import clojure.lang.AFn;
import clojure.lang.AReference;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.util.Arrays;

public class agent__init {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"ns");
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"in-ns");
    public static final AFn const__2 = (AFn)((IObj)Symbol.create(null, (String)"clojure.contrib.http.agent")).withMeta(RT.map((Object[])new Object[]{Keyword.intern((Symbol)Symbol.create(null, (String)"deprecated")), "1.2", Keyword.intern((Symbol)Symbol.create(null, (String)"doc")), "Agent-based asynchronous HTTP client.\n\n  This is a HTTP client library based on Java's HttpURLConnection\n  class and Clojure's Agent system.  It allows you to make multiple\n  HTTP requests in parallel.\n\n  Start an HTTP request with the 'http-agent' function, which\n  immediately returns a Clojure Agent.  You will never deref this\n  agent; that is handled by the accessor functions.  The agent will\n  execute the HTTP request on a separate thread.\n\n  If you pass a :handler function to http-agent, that function will be\n  called as soon as the HTTP response body is ready.  The handler\n  function is called with one argument, the HTTP agent itself.  The\n  handler can read the response body by calling the 'stream' function\n  on the agent.\n\n  The value returned by the handler function becomes part of the state\n  of the agent, and you can retrieve it with the 'result' function.\n  If you call 'result' before the HTTP request has finished, it will\n  block until the handler function returns.\n\n  If you don't provide a handler function, the default handler will\n  buffer the entire response body in memory, which you can retrieve\n  with the 'bytes', 'string', or 'stream' functions.  Like 'result',\n  these functions will block until the HTTP request is completed.\n\n  If you want to check if an HTTP request is finished without\n  blocking, use the 'done?' function.\n\n  A single GET request could be as simple as:\n\n    (string (http-agent \"http://www.stuartsierra.com/\"))\n\n  A simple POST might look like:\n\n    (http-agent \"http...\" :method \"POST\" :body \"foo=1\")\n\n  And you could write the response directly to a file like this:\n\n    (require '[clojure.contrib.io :as d])\n\n    (http-agent \"http...\"\n                :handler (fn [agnt] \n                           (with-open [w (d/writer \"/tmp/out\")] \n                             (d/copy (stream agnt) w))))\n", Keyword.intern((Symbol)Symbol.create(null, (String)"author")), "Stuart Sierra"}));
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"with-loading-context");
    public static final Var const__4 = RT.var((String)"clojure.core", (String)"fn");
    public static final Var const__5 = RT.var((String)"clojure.core", (String)"declare");
    public static final Var const__6 = RT.var((String)"clojure.contrib.http.agent", (String)"result");
    public static final Keyword const__7 = Keyword.intern((Symbol)Symbol.create(null, (String)"file"));
    public static final Keyword const__8 = Keyword.intern((Symbol)Symbol.create(null, (String)"line"));
    public static final Object const__9 = 79;
    public static final Keyword const__10 = Keyword.intern((Symbol)Symbol.create(null, (String)"declared"));
    public static final Var const__11 = RT.var((String)"clojure.contrib.http.agent", (String)"stream");
    public static final Var const__12 = RT.var((String)"clojure.core", (String)"defn-");
    public static final Var const__13 = RT.var((String)"clojure.core", (String)"defn");
    public static final Var const__14 = RT.var((String)"clojure.contrib.http.agent", (String)"setup-http-connection");
    public static final Object const__15 = 81;
    public static final Keyword const__16 = Keyword.intern((Symbol)Symbol.create(null, (String)"arglists"));
    public static final Object const__17 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{((IObj)Symbol.create(null, (String)"conn")).withMeta(RT.map((Object[])new Object[]{Keyword.intern((Symbol)Symbol.create(null, (String)"tag")), Symbol.create(null, (String)"HttpURLConnection")})), Symbol.create(null, (String)"options")})));
    public static final Keyword const__18 = Keyword.intern((Symbol)Symbol.create(null, (String)"doc"));
    public static final Keyword const__19 = Keyword.intern((Symbol)Symbol.create(null, (String)"private"));
    public static final Var const__20 = RT.var((String)"clojure.contrib.http.agent", (String)"start-request");
    public static final Object const__21 = 94;
    public static final Object const__22 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"state"), Symbol.create(null, (String)"options")})));
    public static final Var const__23 = RT.var((String)"clojure.contrib.http.agent", (String)"connection-success?");
    public static final Object const__24 = 102;
    public static final Object const__25 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{((IObj)Symbol.create(null, (String)"conn")).withMeta(RT.map((Object[])new Object[]{Keyword.intern((Symbol)Symbol.create(null, (String)"tag")), Symbol.create(null, (String)"HttpURLConnection")}))})));
    public static final Var const__26 = RT.var((String)"clojure.contrib.http.agent", (String)"open-response");
    public static final Object const__27 = 107;
    public static final Object const__28 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"state"), Symbol.create(null, (String)"options")})));
    public static final Var const__29 = RT.var((String)"clojure.contrib.http.agent", (String)"handle-response");
    public static final Object const__30 = 118;
    public static final Object const__31 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"state"), Symbol.create(null, (String)"handler"), Symbol.create(null, (String)"options")})));
    public static final Var const__32 = RT.var((String)"clojure.contrib.http.agent", (String)"disconnect");
    public static final Object const__33 = 128;
    public static final Object const__34 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"state"), Symbol.create(null, (String)"options")})));
    public static final Var const__35 = RT.var((String)"clojure.contrib.http.agent", (String)"status-in-range?");
    public static final Object const__36 = 139;
    public static final Object const__37 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"digit"), Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__38 = RT.var((String)"clojure.contrib.http.agent", (String)"get-byte-buffer");
    public static final Object const__39 = 147;
    public static final Object const__40 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Keyword const__41 = Keyword.intern((Symbol)Symbol.create(null, (String)"tag"));
    public static final Object const__42 = Class.forName("java.io.ByteArrayOutputStream");
    public static final Var const__43 = RT.var((String)"clojure.contrib.http.agent", (String)"buffer-bytes");
    public static final Object const__44 = 154;
    public static final Object const__45 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__46 = RT.var((String)"clojure.contrib.http.agent", (String)"*http-agent-defaults*");
    public static final Object const__47 = 166;
    public static final Keyword const__48 = Keyword.intern((Symbol)Symbol.create(null, (String)"method"));
    public static final Keyword const__49 = Keyword.intern((Symbol)Symbol.create(null, (String)"headers"));
    public static final Keyword const__50 = Keyword.intern((Symbol)Symbol.create(null, (String)"body"));
    public static final Keyword const__51 = Keyword.intern((Symbol)Symbol.create(null, (String)"connect-timeout"));
    public static final Object const__52 = 0;
    public static final Keyword const__53 = Keyword.intern((Symbol)Symbol.create(null, (String)"read-timeout"));
    public static final Keyword const__54 = Keyword.intern((Symbol)Symbol.create(null, (String)"follow-redirects"));
    public static final Keyword const__55 = Keyword.intern((Symbol)Symbol.create(null, (String)"handler"));
    public static final Var const__56 = RT.var((String)"clojure.contrib.http.agent", (String)"http-agent");
    public static final Object const__57 = 175;
    public static final Object const__58 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"uri"), Symbol.create(null, (String)"&"), Symbol.create(null, (String)"options")})));
    public static final Object const__59 = 238;
    public static final Object const__60 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Object const__61 = 246;
    public static final Object const__62 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__63 = RT.var((String)"clojure.contrib.http.agent", (String)"bytes");
    public static final Object const__64 = 260;
    public static final Object const__65 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__66 = RT.var((String)"clojure.contrib.http.agent", (String)"string");
    public static final Object const__67 = 266;
    public static final Object const__68 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")}), RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt"), ((IObj)Symbol.create(null, (String)"encoding")).withMeta(RT.map((Object[])new Object[]{Keyword.intern((Symbol)Symbol.create(null, (String)"tag")), Symbol.create(null, (String)"String")}))})));
    public static final Var const__69 = RT.var((String)"clojure.contrib.http.agent", (String)"request-uri");
    public static final Object const__70 = 284;
    public static final Object const__71 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__72 = RT.var((String)"clojure.contrib.http.agent", (String)"request-headers");
    public static final Object const__73 = 289;
    public static final Object const__74 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__75 = RT.var((String)"clojure.contrib.http.agent", (String)"method");
    public static final Object const__76 = 294;
    public static final Object const__77 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__78 = RT.var((String)"clojure.contrib.http.agent", (String)"request-body");
    public static final Object const__79 = 299;
    public static final Object const__80 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__81 = RT.var((String)"clojure.contrib.http.agent", (String)"done?");
    public static final Object const__82 = 310;
    public static final Object const__83 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__84 = RT.var((String)"clojure.contrib.http.agent", (String)"status");
    public static final Object const__85 = 316;
    public static final Object const__86 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__87 = RT.var((String)"clojure.contrib.http.agent", (String)"message");
    public static final Object const__88 = 324;
    public static final Object const__89 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__90 = RT.var((String)"clojure.contrib.http.agent", (String)"headers");
    public static final Object const__91 = 331;
    public static final Object const__92 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__93 = RT.var((String)"clojure.contrib.http.agent", (String)"headers-seq");
    public static final Object const__94 = 341;
    public static final Object const__95 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__96 = RT.var((String)"clojure.contrib.http.agent", (String)"success?");
    public static final Object const__97 = 357;
    public static final Object const__98 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__99 = RT.var((String)"clojure.contrib.http.agent", (String)"redirect?");
    public static final Object const__100 = 362;
    public static final Object const__101 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__102 = RT.var((String)"clojure.contrib.http.agent", (String)"client-error?");
    public static final Object const__103 = 371;
    public static final Object const__104 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__105 = RT.var((String)"clojure.contrib.http.agent", (String)"server-error?");
    public static final Object const__106 = 376;
    public static final Object const__107 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));
    public static final Var const__108 = RT.var((String)"clojure.contrib.http.agent", (String)"error?");
    public static final Object const__109 = 381;
    public static final Object const__110 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"http-agnt")})));

    public static void load() {
        Object object = ((IFn)const__1.get()).invoke((Object)const__2);
        Object object2 = ((IFn)new agent$loading__4410__auto__(null)).invoke();
        Var var = const__6;
        Var var2 = const__11;
        Var var3 = const__14;
        var3.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__15, const__16, const__17, const__18, "Sets the instance method, redirect behavior, and request headers of\n  the HttpURLConnection.", const__19, Boolean.TRUE}));
        Var var4 = var3;
        var3.bindRoot((Object)((IObj)new agent$setup_http_connection(null)).withMeta(((AReference)const__14).meta()));
        Var var5 = const__20;
        var5.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__21, const__16, const__22, const__18, "Agent action that starts sending the HTTP request.", const__19, Boolean.TRUE}));
        Var var6 = var5;
        var5.bindRoot((Object)((IObj)new agent$start_request(null)).withMeta(((AReference)const__20).meta()));
        Var var7 = const__23;
        var7.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__24, const__16, const__25, const__19, Boolean.TRUE}));
        Var var8 = var7;
        var7.bindRoot((Object)((IObj)new agent$connection_success_QMARK_(null)).withMeta(((AReference)const__23).meta()));
        Var var9 = const__26;
        var9.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__27, const__16, const__28, const__18, "Agent action that opens the response body stream on the HTTP\n  request; this will block until the response stream is available.", const__19, Boolean.TRUE}));
        Var var10 = var9;
        var9.bindRoot((Object)((IObj)new agent$open_response(null)).withMeta(((AReference)const__26).meta()));
        Var var11 = const__29;
        var11.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__30, const__16, const__31, const__18, "Agent action that calls the provided handler function, with no\n  arguments, and sets the ::result key of the agent to the handler's\n  return value.", const__19, Boolean.TRUE}));
        Var var12 = var11;
        var11.bindRoot((Object)((IObj)new agent$handle_response(null)).withMeta(((AReference)const__29).meta()));
        Var var13 = const__32;
        var13.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__33, const__16, const__34, const__18, "Agent action that closes the response body stream and disconnects\n  the HttpURLConnection.", const__19, Boolean.TRUE}));
        Var var14 = var13;
        var13.bindRoot((Object)((IObj)new agent$disconnect(null)).withMeta(((AReference)const__32).meta()));
        Var var15 = const__35;
        var15.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__36, const__16, const__37, const__18, "Returns true if the response status of the HTTP agent begins with\n  digit, an Integer.", const__19, Boolean.TRUE}));
        Var var16 = var15;
        var15.bindRoot((Object)((IObj)new agent$status_in_range_QMARK_(null)).withMeta(((AReference)const__35).meta()));
        Var var17 = const__38;
        var17.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__39, const__16, const__40, const__19, Boolean.TRUE, const__41, const__42}));
        Var var18 = var17;
        var17.bindRoot((Object)((IObj)new agent$get_byte_buffer(null)).withMeta(((AReference)const__38).meta()));
        Var var19 = const__43;
        var19.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__44, const__16, const__45, const__18, "The default HTTP agent result handler; it collects the response\n  body in a java.io.ByteArrayOutputStream, which can later be\n  retrieved with the 'stream', 'string', and 'bytes' functions."}));
        Var var20 = var19;
        var19.bindRoot((Object)((IObj)new agent$buffer_bytes(null)).withMeta(((AReference)const__43).meta()));
        Var var21 = const__46;
        var21.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__47}));
        Var var22 = var21;
        var21.bindRoot((Object)RT.map((Object[])new Object[]{const__48, "GET", const__49, PersistentArrayMap.EMPTY, const__50, null, const__51, const__52, const__53, const__52, const__54, Boolean.TRUE, const__55, const__43.get()}));
        Var var23 = const__56;
        var23.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__57, const__16, const__58, const__18, "Creates (and immediately returns) an Agent representing an HTTP\n  request running in a new thread.\n\n  options are key/value pairs:\n\n  :method string\n\n  The HTTP method name.  Default is \"GET\".\n\n  :headers h\n\n  HTTP headers, as a Map or a sequence of pairs like \n  ([key1,value1], [key2,value2])  Default is nil.\n\n  :body b\n  \n  HTTP request entity body, one of nil, String, byte[], InputStream,\n  Reader, or File.  Default is nil.\n\n  :connect-timeout int\n\n  Timeout value, in milliseconds, when opening a connection to the\n  URL.  Default is zero, meaning no timeout.\n\n  :read-timeout int\n\n  Timeout value, in milliseconds, when reading data from the\n  connection.  Default is zero, meaning no timeout.\n\n  :follow-redirects boolean\n\n  If true, HTTP 3xx redirects will be followed automatically.  Default\n  is true.\n\n  :handler f\n\n  Function to be called when the HTTP response body is ready.  If you\n  do not provide a handler function, the default is to buffer the\n  entire response body in memory.\n\n  The handler function will be called with the HTTP agent as its\n  argument, and can use the 'stream' function to read the response\n  body.  The return value of this function will be stored in the state\n  of the agent and can be retrieved with the 'result' function.  Any\n  exceptions thrown by this function will be added to the agent's\n  error queue (see agent-errors).  The default function collects the\n  response stream in a memory buffer.\n  "}));
        Var var24 = var23;
        var23.bindRoot((Object)((IObj)new agent$http_agent(null)).withMeta(((AReference)const__56).meta()));
        Var var25 = const__6;
        var25.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__59, const__16, const__60, const__18, "Returns the value returned by the :handler function of the HTTP\n  agent; blocks until the HTTP request is completed.  The default\n  handler function returns a ByteArrayOutputStream."}));
        Var var26 = var25;
        var25.bindRoot((Object)((IObj)new agent$result(null)).withMeta(((AReference)const__6).meta()));
        Var var27 = const__11;
        var27.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__61, const__16, const__62, const__18, "Returns an InputStream of the HTTP response body.  When called by\n  the handler function passed to http-agent, this is the raw\n  HttpURLConnection stream.\n\n  If the default handler function was used, this function returns a\n  ByteArrayInputStream on the buffered response body."}));
        Var var28 = var27;
        var27.bindRoot((Object)((IObj)new agent$stream(null)).withMeta(((AReference)const__11).meta()));
        Var var29 = const__63;
        var29.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__64, const__16, const__65, const__18, "Returns a Java byte array of the content returned by the server;\n  nil if the content is not yet available."}));
        Var var30 = var29;
        var29.bindRoot((Object)((IObj)new agent$bytes(null)).withMeta(((AReference)const__63).meta()));
        Var var31 = const__66;
        var31.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__67, const__16, const__68, const__18, "Returns the HTTP response body as a string, using the given\n  encoding.\n\n  If no encoding is given, uses the encoding specified in the server\n  headers, or clojure.contrib.io/*default-encoding* if it is\n  not specified."}));
        Var var32 = var31;
        var31.bindRoot((Object)((IObj)new agent$string(null)).withMeta(((AReference)const__66).meta()));
        Var var33 = const__69;
        var33.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__70, const__16, const__71, const__18, "Returns the URI/URL requested by this HTTP agent, as a String."}));
        Var var34 = var33;
        var33.bindRoot((Object)((IObj)new agent$request_uri(null)).withMeta(((AReference)const__69).meta()));
        Var var35 = const__72;
        var35.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__73, const__16, const__74, const__18, "Returns the request headers specified for this HTTP agent."}));
        Var var36 = var35;
        var35.bindRoot((Object)((IObj)new agent$request_headers(null)).withMeta(((AReference)const__72).meta()));
        Var var37 = const__75;
        var37.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__76, const__16, const__77, const__18, "Returns the HTTP method name used by this HTTP agent, as a String."}));
        Var var38 = var37;
        var37.bindRoot((Object)((IObj)new agent$method(null)).withMeta(((AReference)const__75).meta()));
        Var var39 = const__78;
        var39.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__79, const__16, const__80, const__18, "Returns the HTTP request body given to this HTTP agent.  \n\n  Note: if the request body was an InputStream or a Reader, it will no\n  longer be usable."}));
        Var var40 = var39;
        var39.bindRoot((Object)((IObj)new agent$request_body(null)).withMeta(((AReference)const__78).meta()));
        Var var41 = const__81;
        var41.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__82, const__16, const__83, const__18, "Returns true if the HTTP request/response has completed."}));
        Var var42 = var41;
        var41.bindRoot((Object)((IObj)new agent$done_QMARK_(null)).withMeta(((AReference)const__81).meta()));
        Var var43 = const__84;
        var43.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__85, const__16, const__86, const__18, "Returns the HTTP response status code (e.g. 200, 404) for this\n  request, as an Integer, or nil if the status has not yet been\n  received."}));
        Var var44 = var43;
        var43.bindRoot((Object)((IObj)new agent$status(null)).withMeta(((AReference)const__84).meta()));
        Var var45 = const__87;
        var45.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__88, const__16, const__89, const__18, "Returns the HTTP response message (e.g. 'Not Found'), for this\n  request, or nil if the response has not yet been received."}));
        Var var46 = var45;
        var45.bindRoot((Object)((IObj)new agent$message(null)).withMeta(((AReference)const__87).meta()));
        Var var47 = const__90;
        var47.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__91, const__16, const__92, const__18, "Returns a map of HTTP response headers.  Header names are converted\n  to keywords in all lower-case Header values are strings.  If a\n  header appears more than once, only the last value is returned."}));
        Var var48 = var47;
        var47.bindRoot((Object)((IObj)new agent$headers(null)).withMeta(((AReference)const__90).meta()));
        Var var49 = const__93;
        var49.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__94, const__16, const__95, const__18, "Returns the HTTP response headers in order as a sequence of\n  [String,String] pairs.  The first 'header' name may be null for the\n  HTTP status line."}));
        Var var50 = var49;
        var49.bindRoot((Object)((IObj)new agent$headers_seq(null)).withMeta(((AReference)const__93).meta()));
        Var var51 = const__96;
        var51.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__97, const__16, const__98, const__18, "Returns true if the HTTP response code was in the 200-299 range."}));
        Var var52 = var51;
        var51.bindRoot((Object)((IObj)new agent$success_QMARK_(null)).withMeta(((AReference)const__96).meta()));
        Var var53 = const__99;
        var53.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__100, const__16, const__101, const__18, "Returns true if the HTTP response code was in the 300-399 range.\n\n  Note: if the :follow-redirects option was true (the default),\n  redirects will be followed automatically and a the agent will never\n  return a 3xx response code."}));
        Var var54 = var53;
        var53.bindRoot((Object)((IObj)new agent$redirect_QMARK_(null)).withMeta(((AReference)const__99).meta()));
        Var var55 = const__102;
        var55.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__103, const__16, const__104, const__18, "Returns true if the HTTP response code was in the 400-499 range."}));
        Var var56 = var55;
        var55.bindRoot((Object)((IObj)new agent$client_error_QMARK_(null)).withMeta(((AReference)const__102).meta()));
        Var var57 = const__105;
        var57.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__106, const__16, const__107, const__18, "Returns true if the HTTP response code was in the 500-599 range."}));
        Var var58 = var57;
        var57.bindRoot((Object)((IObj)new agent$server_error_QMARK_(null)).withMeta(((AReference)const__105).meta()));
        Var var59 = const__108;
        var59.setMeta(RT.map((Object[])new Object[]{const__7, "clojure/contrib/http/agent.clj", const__8, const__109, const__16, const__110, const__18, "Returns true if the HTTP response code was in the 400-499 range OR\n  the 500-599 range."}));
        Var var60 = var59;
        var59.bindRoot((Object)((IObj)new agent$error_QMARK_(null)).withMeta(((AReference)const__108).meta()));
    }

    static {
        Compiler.pushNS();
        try {
            agent__init.load();
        }
        catch (Throwable throwable) {
            Var.popThreadBindings();
            throw throwable;
        }
        Var.popThreadBindings();
    }
}

