(ns ardoq.azure.apis)

(def PeeringManagementClient 
  {:scheme "https",
   :host "management.azure.com",
   :info {:description "APIs to manage Peering resources through the Azure Resource Manager.",
          :title "PeeringManagementClient",
          :version "2019-08-01-preview"},
   :ops {:PeeringLocations_List {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/peeringLocations",
                                 :description "Lists all of the available peering locations for the specified kind of peering.",
                                 :parameters [{:description "The kind of the peering.",
                                               :enum ["Direct"
                                                      "Exchange"],
                                               :in "query",
                                               :name "kind",
                                               :required true,
                                               :type "string"}
                                              {:description "The type of direct peering.",
                                               :enum ["Edge"
                                                      "Transit"
                                                      "Cdn"
                                                      "Internal"],
                                               :in "query",
                                               :name "directPeeringType",
                                               :required false,
                                               :type "string"}
                                              {:reference/parameters "SubscriptionIdParameter"}
                                              {:reference/parameters "ApiVersionParameter"}]},
         :PeerAsns_ListBySubscription {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/peerAsns",
                                       :description "Lists all of the peer ASNs under the given subscription.",
                                       :parameters [{:reference/parameters "SubscriptionIdParameter"}
                                                    {:reference/parameters "ApiVersionParameter"}]},
         :PeerAsns_Get {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/peerAsns/{peerAsnName}",
                        :description "Gets the peer ASN with the specified name under the given subscription.",
                        :parameters [{:description "The peer ASN name.",
                                      :in "path",
                                      :name "peerAsnName",
                                      :required true,
                                      :type "string"}
                                     {:reference/parameters "SubscriptionIdParameter"}
                                     {:reference/parameters "ApiVersionParameter"}]},
         :PeeringServices_ListByResourceGroup {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices",
                                               :description "Lists all of the peering services under the given subscription and resource group.",
                                               :parameters [{:description "The name of the resource group.",
                                                             :in "path",
                                                             :name "resourceGroupName",
                                                             :required true,
                                                             :type "string"}
                                                            {:reference/parameters "SubscriptionIdParameter"}
                                                            {:reference/parameters "ApiVersionParameter"}]},
         :PeeringServiceLocations_List {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/peeringServiceLocations",
                                        :description "Lists all of the available peering service locations for the specified kind of peering.",
                                        :parameters [{:reference/parameters "SubscriptionIdParameter"}
                                                     {:reference/parameters "ApiVersionParameter"}]},
         :PeeringServices_CreateOrUpdate {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}",
                                          :description "Creates a new peering service or updates an existing peering with the specified name under the given subscription and resource group.",
                                          :parameters [{:description "The name of the resource group.",
                                                        :in "path",
                                                        :name "resourceGroupName",
                                                        :required true,
                                                        :type "string"}
                                                       {:description "The name of the peering service.",
                                                        :in "path",
                                                        :name "peeringServiceName",
                                                        :required true,
                                                        :type "string"}
                                                       {:description "The properties needed to create or update a peering service.",
                                                        :in "body",
                                                        :name "peeringService",
                                                        :required true,
                                                        :schema {:reference/definitions "PeeringService"}}
                                                       {:reference/parameters "SubscriptionIdParameter"}
                                                       {:reference/parameters "ApiVersionParameter"}]},
         :Peerings_Delete {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}",
                           :description "Deletes an existing peering with the specified name under the given subscription and resource group.",
                           :parameters [{:description "The name of the resource group.",
                                         :in "path",
                                         :name "resourceGroupName",
                                         :required true,
                                         :type "string"}
                                        {:description "The name of the peering.",
                                         :in "path",
                                         :name "peeringName",
                                         :required true,
                                         :type "string"}
                                        {:reference/parameters "SubscriptionIdParameter"}
                                        {:reference/parameters "ApiVersionParameter"}]},
         :PeeringServices_Delete {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}",
                                  :description "Deletes an existing peering service with the specified name under the given subscription and resource group.",
                                  :parameters [{:description "The name of the resource group.",
                                                :in "path",
                                                :name "resourceGroupName",
                                                :required true,
                                                :type "string"}
                                               {:description "The name of the peering service.",
                                                :in "path",
                                                :name "peeringServiceName",
                                                :required true,
                                                :type "string"}
                                               {:reference/parameters "SubscriptionIdParameter"}
                                               {:reference/parameters "ApiVersionParameter"}]},
         :PeeringServices_ListBySubscription {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/peeringServices",
                                              :description "Lists all of the peerings under the given subscription.",
                                              :parameters [{:reference/parameters "SubscriptionIdParameter"}
                                                           {:reference/parameters "ApiVersionParameter"}]},
         :PeerAsns_Delete {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/peerAsns/{peerAsnName}",
                           :description "Deletes an existing peer ASN with the specified name under the given subscription.",
                           :parameters [{:description "The peer ASN name.",
                                         :in "path",
                                         :name "peerAsnName",
                                         :required true,
                                         :type "string"}
                                        {:reference/parameters "SubscriptionIdParameter"}
                                        {:reference/parameters "ApiVersionParameter"}]},
:CheckServiceProviderAvailability {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/CheckServiceProviderAvailability",
                                   :description "Checks if the peering service provider is present within 1000 miles of customer's location",
                                   :parameters [{:description "The CheckServiceProviderAvailabilityInput\r\n            indicating customer location and service provider.",
                                                 :in "body",
                                                 :name "checkServiceProviderAvailabilityInput",
                                                 :required true,
                                                 :schema {:reference/definitions "CheckServiceProviderAvailabilityInput"}}
                                                {:reference/parameters "SubscriptionIdParameter"}
                                                {:reference/parameters "ApiVersionParameter"}]},
:Peerings_Update {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}",
                  :description "Updates tags for a peering with the specified name under the given subscription and resource group.",
                  :parameters [{:description "The name of the resource group.",
                                :in "path",
                                :name "resourceGroupName",
                                :required true,
                                :type "string"}
                               {:description "The name of the peering.",
                                :in "path",
                                :name "peeringName",
                                :required true,
                                :type "string"}
                               {:description "The resource tags.",
                                :in "body",
                                :name "tags",
                                :required true,
                                :schema {:reference/definitions "ResourceTags"}}
                               {:reference/parameters "SubscriptionIdParameter"}
                               {:reference/parameters "ApiVersionParameter"}]},
:PeeringServicePrefixes_Get {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/prefixes/{prefixName}",
                             :description "Gets the peering service prefix.",
                             :parameters [{:description "The resource group name.",
                                           :in "path",
                                           :name "resourceGroupName",
                                           :required true,
                                           :type "string"}
                                          {:description "The peering service name.",
                                           :in "path",
                                           :name "peeringServiceName",
                                           :required true,
                                           :type "string"}
                                          {:description "The prefix name.",
                                           :in "path",
                                           :name "prefixName",
                                           :required true,
                                           :type "string"}
                                          {:reference/parameters "SubscriptionIdParameter"}
                                          {:reference/parameters "ApiVersionParameter"}]},
:Peerings_ListBySubscription {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/peerings",
                              :description "Lists all of the peerings under the given subscription.",
                              :parameters [{:reference/parameters "SubscriptionIdParameter"}
                                           {:reference/parameters "ApiVersionParameter"}]},
:Prefixes_ListByPeeringService {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/prefixes",
                                :description "Lists the peerings prefix in the resource group.",
                                :parameters [{:description "The resource group name.",
                                              :in "path",
                                              :name "resourceGroupName",
                                              :required true,
                                              :type "string"}
                                             {:description "The peering service name.",
                                              :in "path",
                                              :name "peeringServiceName",
                                              :required true,
                                              :type "string"}
                                             {:reference/parameters "SubscriptionIdParameter"}
                                             {:reference/parameters "ApiVersionParameter"}]},
:PeeringServicePrefixes_CreateOrUpdate {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/prefixes/{prefixName}",
                                        :description "Creates or updates the peering prefix.",
                                        :parameters [{:description "The resource group name.",
                                                      :in "path",
                                                      :name "resourceGroupName",
                                                      :required true,
                                                      :type "string"}
                                                     {:description "The peering service name.",
                                                      :in "path",
                                                      :name "peeringServiceName",
                                                      :required true,
                                                      :type "string"}
                                                     {:description "The prefix name",
                                                      :in "path",
                                                      :name "prefixName",
                                                      :required true,
                                                      :type "string"}
                                                     {:description "The IP prefix for an peering",
                                                      :in "body",
                                                      :name "peeringServicePrefix",
                                                      :required true,
                                                      :schema {:reference/definitions "PeeringServicePrefix"}}
                                                     {:reference/parameters "SubscriptionIdParameter"}
                                                     {:reference/parameters "ApiVersionParameter"}]},
:LegacyPeerings_List {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/legacyPeerings",
                      :description "Lists all of the legacy peerings under the given subscription matching the specified kind and location.",
                      :parameters [{:description "The location of the peering.",
                                    :in "query",
                                    :name "peeringLocation",
                                    :required true,
                                    :type "string"}
                                   {:description "The kind of the peering.",
                                    :enum ["Direct" "Exchange"],
                                    :in "query",
                                    :name "kind",
                                    :required true,
                                    :type "string"}
                                   {:reference/parameters "SubscriptionIdParameter"}
                                   {:reference/parameters "ApiVersionParameter"}]},
:Peerings_Get {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}",
               :description "Gets an existing peering with the specified name under the given subscription and resource group.",
               :parameters [{:description "The name of the resource group.",
                             :in "path",
                             :name "resourceGroupName",
                             :required true,
                             :type "string"}
                            {:description "The name of the peering.",
                             :in "path",
                             :name "peeringName",
                             :required true,
                             :type "string"}
                            {:reference/parameters "SubscriptionIdParameter"}
                            {:reference/parameters "ApiVersionParameter"}]},
:PeeringServices_Update {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}",
                         :description "Updates tags for a peering service with the specified name under the given subscription and resource group.",
                         :parameters [{:description "The name of the resource group.",
                                       :in "path",
                                       :name "resourceGroupName",
                                       :required true,
                                       :type "string"}
                                      {:description "The name of the peering service.",
                                       :in "path",
                                       :name "peeringServiceName",
                                       :required true,
                                       :type "string"}
                                      {:description "The resource tags.",
                                       :in "body",
                                       :name "tags",
                                       :required true,
                                       :schema {:reference/definitions "ResourceTags"}}
                                      {:reference/parameters "SubscriptionIdParameter"}
                                      {:reference/parameters "ApiVersionParameter"}]},
:PeeringServicePrefixes_Delete {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/prefixes/{prefixName}",
                                :description "removes the peering prefix.",
                                :parameters [{:description "The resource group name.",
                                              :in "path",
                                              :name "resourceGroupName",
                                              :required true,
                                              :type "string"}
                                             {:description "The peering service name.",
                                              :in "path",
                                              :name "peeringServiceName",
                                              :required true,
                                              :type "string"}
                                             {:description "The prefix name",
                                              :in "path",
                                              :name "prefixName",
                                              :required true,
                                              :type "string"}
                                             {:reference/parameters "SubscriptionIdParameter"}
                                             {:reference/parameters "ApiVersionParameter"}]},
:PeerAsns_CreateOrUpdate {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/peerAsns/{peerAsnName}",
                          :description "Creates a new peer ASN or updates an existing peer ASN with the specified name under the given subscription.",
                          :parameters [{:description "The peer ASN name.",
                                        :in "path",
                                        :name "peerAsnName",
                                        :required true,
                                        :type "string"}
                                       {:description "The peer ASN.",
                                        :in "body",
                                        :name "peerAsn",
                                        :required true,
                                        :schema {:reference/definitions "PeerAsn"}}
                                       {:reference/parameters "SubscriptionIdParameter"}
                                       {:reference/parameters "ApiVersionParameter"}]},
:Peerings_ListByResourceGroup {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings",
                               :description "Lists all of the peerings under the given subscription and resource group.",
                               :parameters [{:description "The name of the resource group.",
                                             :in "path",
                                             :name "resourceGroupName",
                                             :required true,
                                             :type "string"}
                                            {:reference/parameters "SubscriptionIdParameter"}
                                            {:reference/parameters "ApiVersionParameter"}]},
:PeeringServices_Get {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}",
                      :description "Gets an existing peering service with the specified name under the given subscription and resource group.",
                      :parameters [{:description "The name of the resource group.",
                                    :in "path",
                                    :name "resourceGroupName",
                                    :required true,
                                    :type "string"}
                                   {:description "The name of the peering.",
                                    :in "path",
                                    :name "peeringServiceName",
                                    :required true,
                                    :type "string"}
                                   {:reference/parameters "SubscriptionIdParameter"}
                                   {:reference/parameters "ApiVersionParameter"}]},
:PeeringServiceProviders_List {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/peeringServiceProviders",
                               :description "Lists all of the available peering service locations for the specified kind of peering.",
                               :parameters [{:reference/parameters "SubscriptionIdParameter"}
                                            {:reference/parameters "ApiVersionParameter"}]},
:Operations_List {:path "/providers/Microsoft.Peering/operations",
                  :description "Lists all of the available API operations for peering resources.",
                  :parameters [{:reference/parameters "ApiVersionParameter"}]},
:Peerings_CreateOrUpdate {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}",
                          :description "Creates a new peering or updates an existing peering with the specified name under the given subscription and resource group.",
                          :parameters [{:description "The name of the resource group.",
                                        :in "path",
                                        :name "resourceGroupName",
                                        :required true,
                                        :type "string"}
                                       {:description "The name of the peering.",
                                        :in "path",
                                        :name "peeringName",
                                        :required true,
                                        :type "string"}
                                       {:description "The properties needed to create or update a peering.",
                                        :in "body",
                                        :name "peering",
                                        :required true,
                                        :schema {:reference/definitions "Peering"}}
                                       {:reference/parameters "SubscriptionIdParameter"}
                                       {:reference/parameters "ApiVersionParameter"}]}},
:parameters {:ApiVersionParameter {:description "The client API version.",
                                   :in "query",
                                   :name "api-version",
                                   :required true,
                                   :type "string"},
             :SubscriptionIdParameter {:description "The Azure subscription ID.",
                                       :in "path",
                                       :name "subscriptionId",
                                       :required true,
                                       :type "string"}},
:definitions {:PeeringServiceProviderProperties {:description "The properties that define connectivity to the Peering Service Provider.",
                                                 :properties {:serviceProviderName {:description "The name of the service provider.",
                                                                                    :type "string"}},
                                                 :type "object"},
              :PeeringPropertiesExchange {:description "The properties that define an exchange peering.",
                                          :properties {:connections {:description "The set of connections that constitute an exchange peering.",
                                                                     :items {:reference/definitions "ExchangeConnection"},
                                                                     :type "array"},
                                                       :peerAsn {:reference/definitions "SubResource"}},
                                          :type "object"},
              :PeeringListResult {:description "The paginated list of peerings.",
                                  :properties {:nextLink {:description "The link to fetch the next page of peerings.",
                                                          :type "string"},
                                               :value {:description "The list of peerings.",
                                                       :items {:reference/definitions "Peering"},
                                                       :type "array"}},
                                  :type "object"},
              :PeeringSku {:description "The SKU that defines the tier and kind of the peering.",
                           :properties {:family {:description "The family of the peering SKU.",
                                                 :enum ["Direct"
                                                        "Exchange"],
                                                 :type "string",
                                                 :x-ms-enum {:modelAsString true,
                                                             :name "family"}},
                                        :name {:description "The name of the peering SKU.",
                                               :enum ["Basic_Exchange_Free"
                                                      "Basic_Direct_Free"
                                                      "Premium_Direct_Free"
                                                      "Premium_Exchange_Metered"
                                                      "Premium_Direct_Metered"
                                                      "Premium_Direct_Unlimited"],
                                               :type "string",
                                               :x-ms-enum {:modelAsString true,
                                                           :name "name"}},
                                        :size {:description "The size of the peering SKU.",
                                               :enum ["Free"
                                                      "Metered"
                                                      "Unlimited"],
                                               :type "string",
                                               :x-ms-enum {:modelAsString true,
                                                           :name "size"}},
                                        :tier {:description "The tier of the peering SKU.",
                                               :enum ["Basic"
                                                      "Premium"],
                                               :type "string",
                                               :x-ms-enum {:modelAsString true,
                                                           :name "tier"}}},
                           :type "object"},
              :OperationListResult {:description "The paginated list of peering API operations.",
                                    :properties {:nextLink {:description "The link to fetch the next page of peering API operations.",
                                                            :type "string"},
                                                 :value {:description "The list of peering API operations.",
                                                         :items {:reference/definitions "Operation"},
                                                         :type "array"}},
                                    :type "object"},
              :ContactInfo {:description "The contact information of the peer.",
                            :properties {:emails {:description "The list of email addresses.",
                                                  :items {:type "string"},
                                                  :type "array"},
                                         :phone {:description "The list of contact numbers.",
                                                 :items {:type "string"},
                                                 :type "array"}},
                            :type "object"},
              :Operation {:description "The peering API operation.",
                          :properties {:display {:reference/definitions "OperationDisplayInfo"},
                                       :isDataAction {:description "The flag that indicates whether the operation applies to data plane.",
                                                      :readOnly true,
                                                      :type "boolean"},
                                       :name {:description "The name of the operation.",
                                              :readOnly true,
                                              :type "string"}},
                          :type "object"},
              :PeeringProperties {:description "The properties that define connectivity to the Microsoft Cloud Edge.",
                                  :properties {:direct {:reference/definitions "PeeringPropertiesDirect"},
                                               :exchange {:reference/definitions "PeeringPropertiesExchange"},
                                               :peeringLocation {:description "The location of the peering.",
                                                                 :type "string"},
                                               :provisioningState {:description "The provisioning state of the resource.",
                                                                   :enum ["Succeeded"
                                                                          "Updating"
                                                                          "Deleting"
                                                                          "Failed"],
                                                                   :readOnly true,
                                                                   :type "string",
                                                                   :x-ms-enum {:modelAsString true,
                                                                               :name "provisioningState"}}},
                                  :type "object"},
              :PeeringService {:allOf [{:reference/definitions "Resource"}],
                               :description "Peering Service",
                               :properties {:location {:description "The location of the resource.",
                                                       :type "string",
                                                       :x-ms-mutability ["read"
                                                                         "create"]},
                                            :properties {:reference/definitions "PeeringServiceProperties"},
                                            :tags {:additionalProperties {:type "string"},
                                                   :description "The resource tags.",
                                                   :type "object"}},
                               :required ["location"],
                               :type "object"},
              :Peering {:allOf [{:reference/definitions "Resource"}],
                        :description "Peering is a logical representation of a set of connections to the Microsoft Cloud Edge at a location.",
                        :properties {:kind {:description "The kind of the peering.",
                                            :enum ["Direct"
                                                   "Exchange"],
                                            :type "string",
                                            :x-ms-enum {:modelAsString true,
                                                        :name "kind"}},
                                     :location {:description "The location of the resource.",
                                                :type "string",
                                                :x-ms-mutability ["read"
                                                                  "create"]},
                                     :properties {:reference/definitions "PeeringProperties"},
                                     :sku {:reference/definitions "PeeringSku"},
                                     :tags {:additionalProperties {:type "string"},
                                            :description "The resource tags.",
                                            :type "object"}},
                        :required ["sku" "kind" "location"],
                        :type "object"},
:PeeringServiceLocation {:allOf [{:reference/definitions "Resource"}],
                         :description "PeeringService location",
                         :properties {:properties {:reference/definitions "PeeringServiceLocationProperties"}},
                         :type "object"},
:PeeringLocationPropertiesExchange {:description "The properties that define an exchange peering location.",
                                    :properties {:peeringFacilities {:description "The list of exchange peering facilities at the peering location.",
                                                                     :items {:reference/definitions "ExchangePeeringFacility"},
                                                                     :type "array"}},
                                    :type "object"},
:PeeringLocation {:allOf [{:reference/definitions "Resource"}],
                  :description "Peering location is where connectivity could be established to the Microsoft Cloud Edge.",
                  :properties {:kind {:description "The kind of peering that the peering location supports.",
                                      :enum ["Direct"
                                             "Exchange"],
                                      :type "string",
                                      :x-ms-enum {:modelAsString true,
                                                  :name "kind"}},
                               :properties {:reference/definitions "PeeringLocationProperties"}},
                  :type "object"},
:PeeringServiceLocationProperties {:description "The properties that define connectivity to the Peering Service Location.",
                                   :properties {:azureRegion {:description "Azure region for the location",
                                                              :type "string"},
                                                :country {:description "Country of the customer",
                                                          :type "string"},
                                                :state {:description "State of the customer",
                                                        :type "string"}},
                                   :type "object"},
:PeeringLocationProperties {:description "The properties that define a peering location.",
                            :properties {:azureRegion {:description "The Azure region associated with the peering location.",
                                                       :type "string"},
                                         :country {:description "The country in which the peering location exists.",
                                                   :type "string"},
                                         :direct {:reference/definitions "PeeringLocationPropertiesDirect"},
                                         :exchange {:reference/definitions "PeeringLocationPropertiesExchange"},
                                         :peeringLocation {:description "The name of the peering location.",
                                                           :type "string"}},
                            :type "object"},
:PeeringServiceProperties {:description "The properties that define connectivity to the Peering Service.",
                           :properties {:peeringServiceLocation {:description "The PeeringServiceLocation of the Customer.",
                                                                 :type "string"},
                                        :peeringServiceProvider {:description "The MAPS Provider Name.",
                                                                 :type "string"},
                                        :provisioningState {:description "The provisioning state of the resource.",
                                                            :enum ["Succeeded"
                                                                   "Updating"
                                                                   "Deleting"
                                                                   "Failed"],
                                                            :readOnly true,
                                                            :type "string",
                                                            :x-ms-enum {:modelAsString true,
                                                                        :name "provisioningState"}}},
                           :type "object"},
:SubResource {:description "The sub resource.",
              :properties {:id {:description "The identifier of the referenced resource.",
                                :type "string"}},
              :type "object"},
:PeeringServicePrefix {:allOf [{:reference/definitions "Resource"}],
                       :description "The peering service prefix class.",
                       :properties {:properties {:reference/definitions "PeeringServicePrefixProperties"}},
                       :type "object"},
:PeeringServicePrefixListResult {:description "The paginated list of [T].",
                                 :properties {:nextLink {:description "The link to fetch the next page of [T].",
                                                         :type "string"},
                                              :value {:description "The list of [T].",
                                                      :items {:reference/definitions "PeeringServicePrefix"},
                                                      :type "array"}},
                                 :type "object"},
:ExchangePeeringFacility {:description "The properties that define an exchange peering facility.",
                          :properties {:bandwidthInMbps {:description "The bandwidth of the connection between Microsoft and the exchange peering facility.",
                                                         :format "int32",
                                                         :type "integer"},
                                       :exchangeName {:description "The name of the exchange peering facility.",
                                                      :type "string"},
                                       :facilityIPv4Prefix {:description "The IPv4 prefixes associated with the exchange peering facility.",
                                                            :type "string"},
                                       :facilityIPv6Prefix {:description "The IPv6 prefixes associated with the exchange peering facility.",
                                                            :type "string"},
                                       :microsoftIPv4Address {:description "The IPv4 address of Microsoft at the exchange peering facility.",
                                                              :type "string"},
                                       :microsoftIPv6Address {:description "The IPv6 address of Microsoft at the exchange peering facility.",
                                                              :type "string"},
                                       :peeringDBFacilityId {:description "The PeeringDB.com ID of the facility.",
                                                             :format "int32",
                                                             :type "integer"},
                                       :peeringDBFacilityLink {:description "The PeeringDB.com URL of the facility.",
                                                               :type "string"}},
                          :type "object"},
:CheckServiceProviderAvailabilityInput {:description "Class for CheckServiceProviderAvailabilityInput",
                                        :properties {:peeringServiceLocation {:description "Gets or sets the PeeringServiceLocation",
                                                                              :type "string"},
                                                     :peeringServiceProvider {:description "Gets or sets the PeeringServiceProvider",
                                                                              :type "string"}},
                                        :type "object"},
:PeerAsnProperties {:description "The properties that define a peer's ASN.",
                    :properties {:peerAsn {:description "The Autonomous System Number (ASN) of the peer.",
                                           :format "int32",
                                           :type "integer"},
                                 :peerContactInfo {:reference/definitions "ContactInfo"},
                                 :peerName {:description "The name of the peer.",
                                            :type "string"},
                                 :validationState {:description "The validation state of the ASN associated with the peer.",
                                                   :enum ["None"
                                                          "Pending"
                                                          "Approved"
                                                          "Failed"],
                                                   :type "string",
                                                   :x-ms-enum {:modelAsString true,
                                                               :name "validationState"}}},
                    :type "object"},
:PeeringLocationPropertiesDirect {:description "The properties that define a direct peering location.",
                                  :properties {:bandwidthOffers {:description "The list of bandwidth offers available at the peering location.",
                                                                 :items {:reference/definitions "PeeringBandwidthOffer"},
                                                                 :type "array"},
                                               :peeringFacilities {:description "The list of direct peering facilities at the peering location.",
                                                                   :items {:reference/definitions "DirectPeeringFacility"},
                                                                   :type "array"}},
                                  :type "object"},
:PeeringServiceLocationListResult {:description "The paginated list of peering service locations.",
                                   :properties {:nextLink {:description "The link to fetch the next page of peering service locations.",
                                                           :type "string"},
                                                :value {:description "The list of peering service locations.",
                                                        :items {:reference/definitions "PeeringServiceLocation"},
                                                        :type "array"}},
                                   :type "object"},
:PeeringServicePrefixProperties {:description "The peering service prefix properties class.",
                                 :properties {:learnedType {:description "The prefix learned type",
                                                            :enum ["None"
                                                                   "ViaPartner"
                                                                   "ViaSession"],
                                                            :type "string",
                                                            :x-ms-enum {:modelAsString true,
                                                                        :name "learnedType"}},
                                              :prefix {:description "Valid route prefix",
                                                       :type "string"},
                                              :prefixValidationState {:description "The prefix validation state",
                                                                      :enum ["None"
                                                                             "Invalid"
                                                                             "Verified"
                                                                             "Failed"
                                                                             "Pending"
                                                                             "Unknown"],
                                                                      :type "string",
                                                                      :x-ms-enum {:modelAsString true,
                                                                                  :name "prefixValidationState"}},
                                              :provisioningState {:description "The provisioning state of the resource.",
                                                                  :enum ["Succeeded"
                                                                         "Updating"
                                                                         "Deleting"
                                                                         "Failed"],
                                                                  :readOnly true,
                                                                  :type "string",
                                                                  :x-ms-enum {:modelAsString true,
                                                                              :name "provisioningState"}}},
                                 :type "object"},
:PeeringServiceProviderListResult {:description "The paginated list of peering service providers.",
                                   :properties {:nextLink {:description "The link to fetch the next page of peering service providers.",
                                                           :type "string"},
                                                :value {:description "The list of peering service providers.",
                                                        :items {:reference/definitions "PeeringServiceProvider"},
                                                        :type "array"}},
                                   :type "object"},
:OperationDisplayInfo {:description "The information related to the operation.",
                       :properties {:description {:description "The description of the operation.",
                                                  :readOnly true,
                                                  :type "string"},
                                    :operation {:description "The name of the operation.",
                                                :readOnly true,
                                                :type "string"},
                                    :provider {:description "The name of the resource provider.",
                                               :readOnly true,
                                               :type "string"},
                                    :resource {:description "The type of the resource.",
                                               :readOnly true,
                                               :type "string"}},
                       :type "object"},
:DirectPeeringFacility {:description "The properties that define a direct peering facility.",
                        :properties {:address {:description "The address of the direct peering facility.",
                                               :type "string"},
                                     :directPeeringType {:description "The type of the direct peering.",
                                                         :enum ["Edge"
                                                                "Transit"
                                                                "Cdn"
                                                                "Internal"],
                                                         :type "string",
                                                         :x-ms-enum {:modelAsString true,
                                                                     :name "directPeeringType"}},
                                     :peeringDBFacilityId {:description "The PeeringDB.com ID of the facility.",
                                                           :format "int32",
                                                           :type "integer"},
                                     :peeringDBFacilityLink {:description "The PeeringDB.com URL of the facility.",
                                                             :type "string"}},
                        :type "object"},
:ExchangeConnection {:description "The properties that define an exchange connection.",
                     :properties {:bgpSession {:reference/definitions "BgpSession"},
                                  :connectionIdentifier {:description "The unique identifier (GUID) for the connection.",
                                                         :type "string"},
                                  :connectionState {:description "The state of the connection.",
                                                    :enum ["None"
                                                           "PendingApproval"
                                                           "Approved"
                                                           "ProvisioningStarted"
                                                           "ProvisioningFailed"
                                                           "ProvisioningCompleted"
                                                           "Validating"
                                                           "Active"],
                                                    :readOnly true,
                                                    :type "string",
                                                    :x-ms-enum {:modelAsString true,
                                                                :name "connectionState"}},
                                  :peeringDBFacilityId {:description "The PeeringDB.com ID of the facility at which the connection has to be set up.",
                                                        :format "int32",
                                                        :type "integer"}},
                     :type "object"},
:Resource {:description "The ARM resource class.",
           :properties {:id {:description "The ID of the resource.",
                             :readOnly true,
                             :type "string"},
                        :name {:description "The name of the resource.",
                               :readOnly true,
                               :type "string"},
                        :type {:description "The type of the resource.",
                               :readOnly true,
                               :type "string"}},
           :type "object",
           :x-ms-azure-resource true},
:BgpSession {:description "The properties that define a BGP session.",
             :properties {:sessionStateV6 {:description "The state of the IPv6 session.",
                                           :enum ["None"
                                                  "Idle"
                                                  "Connect"
                                                  "Active"
                                                  "OpenSent"
                                                  "OpenConfirm"
                                                  "OpenReceived"
                                                  "Established"
                                                  "PendingAdd"
                                                  "PendingUpdate"
                                                  "PendingRemove"],
                                           :readOnly true,
                                           :type "string",
                                           :x-ms-enum {:modelAsString true,
                                                       :name "sessionStateV6"}},
                          :sessionStateV4 {:description "The state of the IPv4 session.",
                                           :enum ["None"
                                                  "Idle"
                                                  "Connect"
                                                  "Active"
                                                  "OpenSent"
                                                  "OpenConfirm"
                                                  "OpenReceived"
                                                  "Established"
                                                  "PendingAdd"
                                                  "PendingUpdate"
                                                  "PendingRemove"],
                                           :readOnly true,
                                           :type "string",
                                           :x-ms-enum {:modelAsString true,
                                                       :name "sessionStateV4"}},
                          :sessionPrefixV4 {:description "The IPv4 prefix that contains both ends' IPv4 addresses.",
                                            :type "string"},
                          :sessionPrefixV6 {:description "The IPv6 prefix that contains both ends' IPv6 addresses.",
                                            :type "string"},
                          :peerSessionIPv4Address {:description "The IPv4 session address on peer's end.",
                                                   :type "string"},
                          :maxPrefixesAdvertisedV4 {:description "The maximum number of prefixes advertised over the IPv4 session.",
                                                    :format "int32",
                                                    :type "integer"},
                          :microsoftSessionIPv6Address {:description "The IPv6 session address on Microsoft's end.",
                                                        :readOnly true,
                                                        :type "string"},
                          :peerSessionIPv6Address {:description "The IPv6 session address on peer's end.",
                                                   :type "string"},
                          :maxPrefixesAdvertisedV6 {:description "The maximum number of prefixes advertised over the IPv6 session.",
                                                    :format "int32",
                                                    :type "integer"},
                          :md5AuthenticationKey {:description "The MD5 authentication key of the session.",
                                                 :type "string"},
                          :microsoftSessionIPv4Address {:description "The IPv4 session address on Microsoft's end.",
                                                        :readOnly true,
                                                        :type "string"}},
             :type "object"},
:ErrorResponse {:description "The error response that indicates why an operation has failed.",
                :properties {:code {:description "The error code.",
                                    :readOnly true,
                                    :type "string"},
                             :message {:description "The error message.",
                                       :readOnly true,
                                       :type "string"}},
                :type "object"},
:PeeringLocationListResult {:description "The paginated list of peering locations.",
                            :properties {:nextLink {:description "The link to fetch the next page of peering locations.",
                                                    :type "string"},
                                         :value {:description "The list of peering locations.",
                                                 :items {:reference/definitions "PeeringLocation"},
                                                 :type "array"}},
                            :type "object"},
:PeeringServiceListResult {:description "The paginated list of peering services.",
                           :properties {:nextLink {:description "The link to fetch the next page of peering services.",
                                                   :type "string"},
                                        :value {:description "The list of peering services.",
                                                :items {:reference/definitions "PeeringService"},
                                                :type "array"}},
                           :type "object"},
:PeerAsn {:allOf [{:reference/definitions "Resource"}],
          :description "The essential information related to the peer's ASN.",
          :properties {:properties {:reference/definitions "PeerAsnProperties"}},
          :type "object"},
:PeerAsnListResult {:description "The paginated list of peer ASNs.",
                    :properties {:nextLink {:description "The link to fetch the next page of peer ASNs.",
                                            :type "string"},
                                 :value {:description "The list of peer ASNs.",
                                         :items {:reference/definitions "PeerAsn"},
                                         :type "array"}},
                    :type "object"},
:PeeringBandwidthOffer {:description "The properties that define a peering bandwidth offer.",
                        :properties {:offerName {:description "The name of the bandwidth offer.",
                                                 :type "string"},
                                     :valueInMbps {:description "The value of the bandwidth offer in Mbps.",
                                                   :format "int32",
                                                   :type "integer"}},
                        :type "object"},
:ResourceTags {:description "The resource tags.",
               :properties {:tags {:additionalProperties {:type "string"},
                                   :description "Gets or sets the tags, a dictionary of descriptors arm object",
                                   :type "object"}},
               :type "object"},
:DirectConnection {:description "The properties that define a direct connection.",
                   :properties {:bandwidthInMbps {:description "The bandwidth of the connection.",
                                                  :format "int32",
                                                  :type "integer"},
                                :bgpSession {:reference/definitions "BgpSession"},
                                :connectionIdentifier {:description "The unique identifier (GUID) for the connection.",
                                                       :type "string"},
                                :connectionState {:description "The state of the connection.",
                                                  :enum ["None"
                                                         "PendingApproval"
                                                         "Approved"
                                                         "ProvisioningStarted"
                                                         "ProvisioningFailed"
                                                         "ProvisioningCompleted"
                                                         "Validating"
                                                         "Active"],
                                                  :readOnly true,
                                                  :type "string",
                                                  :x-ms-enum {:modelAsString true,
                                                              :name "connectionState"}},
                                :peeringDBFacilityId {:description "The PeeringDB.com ID of the facility at which the connection has to be set up.",
                                                      :format "int32",
                                                      :type "integer"},
                                :provisionedBandwidthInMbps {:description "The bandwidth that is actually provisioned.",
                                                             :format "int32",
                                                             :type "integer"},
                                :sessionAddressProvider {:description "The field indicating if Microsoft provides session ip addresses.",
                                                         :enum ["Microsoft"
                                                                "Peer"],
                                                         :type "string",
                                                         :x-ms-enum {:modelAsString true,
                                                                     :name "sessionAddressProvider"}},
                                :useForPeeringService {:description "The flag that indicates whether or not the connection is used for peering service.",
                                                       :type "boolean"}},
                   :type "object"},
:PeeringPropertiesDirect {:description "The properties that define a direct peering.",
                          :properties {:connections {:description "The set of connections that constitute a direct peering.",
                                                     :items {:reference/definitions "DirectConnection"},
                                                     :type "array"},
                                       :directPeeringType {:description "The type of direct peering.",
                                                           :enum ["Edge"
                                                                  "Transit"
                                                                  "Cdn"
                                                                  "Internal"],
                                                           :type "string",
                                                           :x-ms-enum {:modelAsString true,
                                                                       :name "directPeeringType"}},
                                       :peerAsn {:reference/definitions "SubResource"},
                                       :useForPeeringService {:description "The flag that indicates whether or not the peering is used for peering service.",
                                                              :type "boolean"}},
                          :type "object"},
:PeeringServiceProvider {:allOf [{:reference/definitions "Resource"}],
                         :description "PeeringService provider",
                         :properties {:properties {:reference/definitions "PeeringServiceProviderProperties"}},
                         :type "object"}}}
)


(def SqlManagementClient
{:scheme "https",
 :host "management.azure.com",
 :info {:description "Provides create, read, update and delete functionality for Azure SQL Databases.",
        :title "Azure SQL Database",
        :version "2014-04-01"},
 :ops {:Databases_ListByServer {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases",
                                :description "Returns a list of databases in a server.",
                                :parameters [{:description "The API version to use for the request.",
                                              :in "query",
                                              :name "api-version",
                                              :required true,
                                              :type "string",
                                              :x-ms-parameter-location "client"}
                                             {:description "The subscription ID that identifies an Azure subscription.",
                                              :in "path",
                                              :name "subscriptionId",
                                              :required true,
                                              :type "string",
                                              :x-ms-parameter-location "client"}
                                             {:description "The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.",
                                              :in "path",
                                              :name "resourceGroupName",
                                              :required true,
                                              :type "string",
                                              :x-ms-parameter-location "method"}
                                             {:reference/parameters "ServerNameParameter"}
                                             {:reference/parameters "DatabaseExpandParameter"}
                                             {:description "An OData filter expression that describes a subset of databases to return.",
                                              :in "query",
                                              :name "$filter",
                                              :required false,
                                              :type "string"}],
                                :verb :get},
       :Databases_Delete {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}",
                          :description "Deletes a database.",
                          :parameters [{:description "The API version to use for the request.",
                                        :in "query",
                                        :name "api-version",
                                        :required true,
                                        :type "string",
                                        :x-ms-parameter-location "client"}
                                       {:description "The subscription ID that identifies an Azure subscription.",
                                        :in "path",
                                        :name "subscriptionId",
                                        :required true,
                                        :type "string",
                                        :x-ms-parameter-location "client"}
                                       {:description "The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.",
                                        :in "path",
                                        :name "resourceGroupName",
                                        :required true,
                                        :type "string",
                                        :x-ms-parameter-location "method"}
                                       {:reference/parameters "ServerNameParameter"}
                                       {:description "The name of the database to be deleted.",
                                        :in "path",
                                        :name "databaseName",
                                        :required true,
                                        :type "string"}],
                          :verb :delete},
       :Databases_Pause {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/pause",
                         :description "Pauses a data warehouse.",
                         :parameters [{:description "The API version to use for the request.",
                                       :in "query",
                                       :name "api-version",
                                       :required true,
                                       :type "string",
                                       :x-ms-parameter-location "client"}
                                      {:description "The subscription ID that identifies an Azure subscription.",
                                       :in "path",
                                       :name "subscriptionId",
                                       :required true,
                                       :type "string",
                                       :x-ms-parameter-location "client"}
                                      {:description "The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.",
                                       :in "path",
                                       :name "resourceGroupName",
                                       :required true,
                                       :type "string",
                                       :x-ms-parameter-location "method"}
                                      {:reference/parameters "ServerNameParameter"}
                                      {:description "The name of the data warehouse to pause.",
                                       :in "path",
                                       :name "databaseName",
                                       :required true,
                                       :type "string"}],
                         :verb :post},
       :Databases_GetByRecommendedElasticPool {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recommendedElasticPools/{recommendedElasticPoolName}/databases/{databaseName}",
                                               :description "Gets a database inside of a recommended elastic pool.",
                                               :parameters [{:description "The API version to use for the request.",
                                                             :in "query",
                                                             :name "api-version",
                                                             :required true,
                                                             :type "string",
                                                             :x-ms-parameter-location "client"}
                                                            {:description "The subscription ID that identifies an Azure subscription.",
                                                             :in "path",
                                                             :name "subscriptionId",
                                                             :required true,
                                                             :type "string",
                                                             :x-ms-parameter-location "client"}
                                                            {:description "The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.",
                                                             :in "path",
                                                             :name "resourceGroupName",
                                                             :required true,
                                                             :type "string",
                                                             :x-ms-parameter-location "method"}
                                                            {:reference/parameters "ServerNameParameter"}
                                                            {:description "The name of the elastic pool to be retrieved.",
                                                             :in "path",
                                                             :name "recommendedElasticPoolName",
                                                             :required true,
                                                             :type "string"}
                                                            {:description "The name of the database to be retrieved.",
                                                             :in "path",
                                                             :name "databaseName",
                                                             :required true,
                                                             :type "string"}],
                                               :verb :get},
       :Databases_ListByElasticPool {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/databases",
                                     :description "Returns a list of databases in an elastic pool.",
                                     :parameters [{:description "The API version to use for the request.",
                                                   :in "query",
                                                   :name "api-version",
                                                   :required true,
                                                   :type "string",
                                                   :x-ms-parameter-location "client"}
                                                  {:description "The subscription ID that identifies an Azure subscription.",
                                                   :in "path",
                                                   :name "subscriptionId",
                                                   :required true,
                                                   :type "string",
                                                   :x-ms-parameter-location "client"}
                                                  {:description "The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.",
                                                   :in "path",
                                                   :name "resourceGroupName",
                                                   :required true,
                                                   :type "string",
                                                   :x-ms-parameter-location "method"}
                                                  {:reference/parameters "ServerNameParameter"}
                                                  {:description "The name of the elastic pool to be retrieved.",
                                                   :in "path",
                                                   :name "elasticPoolName",
                                                   :required true,
                                                   :type "string"}],
                                     :verb :get},
       :Databases_ListByRecommendedElasticPool {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recommendedElasticPools/{recommendedElasticPoolName}/databases",
                                                :description "Returns a list of databases inside a recommended elastic pool.",
                                                :parameters [{:description "The API version to use for the request.",
                                                              :in "query",
                                                              :name "api-version",
                                                              :required true,
                                                              :type "string",
                                                              :x-ms-parameter-location "client"}
                                                             {:description "The subscription ID that identifies an Azure subscription.",
                                                              :in "path",
                                                              :name "subscriptionId",
                                                              :required true,
                                                              :type "string",
                                                              :x-ms-parameter-location "client"}
                                                             {:description "The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.",
                                                              :in "path",
                                                              :name "resourceGroupName",
                                                              :required true,
                                                              :type "string",
                                                              :x-ms-parameter-location "method"}
                                                             {:reference/parameters "ServerNameParameter"}
                                                             {:description "The name of the recommended elastic pool to be retrieved.",
                                                              :in "path",
                                                              :name "recommendedElasticPoolName",
                                                              :required true,
                                                              :type "string"}],
                                                :verb :get},
       :Databases_Resume {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/resume",
                          :description "Resumes a data warehouse.",
                          :parameters [{:description "The API version to use for the request.",
                                        :in "query",
                                        :name "api-version",
                                        :required true,
                                        :type "string",
                                        :x-ms-parameter-location "client"}
                                       {:description "The subscription ID that identifies an Azure subscription.",
                                        :in "path",
                                        :name "subscriptionId",
                                        :required true,
                                        :type "string",
                                        :x-ms-parameter-location "client"}
                                       {:description "The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.",
                                        :in "path",
                                        :name "resourceGroupName",
                                        :required true,
                                        :type "string",
                                        :x-ms-parameter-location "method"}
                                       {:reference/parameters "ServerNameParameter"}
                                       {:description "The name of the data warehouse to resume.",
                                        :in "path",
                                        :name "databaseName",
                                        :required true,
                                        :type "string"}],
                          :verb :post},
       :Databases_GetByElasticPool {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/databases/{databaseName}",
                                    :description "Gets a database inside of an elastic pool.",
                                    :parameters [{:description "The API version to use for the request.",
                                                  :in "query",
                                                  :name "api-version",
                                                  :required true,
                                                  :type "string",
                                                  :x-ms-parameter-location "client"}
                                                 {:description "The subscription ID that identifies an Azure subscription.",
                                                  :in "path",
                                                  :name "subscriptionId",
                                                  :required true,
                                                  :type "string",
                                                  :x-ms-parameter-location "client"}
                                                 {:description "The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.",
                                                  :in "path",
                                                  :name "resourceGroupName",
                                                  :required true,
                                                  :type "string",
                                                  :x-ms-parameter-location "method"}
                                                 {:reference/parameters "ServerNameParameter"}
                                                 {:description "The name of the elastic pool to be retrieved.",
                                                  :in "path",
                                                  :name "elasticPoolName",
                                                  :required true,
                                                  :type "string"}
                                                 {:description "The name of the database to be retrieved.",
                                                  :in "path",
                                                  :name "databaseName",
                                                  :required true,
                                                  :type "string"}],
                                    :verb :get},
       :Databases_Get {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}",
                       :description "Gets a database.",
                       :parameters [{:description "The API version to use for the request.",
                                     :in "query",
                                     :name "api-version",
                                     :required true,
                                     :type "string",
                                     :x-ms-parameter-location "client"}
                                    {:description "The subscription ID that identifies an Azure subscription.",
                                     :in "path",
                                     :name "subscriptionId",
                                     :required true,
                                     :type "string",
                                     :x-ms-parameter-location "client"}
                                    {:description "The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.",
                                     :in "path",
                                     :name "resourceGroupName",
                                     :required true,
                                     :type "string",
                                     :x-ms-parameter-location "method"}
                                    {:reference/parameters "ServerNameParameter"}
                                    {:description "The name of the database to be retrieved.",
                                     :in "path",
                                     :name "databaseName",
                                     :required true,
                                     :type "string"}
                                    {:reference/parameters "DatabaseExpandParameter"}],
                       :verb :get},
       :Databases_Update {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}",
                          :description "Updates an existing database.",
                          :parameters [{:description "The API version to use for the request.",
                                        :in "query",
                                        :name "api-version",
                                        :required true,
                                        :type "string",
                                        :x-ms-parameter-location "client"}
                                       {:description "The subscription ID that identifies an Azure subscription.",
                                        :in "path",
                                        :name "subscriptionId",
                                        :required true,
                                        :type "string",
                                        :x-ms-parameter-location "client"}
                                       {:description "The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.",
                                        :in "path",
                                        :name "resourceGroupName",
                                        :required true,
                                        :type "string",
                                        :x-ms-parameter-location "method"}
                                       {:reference/parameters "ServerNameParameter"}
                                       {:description "The name of the database to be updated.",
                                        :in "path",
                                        :name "databaseName",
                                        :required true,
                                        :type "string"}
                                       {:description "The required parameters for updating a database.",
                                        :in "body",
                                        :name "parameters",
                                        :required true,
                                        :schema {:reference/definitions "DatabaseUpdate"}}],
                          :verb :patch},
       :Databases_CreateOrUpdate {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}",
                                  :description "Creates a new database or updates an existing database.",
                                  :parameters [{:description "The API version to use for the request.",
                                                :in "query",
                                                :name "api-version",
                                                :required true,
                                                :type "string",
                                                :x-ms-parameter-location "client"}
                                               {:description "The subscription ID that identifies an Azure subscription.",
                                                :in "path",
                                                :name "subscriptionId",
                                                :required true,
                                                :type "string",
                                                :x-ms-parameter-location "client"}
                                               {:description "The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.",
                                                :in "path",
                                                :name "resourceGroupName",
                                                :required true,
                                                :type "string",
                                                :x-ms-parameter-location "method"}
                                               {:reference/parameters "ServerNameParameter"}
                                               {:description "The name of the database to be operated on (updated or created).",
                                                :in "path",
                                                :name "databaseName",
                                                :required true,
                                                :type "string"}
                                               {:description "The required parameters for creating or updating a database.",
                                                :in "body",
                                                :name "parameters",
                                                :required true,
                                                :schema {:reference/definitions "Database"}}],
                                  :verb :put}},
 :parameters {:DatabaseExpandParameter {:description "A comma separated list of child objects to expand in the response. Possible properties: serviceTierAdvisors, transparentDataEncryption.",
                                        :in "query",
                                        :name "$expand",
                                        :required false,
                                        :type "string",
                                        :x-ms-parameter-location "method"},
              :ServerNameParameter {:description "The name of the server.",
                                    :in "path",
                                    :name "serverName",
                                    :required true,
                                    :type "string",
                                    :x-ms-parameter-location "method"},
              :TransparentDataEncryptionNameParameter {:description "The name of the transparent data encryption configuration.",
                                                       :enum ["current"],
                                                       :in "path",
                                                       :name "transparentDataEncryptionName",
                                                       :required true,
                                                       :type "string",
                                                       :x-ms-enum {:modelAsString true,
                                                                   :name "TransparentDataEncryptionName"},
                                                       :x-ms-parameter-location "method"}},
 :definitions {:Database {:allOf [{:allOf [{:description "ARM resource.",
                                            :properties {:id {:description "Resource ID.",
                                                              :readOnly true,
                                                              :type "string"},
                                                         :name {:description "Resource name.",
                                                                :readOnly true,
                                                                :type "string"},
                                                         :type {:description "Resource type.",
                                                                :readOnly true,
                                                                :type "string"}},
                                            :type "object",
                                            :x-ms-azure-resource true}],
                                   :description "ARM tracked top level resource.",
                                   :properties {:location {:description "Resource location.",
                                                           :type "string",
                                                           :x-ms-mutability ["read"
                                                                             "create"]},
                                                :tags {:additionalProperties {:type "string"},
                                                       :description "Resource tags.",
                                                       :type "object"}},
                                   :required ["location"],
                                   :type "object"}],
                          :description "Represents a database.",
                          :properties {:kind {:description "Kind of database.  This is metadata used for the Azure portal experience.",
                                              :readOnly true,
                                              :type "string"},
                                       :properties {:reference/definitions "DatabaseProperties"}}},
               :DatabaseListResult {:description "Represents the response to a list database request.",
                                    :properties {:value {:description "The list of databases housed in the server.",
                                                         :items {:reference/definitions "Database"},
                                                         :type "array"}},
                                    :required ["value"]},
               :DatabaseProperties {:description "Represents the properties of a database.",
                                    :properties {:recoveryServicesRecoveryPointResourceId {:description "Conditional. If createMode is RestoreLongTermRetentionBackup, then this value is required. Specifies the resource ID of the recovery point to restore from.",
                                                                                           :type "string",
                                                                                           :x-ms-mutability ["create"]},
                                                 :defaultSecondaryLocation {:description "The default secondary region for this database.",
                                                                            :readOnly true,
                                                                            :type "string"},
                                                 :sourceDatabaseId {:description "Conditional. If createMode is Copy, NonReadableSecondary, OnlineSecondary, PointInTimeRestore, Recovery, or Restore, then this value is required. Specifies the resource ID of the source database. If createMode is NonReadableSecondary or OnlineSecondary, the name of the source database must be the same as the new database being created.",
                                                                    :type "string",
                                                                    :x-ms-mutability ["create"]},
                                                 :serviceLevelObjective {:description "The current service level objective of the database.",
                                                                         :enum ["System"
                                                                                "System0"
                                                                                "System1"
                                                                                "System2"
                                                                                "System3"
                                                                                "System4"
                                                                                "System2L"
                                                                                "System3L"
                                                                                "System4L"
                                                                                "Free"
                                                                                "Basic"
                                                                                "S0"
                                                                                "S1"
                                                                                "S2"
                                                                                "S3"
                                                                                "S4"
                                                                                "S6"
                                                                                "S7"
                                                                                "S9"
                                                                                "S12"
                                                                                "P1"
                                                                                "P2"
                                                                                "P3"
                                                                                "P4"
                                                                                "P6"
                                                                                "P11"
                                                                                "P15"
                                                                                "PRS1"
                                                                                "PRS2"
                                                                                "PRS4"
                                                                                "PRS6"
                                                                                "DW100"
                                                                                "DW200"
                                                                                "DW300"
                                                                                "DW400"
                                                                                "DW500"
                                                                                "DW600"
                                                                                "DW1000"
                                                                                "DW1200"
                                                                                "DW1000c"
                                                                                "DW1500"
                                                                                "DW1500c"
                                                                                "DW2000"
                                                                                "DW2000c"
                                                                                "DW3000"
                                                                                "DW2500c"
                                                                                "DW3000c"
                                                                                "DW6000"
                                                                                "DW5000c"
                                                                                "DW6000c"
                                                                                "DW7500c"
                                                                                "DW10000c"
                                                                                "DW15000c"
                                                                                "DW30000c"
                                                                                "DS100"
                                                                                "DS200"
                                                                                "DS300"
                                                                                "DS400"
                                                                                "DS500"
                                                                                "DS600"
                                                                                "DS1000"
                                                                                "DS1200"
                                                                                "DS1500"
                                                                                "DS2000"
                                                                                "ElasticPool"],
                                                                         :readOnly true,
                                                                         :type "string",
                                                                         :x-ms-enum {:modelAsString true,
                                                                                     :name "ServiceObjectiveName"}},
                                                 :readScale {:description "Conditional. If the database is a geo-secondary, readScale indicates whether read-only connections are allowed to this database or not. Not supported for DataWarehouse edition.",
                                                             :enum ["Enabled"
                                                                    "Disabled"],
                                                             :type "string",
                                                             :x-ms-enum {:name "ReadScale"}},
                                                 :transparentDataEncryption {:description "The transparent data encryption info for this database.",
                                                                             :items {:allOf [{:allOf [{:description "ARM resource.",
                                                                                                       :properties {:id {:description "Resource ID.",
                                                                                                                         :readOnly true,
                                                                                                                         :type "string"},
                                                                                                                    :name {:description "Resource name.",
                                                                                                                           :readOnly true,
                                                                                                                           :type "string"},
                                                                                                                    :type {:description "Resource type.",
                                                                                                                           :readOnly true,
                                                                                                                           :type "string"}},
                                                                                                       :type "object",
                                                                                                       :x-ms-azure-resource true}],
                                                                                              :description "ARM proxy resource.",
                                                                                              :properties {},
                                                                                              :type "object"}],
                                                                                     :description "Represents a database transparent data encryption configuration.",
                                                                                     :properties {:location {:description "Resource location.",
                                                                                                             :readOnly true,
                                                                                                             :type "string"},
                                                                                                  :properties {:description "Represents the properties of a database transparent data encryption.",
                                                                                                               :properties {:status {:description "The status of the database transparent data encryption.",
                                                                                                                                     :enum ["Enabled"
                                                                                                                                            "Disabled"],
                                                                                                                                     :type "string",
                                                                                                                                     :x-ms-enum {:name "TransparentDataEncryptionStatus"}}}}}},
                                                                             :readOnly true,
                                                                             :type "array"},
                                                 :collation {:description "The collation of the database. If createMode is not Default, this value is ignored.",
                                                             :type "string",
                                                             :x-ms-mutability ["create"
                                                                               "read"]},
                                                 :currentServiceObjectiveId {:description "The current service level objective ID of the database. This is the ID of the service level objective that is currently active.",
                                                                             :format "uuid",
                                                                             :readOnly true,
                                                                             :type "string"},
                                                 :requestedServiceObjectiveName {:description "The name of the configured service level objective of the database. This is the service level objective that is in the process of being applied to the database. Once successfully updated, it will match the value of serviceLevelObjective property. \r\n\r\nThe list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:\r\n\r\n```azurecli\r\naz sql db list-editions -l <location> -o table\r\n````\r\n\r\n```powershell\r\nGet-AzSqlServerServiceObjective -Location <location>\r\n````\r\n",
                                                                                 :enum ["System"
                                                                                        "System0"
                                                                                        "System1"
                                                                                        "System2"
                                                                                        "System3"
                                                                                        "System4"
                                                                                        "System2L"
                                                                                        "System3L"
                                                                                        "System4L"
                                                                                        "Free"
                                                                                        "Basic"
                                                                                        "S0"
                                                                                        "S1"
                                                                                        "S2"
                                                                                        "S3"
                                                                                        "S4"
                                                                                        "S6"
                                                                                        "S7"
                                                                                        "S9"
                                                                                        "S12"
                                                                                        "P1"
                                                                                        "P2"
                                                                                        "P3"
                                                                                        "P4"
                                                                                        "P6"
                                                                                        "P11"
                                                                                        "P15"
                                                                                        "PRS1"
                                                                                        "PRS2"
                                                                                        "PRS4"
                                                                                        "PRS6"
                                                                                        "DW100"
                                                                                        "DW200"
                                                                                        "DW300"
                                                                                        "DW400"
                                                                                        "DW500"
                                                                                        "DW600"
                                                                                        "DW1000"
                                                                                        "DW1200"
                                                                                        "DW1000c"
                                                                                        "DW1500"
                                                                                        "DW1500c"
                                                                                        "DW2000"
                                                                                        "DW2000c"
                                                                                        "DW3000"
                                                                                        "DW2500c"
                                                                                        "DW3000c"
                                                                                        "DW6000"
                                                                                        "DW5000c"
                                                                                        "DW6000c"
                                                                                        "DW7500c"
                                                                                        "DW10000c"
                                                                                        "DW15000c"
                                                                                        "DW30000c"
                                                                                        "DS100"
                                                                                        "DS200"
                                                                                        "DS300"
                                                                                        "DS400"
                                                                                        "DS500"
                                                                                        "DS600"
                                                                                        "DS1000"
                                                                                        "DS1200"
                                                                                        "DS1500"
                                                                                        "DS2000"
                                                                                        "ElasticPool"],
                                                                                 :type "string",
                                                                                 :x-ms-enum {:modelAsString true,
                                                                                             :name "ServiceObjectiveName"}},
                                                 :failoverGroupId {:description "The resource identifier of the failover group containing this database.",
                                                                   :readOnly true,
                                                                   :type "string"},
                                                 :earliestRestoreDate {:description "This records the earliest start date and time that restore is available for this database (ISO8601 format).",
                                                                       :format "date-time",
                                                                       :readOnly true,
                                                                       :type "string"},
                                                 :elasticPoolName {:description "The name of the elastic pool the database is in. If elasticPoolName and requestedServiceObjectiveName are both updated, the value of requestedServiceObjectiveName is ignored. Not supported for DataWarehouse edition.",
                                                                   :type "string"},
                                                 :status {:description "The status of the database.",
                                                          :readOnly true,
                                                          :type "string"},
                                                 :recommendedIndex {:description "The recommended indices for this database.",
                                                                    :items {:allOf [{:allOf [{:description "ARM resource.",
                                                                                              :properties {:id {:description "Resource ID.",
                                                                                                                :readOnly true,
                                                                                                                :type "string"},
                                                                                                           :name {:description "Resource name.",
                                                                                                                  :readOnly true,
                                                                                                                  :type "string"},
                                                                                                           :type {:description "Resource type.",
                                                                                                                  :readOnly true,
                                                                                                                  :type "string"}},
                                                                                              :type "object",
                                                                                              :x-ms-azure-resource true}],
                                                                                     :description "ARM proxy resource.",
                                                                                     :properties {},
                                                                                     :type "object"}],
                                                                            :description "Represents a database recommended index.",
                                                                            :properties {:properties {:description "Represents the properties of a database recommended index.",
                                                                                                      :properties {:schema {:description "The schema where table to build index over resides",
                                                                                                                            :readOnly true,
                                                                                                                            :type "string"},
                                                                                                                   :includedColumns {:description "The list of column names to be included in the index",
                                                                                                                                     :items {:type "string"},
                                                                                                                                     :readOnly true,
                                                                                                                                     :type "array"},
                                                                                                                   :table {:description "The table on which to build index.",
                                                                                                                           :readOnly true,
                                                                                                                           :type "string"},
                                                                                                                   :reportedImpact {:description "The values reported after index action is complete.",
                                                                                                                                    :items {:description "The impact of an operation, both in absolute and relative terms.",
                                                                                                                                            :properties {:changeValueAbsolute {:description "The absolute impact to dimension.",
                                                                                                                                                                               :format "double",
                                                                                                                                                                               :readOnly true,
                                                                                                                                                                               :type "number"},
                                                                                                                                                         :changeValueRelative {:description "The relative impact to dimension (null if not applicable)",
                                                                                                                                                                               :format "double",
                                                                                                                                                                               :readOnly true,
                                                                                                                                                                               :type "number"},
                                                                                                                                                         :name {:description "The name of the impact dimension.",
                                                                                                                                                                :readOnly true,
                                                                                                                                                                :type "string"},
                                                                                                                                                         :unit {:description "The unit in which estimated impact to dimension is measured.",
                                                                                                                                                                :readOnly true,
                                                                                                                                                                :type "string"}}},
                                                                                                                                    :readOnly true,
                                                                                                                                    :type "array"},
                                                                                                                   :columns {:description "Columns over which to build index",
                                                                                                                             :items {:type "string"},
                                                                                                                             :readOnly true,
                                                                                                                             :type "array"},
                                                                                                                   :created {:description "The UTC datetime showing when this resource was created (ISO8601 format).",
                                                                                                                             :format "date-time",
                                                                                                                             :readOnly true,
                                                                                                                             :type "string"},
                                                                                                                   :state {:description "The current recommendation state.",
                                                                                                                           :enum ["Active"
                                                                                                                                  "Pending"
                                                                                                                                  "Executing"
                                                                                                                                  "Verifying"
                                                                                                                                  "Pending Revert"
                                                                                                                                  "Reverting"
                                                                                                                                  "Reverted"
                                                                                                                                  "Ignored"
                                                                                                                                  "Expired"
                                                                                                                                  "Blocked"
                                                                                                                                  "Success"],
                                                                                                                           :readOnly true,
                                                                                                                           :type "string",
                                                                                                                           :x-ms-enum {:name "RecommendedIndexState"}},
                                                                                                                   :lastModified {:description "The UTC datetime of when was this resource last changed (ISO8601 format).",
                                                                                                                                  :format "date-time",
                                                                                                                                  :readOnly true,
                                                                                                                                  :type "string"},
                                                                                                                   :indexType {:description "The type of index (CLUSTERED, NONCLUSTERED, COLUMNSTORE, CLUSTERED COLUMNSTORE)",
                                                                                                                               :enum ["CLUSTERED"
                                                                                                                                      "NONCLUSTERED"
                                                                                                                                      "COLUMNSTORE"
                                                                                                                                      "CLUSTERED COLUMNSTORE"],
                                                                                                                               :readOnly true,
                                                                                                                               :type "string",
                                                                                                                               :x-ms-enum {:name "RecommendedIndexType"}},
                                                                                                                   :indexScript {:description "The full build index script",
                                                                                                                                 :readOnly true,
                                                                                                                                 :type "string"},
                                                                                                                   :action {:description "The proposed index action. You can create a missing index, drop an unused index, or rebuild an existing index to improve its performance.",
                                                                                                                            :enum ["Create"
                                                                                                                                   "Drop"
                                                                                                                                   "Rebuild"],
                                                                                                                            :readOnly true,
                                                                                                                            :type "string",
                                                                                                                            :x-ms-enum {:name "RecommendedIndexAction"}},
                                                                                                                   :estimatedImpact {:description "The estimated impact of doing recommended index action.",
                                                                                                                                     :items {:description "The impact of an operation, both in absolute and relative terms.",
                                                                                                                                             :properties {:changeValueAbsolute {:description "The absolute impact to dimension.",
                                                                                                                                                                                :format "double",
                                                                                                                                                                                :readOnly true,
                                                                                                                                                                                :type "number"},
                                                                                                                                                          :changeValueRelative {:description "The relative impact to dimension (null if not applicable)",
                                                                                                                                                                                :format "double",
                                                                                                                                                                                :readOnly true,
                                                                                                                                                                                :type "number"},
                                                                                                                                                          :name {:description "The name of the impact dimension.",
                                                                                                                                                                 :readOnly true,
                                                                                                                                                                 :type "string"},
                                                                                                                                                          :unit {:description "The unit in which estimated impact to dimension is measured.",
                                                                                                                                                                 :readOnly true,
                                                                                                                                                                 :type "string"}}},
                                                                                                                                     :readOnly true,
                                                                                                                                     :type "array"}}}}},
                                                                    :readOnly true,
                                                                    :type "array"},
                                                 :restorePointInTime {:description "Conditional. If createMode is PointInTimeRestore, this value is required. If createMode is Restore, this value is optional. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database. Must be greater than or equal to the source database's earliestRestoreDate value.",
                                                                      :format "date-time",
                                                                      :type "string",
                                                                      :x-ms-mutability ["create"]},
                                                 :zoneRedundant {:description "Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones.",
                                                                 :type "boolean"},
                                                 :requestedServiceObjectiveId {:description "The configured service level objective ID of the database. This is the service level objective that is in the process of being applied to the database. Once successfully updated, it will match the value of currentServiceObjectiveId property. If requestedServiceObjectiveId and requestedServiceObjectiveName are both updated, the value of requestedServiceObjectiveId overrides the value of requestedServiceObjectiveName.\r\n\r\nThe list of SKUs may vary by region and support offer. To determine the service objective ids that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API.",
                                                                               :format "uuid",
                                                                               :type "string"},
                                                 :databaseId {:description "The ID of the database.",
                                                              :format "uuid",
                                                              :readOnly true,
                                                              :type "string"},
                                                 :edition {:description "The edition of the database. The DatabaseEditions enumeration contains all the valid editions. If createMode is NonReadableSecondary or OnlineSecondary, this value is ignored.\r\n\r\nThe list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:\r\n\r\n```azurecli\r\naz sql db list-editions -l <location> -o table\r\n````\r\n\r\n```powershell\r\nGet-AzSqlServerServiceObjective -Location <location>\r\n````\r\n",
                                                           :enum ["Web"
                                                                  "Business"
                                                                  "Basic"
                                                                  "Standard"
                                                                  "Premium"
                                                                  "PremiumRS"
                                                                  "Free"
                                                                  "Stretch"
                                                                  "DataWarehouse"
                                                                  "System"
                                                                  "System2"
                                                                  "GeneralPurpose"
                                                                  "BusinessCritical"
                                                                  "Hyperscale"],
                                                           :type "string",
                                                           :x-ms-enum {:modelAsString true,
                                                                       :name "DatabaseEdition"}},
                                                 :maxSizeBytes {:description "The max size of the database expressed in bytes. If createMode is not Default, this value is ignored. To see possible values, query the capabilities API (/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationID}/capabilities) referred to by operationId: \"Capabilities_ListByLocation.\"",
                                                                :type "string"},
                                                 :creationDate {:description "The creation date of the database (ISO8601 format).",
                                                                :format "date-time",
                                                                :readOnly true,
                                                                :type "string"},
                                                 :sourceDatabaseDeletionDate {:description "Conditional. If createMode is Restore and sourceDatabaseId is the deleted database's original resource id when it existed (as opposed to its current restorable dropped database id), then this value is required. Specifies the time that the database was deleted.",
                                                                              :format "date-time",
                                                                              :type "string",
                                                                              :x-ms-mutability ["create"]},
                                                 :createMode {:description "Specifies the mode of database creation.\n\nDefault: regular database creation.\n\nCopy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.\n\nOnlineSecondary/NonReadableSecondary: creates a database as a (readable or nonreadable) secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.\n\nPointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.\n\nRecovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.\n\nRestore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.\n\nRestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.\n\nCopy, NonReadableSecondary, OnlineSecondary and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition.",
                                                              :enum ["Copy"
                                                                     "Default"
                                                                     "NonReadableSecondary"
                                                                     "OnlineSecondary"
                                                                     "PointInTimeRestore"
                                                                     "Recovery"
                                                                     "Restore"
                                                                     "RestoreLongTermRetentionBackup"],
                                                              :type "string",
                                                              :x-ms-enum {:modelAsString true,
                                                                          :name "CreateMode"},
                                                              :x-ms-mutability ["create"]},
                                                 :serviceTierAdvisors {:description "The list of service tier advisors for this database. Expanded property",
                                                                       :items {:allOf [{:allOf [{:description "ARM resource.",
                                                                                                 :properties {:id {:description "Resource ID.",
                                                                                                                   :readOnly true,
                                                                                                                   :type "string"},
                                                                                                              :name {:description "Resource name.",
                                                                                                                     :readOnly true,
                                                                                                                     :type "string"},
                                                                                                              :type {:description "Resource type.",
                                                                                                                     :readOnly true,
                                                                                                                     :type "string"}},
                                                                                                 :type "object",
                                                                                                 :x-ms-azure-resource true}],
                                                                                        :description "ARM proxy resource.",
                                                                                        :properties {},
                                                                                        :type "object"}],
                                                                               :description "Represents a Service Tier Advisor.",
                                                                               :properties {:properties {:description "Represents the properties of a Service Tier Advisor.",
                                                                                                         :properties {:currentServiceLevelObjectiveId {:description "Gets or sets currentServiceLevelObjectiveId for service tier advisor.",
                                                                                                                                                       :format "uuid",
                                                                                                                                                       :readOnly true,
                                                                                                                                                       :type "string"},
                                                                                                                      :usageBasedRecommendationServiceLevelObjectiveId {:description "Gets or sets usageBasedRecommendationServiceLevelObjectiveId for service tier advisor.",
                                                                                                                                                                        :format "uuid",
                                                                                                                                                                        :readOnly true,
                                                                                                                                                                        :type "string"},
                                                                                                                      :activeTimeRatio {:description "The activeTimeRatio for service tier advisor.",
                                                                                                                                        :format "double",
                                                                                                                                        :readOnly true,
                                                                                                                                        :type "number"},
                                                                                                                      :databaseSizeBasedRecommendationServiceLevelObjective {:description "Gets or sets databaseSizeBasedRecommendationServiceLevelObjective for service tier advisor.",
                                                                                                                                                                             :readOnly true,
                                                                                                                                                                             :type "string"},
                                                                                                                      :observationPeriodEnd {:description "The observation period start (ISO8601 format).",
                                                                                                                                             :format "date-time",
                                                                                                                                             :readOnly true,
                                                                                                                                             :type "string"},
                                                                                                                      :disasterPlanBasedRecommendationServiceLevelObjective {:description "Gets or sets disasterPlanBasedRecommendationServiceLevelObjective for service tier advisor.",
                                                                                                                                                                             :readOnly true,
                                                                                                                                                                             :type "string"},
                                                                                                                      :usageBasedRecommendationServiceLevelObjective {:description "Gets or sets usageBasedRecommendationServiceLevelObjective for service tier advisor.",
                                                                                                                                                                      :readOnly true,
                                                                                                                                                                      :type "string"},
                                                                                                                      :minDtu {:description "Gets or sets minDtu for service tier advisor.",
                                                                                                                               :format "double",
                                                                                                                               :readOnly true,
                                                                                                                               :type "number"},
                                                                                                                      :overallRecommendationServiceLevelObjectiveId {:description "Gets or sets overallRecommendationServiceLevelObjectiveId for service tier advisor.",
                                                                                                                                                                     :format "uuid",
                                                                                                                                                                     :readOnly true,
                                                                                                                                                                     :type "string"},
                                                                                                                      :serviceLevelObjectiveUsageMetrics {:description "Gets or sets serviceLevelObjectiveUsageMetrics for the service tier advisor.",
                                                                                                                                                          :items {:description "A Slo Usage Metric.",
                                                                                                                                                                  :properties {:inRangeTimeRatio {:description "Gets or sets inRangeTimeRatio for SLO usage metric.",
                                                                                                                                                                                                  :format "double",
                                                                                                                                                                                                  :readOnly true,
                                                                                                                                                                                                  :type "number",
                                                                                                                                                                                                  :x-nullable false},
                                                                                                                                                                               :serviceLevelObjective {:description "The serviceLevelObjective for SLO usage metric.",
                                                                                                                                                                                                       :enum ["System"
                                                                                                                                                                                                              "System0"
                                                                                                                                                                                                              "System1"
                                                                                                                                                                                                              "System2"
                                                                                                                                                                                                              "System3"
                                                                                                                                                                                                              "System4"
                                                                                                                                                                                                              "System2L"
                                                                                                                                                                                                              "System3L"
                                                                                                                                                                                                              "System4L"
                                                                                                                                                                                                              "Free"
                                                                                                                                                                                                              "Basic"
                                                                                                                                                                                                              "S0"
                                                                                                                                                                                                              "S1"
                                                                                                                                                                                                              "S2"
                                                                                                                                                                                                              "S3"
                                                                                                                                                                                                              "S4"
                                                                                                                                                                                                              "S6"
                                                                                                                                                                                                              "S7"
                                                                                                                                                                                                              "S9"
                                                                                                                                                                                                              "S12"
                                                                                                                                                                                                              "P1"
                                                                                                                                                                                                              "P2"
                                                                                                                                                                                                              "P3"
                                                                                                                                                                                                              "P4"
                                                                                                                                                                                                              "P6"
                                                                                                                                                                                                              "P11"
                                                                                                                                                                                                              "P15"
                                                                                                                                                                                                              "PRS1"
                                                                                                                                                                                                              "PRS2"
                                                                                                                                                                                                              "PRS4"
                                                                                                                                                                                                              "PRS6"
                                                                                                                                                                                                              "DW100"
                                                                                                                                                                                                              "DW200"
                                                                                                                                                                                                              "DW300"
                                                                                                                                                                                                              "DW400"
                                                                                                                                                                                                              "DW500"
                                                                                                                                                                                                              "DW600"
                                                                                                                                                                                                              "DW1000"
                                                                                                                                                                                                              "DW1200"
                                                                                                                                                                                                              "DW1000c"
                                                                                                                                                                                                              "DW1500"
                                                                                                                                                                                                              "DW1500c"
                                                                                                                                                                                                              "DW2000"
                                                                                                                                                                                                              "DW2000c"
                                                                                                                                                                                                              "DW3000"
                                                                                                                                                                                                              "DW2500c"
                                                                                                                                                                                                              "DW3000c"
                                                                                                                                                                                                              "DW6000"
                                                                                                                                                                                                              "DW5000c"
                                                                                                                                                                                                              "DW6000c"
                                                                                                                                                                                                              "DW7500c"
                                                                                                                                                                                                              "DW10000c"
                                                                                                                                                                                                              "DW15000c"
                                                                                                                                                                                                              "DW30000c"
                                                                                                                                                                                                              "DS100"
                                                                                                                                                                                                              "DS200"
                                                                                                                                                                                                              "DS300"
                                                                                                                                                                                                              "DS400"
                                                                                                                                                                                                              "DS500"
                                                                                                                                                                                                              "DS600"
                                                                                                                                                                                                              "DS1000"
                                                                                                                                                                                                              "DS1200"
                                                                                                                                                                                                              "DS1500"
                                                                                                                                                                                                              "DS2000"
                                                                                                                                                                                                              "ElasticPool"],
                                                                                                                                                                                                       :readOnly true,
                                                                                                                                                                                                       :type "string",
                                                                                                                                                                                                       :x-ms-enum {:modelAsString true,
                                                                                                                                                                                                                   :name "ServiceObjectiveName"}},
                                                                                                                                                                               :serviceLevelObjectiveId {:description "The serviceLevelObjectiveId for SLO usage metric.",
                                                                                                                                                                                                         :format "uuid",
                                                                                                                                                                                                         :readOnly true,
                                                                                                                                                                                                         :type "string",
                                                                                                                                                                                                         :x-nullable false}}},
                                                                                                                                                          :readOnly true,
                                                                                                                                                          :type "array"},
                                                                                                                      :disasterPlanBasedRecommendationServiceLevelObjectiveId {:description "Gets or sets disasterPlanBasedRecommendationServiceLevelObjectiveId for service tier advisor.",
                                                                                                                                                                               :format "uuid",
                                                                                                                                                                               :readOnly true,
                                                                                                                                                                               :type "string"},
                                                                                                                      :observationPeriodStart {:description "The observation period start (ISO8601 format).",
                                                                                                                                               :format "date-time",
                                                                                                                                               :readOnly true,
                                                                                                                                               :type "string"},
                                                                                                                      :maxSizeInGB {:description "Gets or sets maxSizeInGB for service tier advisor.",
                                                                                                                                    :format "double",
                                                                                                                                    :readOnly true,
                                                                                                                                    :type "number"},
                                                                                                                      :maxDtu {:description "Gets or sets maxDtu for service tier advisor.",
                                                                                                                               :format "double",
                                                                                                                               :readOnly true,
                                                                                                                               :type "number"},
                                                                                                                      :currentServiceLevelObjective {:description "Gets or sets currentServiceLevelObjective for service tier advisor.",
                                                                                                                                                     :readOnly true,
                                                                                                                                                     :type "string"},
                                                                                                                      :avgDtu {:description "Gets or sets avgDtu for service tier advisor.",
                                                                                                                               :format "double",
                                                                                                                               :readOnly true,
                                                                                                                               :type "number"},
                                                                                                                      :confidence {:description "Gets or sets confidence for service tier advisor.",
                                                                                                                                   :format "double",
                                                                                                                                   :readOnly true,
                                                                                                                                   :type "number",
                                                                                                                                   :x-nullable false},
                                                                                                                      :databaseSizeBasedRecommendationServiceLevelObjectiveId {:description "Gets or sets databaseSizeBasedRecommendationServiceLevelObjectiveId for service tier advisor.",
                                                                                                                                                                               :format "uuid",
                                                                                                                                                                               :readOnly true,
                                                                                                                                                                               :type "string"},
                                                                                                                      :overallRecommendationServiceLevelObjective {:description "Gets or sets overallRecommendationServiceLevelObjective for service tier advisor.",
                                                                                                                                                                   :readOnly true,
                                                                                                                                                                   :type "string"}}}}},
                                                                       :readOnly true,
                                                                       :type "array"},
                                                 :containmentState {:description "The containment state of the database.",
                                                                    :format "int64",
                                                                    :readOnly true,
                                                                    :type "integer"},
                                                 :sampleName {:description "Indicates the name of the sample schema to apply when creating this database. If createMode is not Default, this value is ignored. Not supported for DataWarehouse edition.",
                                                              :enum ["AdventureWorksLT"],
                                                              :type "string",
                                                              :x-ms-enum {:modelAsString true,
                                                                          :name "SampleName"},
                                                              :x-ms-mutability ["create"]}}},
               :DatabaseUpdate {:allOf [{:description "ARM resource.",
                                         :properties {:id {:description "Resource ID.",
                                                           :readOnly true,
                                                           :type "string"},
                                                      :name {:description "Resource name.",
                                                             :readOnly true,
                                                             :type "string"},
                                                      :type {:description "Resource type.",
                                                             :readOnly true,
                                                             :type "string"}},
                                         :type "object",
                                         :x-ms-azure-resource true}],
                                :description "Represents a database update.",
                                :properties {:properties {:reference/definitions "DatabaseProperties"},
                                             :tags {:additionalProperties {:type "string"},
                                                    :description "Resource tags.",
                                                    :type "object"}}}}}
)

(def ResourceManagementClient
{:scheme "https",
 :host "management.azure.com",
 :info {:description "Provides operations for working with resources and resource groups.",
        :title "ResourceManagementClient",
        :version "2019-10-01"},
 :ops {:Deployments_CancelAtSubscriptionScope {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel",
                                               :description "You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.",
                                               :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                            {:reference/parameters "ApiVersionParameter"}
                                                            {:reference/parameters "SubscriptionIdParameter"}],
                                               :verb :post},
       :Resources_CreateOrUpdate {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}",
                                  :description "Creates a resource.",
                                  :parameters [{:description "The name of the resource group for the resource. The name is case insensitive.",
                                                :in "path",
                                                :maxLength 90,
                                                :minLength 1,
                                                :name "resourceGroupName",
                                                :pattern "^[-\\w\\._\\(\\)]+$",
                                                :required true,
                                                :type "string"}
                                               {:description "The namespace of the resource provider.",
                                                :in "path",
                                                :name "resourceProviderNamespace",
                                                :required true,
                                                :type "string"}
                                               {:description "The parent resource identity.",
                                                :in "path",
                                                :name "parentResourcePath",
                                                :required true,
                                                :type "string",
                                                :x-ms-skip-url-encoding true}
                                               {:description "The resource type of the resource to create.",
                                                :in "path",
                                                :name "resourceType",
                                                :required true,
                                                :type "string",
                                                :x-ms-skip-url-encoding true}
                                               {:description "The name of the resource to create.",
                                                :in "path",
                                                :name "resourceName",
                                                :required true,
                                                :type "string"}
                                               {:description "The API version to use for the operation.",
                                                :in "query",
                                                :name "api-version",
                                                :required true,
                                                :type "string"}
                                               {:description "Parameters for creating or updating the resource.",
                                                :in "body",
                                                :name "parameters",
                                                :required true,
                                                :schema {:reference/definitions "GenericResource"}}
                                               {:reference/parameters "SubscriptionIdParameter"}],
                                  :verb :put},
       :Deployments_CalculateTemplateHash {:path "/providers/Microsoft.Resources/calculateTemplateHash",
                                           :description "Calculate the hash of the given template.",
                                           :parameters [{:reference/parameters "ApiVersionParameter"}
                                                        {:description "The template provided to calculate hash.",
                                                         :in "body",
                                                         :name "template",
                                                         :required true,
                                                         :schema {:type "object"}}],
                                           :verb :post},
       :Deployments_ExportTemplateAtScope {:path "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate",
                                           :description "Exports the template used for specified deployment.",
                                           :parameters [{:reference/parameters "ScopeParameter"}
                                                        {:reference/parameters "DeploymentNameParameter"}
                                                        {:reference/parameters "ApiVersionParameter"}],
                                           :verb :post},
       :Deployments_DeleteAtTenantScope {:path "/providers/Microsoft.Resources/deployments/{deploymentName}",
                                         :description "A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.",
                                         :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                      {:reference/parameters "ApiVersionParameter"}],
                                         :verb :delete},
       :Deployments_CreateOrUpdateAtTenantScope {:path "/providers/Microsoft.Resources/deployments/{deploymentName}",
                                                 :description "You can provide the template and parameters directly in the request or link to JSON files.",
                                                 :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                              {:description "Additional parameters supplied to the operation.",
                                                               :in "body",
                                                               :name "parameters",
                                                               :required true,
                                                               :schema {:reference/definitions "ScopedDeployment"}}
                                                              {:reference/parameters "ApiVersionParameter"}],
                                                 :verb :put},
       :ResourceGroups_Update {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}",
                               :description "Resource groups can be updated through a simple PATCH operation to a group address. The format of the request is the same as that for creating a resource group. If a field is unspecified, the current value is retained.",
                               :parameters [{:description "The name of the resource group to update. The name is case insensitive.",
                                             :in "path",
                                             :maxLength 90,
                                             :minLength 1,
                                             :name "resourceGroupName",
                                             :pattern "^[-\\w\\._\\(\\)]+$",
                                             :required true,
                                             :type "string"}
                                            {:description "Parameters supplied to update a resource group.",
                                             :in "body",
                                             :name "parameters",
                                             :required true,
                                             :schema {:reference/definitions "ResourceGroupPatchable"}}
                                            {:reference/parameters "ApiVersionParameter"}
                                            {:reference/parameters "SubscriptionIdParameter"}],
                               :verb :patch},
       :DeploymentOperations_GetAtTenantScope {:path "/providers/Microsoft.Resources/deployments/{deploymentName}/operations/{operationId}",
                                               :description "Gets a deployments operation.",
                                               :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                            {:description "The ID of the operation to get.",
                                                             :in "path",
                                                             :name "operationId",
                                                             :required true,
                                                             :type "string"}
                                                            {:reference/parameters "ApiVersionParameter"}],
                                               :verb :get},
       :DeploymentOperations_ListAtScope {:path "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/operations",
                                          :description "Gets all deployments operations for a deployment.",
                                          :parameters [{:reference/parameters "ScopeParameter"}
                                                       {:reference/parameters "DeploymentNameParameter"}
                                                       {:description "The number of results to return.",
                                                        :format "int32",
                                                        :in "query",
                                                        :name "$top",
                                                        :required false,
                                                        :type "integer"}
                                                       {:reference/parameters "ApiVersionParameter"}],
                                          :verb :get},
       :Tags_List {:path "/subscriptions/{subscriptionId}/tagNames",
                   :description "This operation performs a union of predefined tags, resource tags, resource group tags and subscription tags, and returns a summary of usage for each tag name and value under the given subscription. In case of a large number of tags, this operation may return a previously cached result.",
                   :parameters [{:reference/parameters "ApiVersionParameter"}
                                {:reference/parameters "SubscriptionIdParameter"}],
                   :verb :get},
       :Resources_MoveResources {:path "/subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/moveResources",
                                 :description "The resources to move must be in the same source resource group. The target resource group may be in a different subscription. When moving resources, both the source group and the target group are locked for the duration of the operation. Write and delete operations are blocked on the groups until the move completes. ",
                                 :parameters [{:description "The name of the resource group containing the resources to move.",
                                               :in "path",
                                               :maxLength 90,
                                               :minLength 1,
                                               :name "sourceResourceGroupName",
                                               :pattern "^[-\\w\\._\\(\\)]+$",
                                               :required true,
                                               :type "string"}
                                              {:description "Parameters for moving resources.",
                                               :in "body",
                                               :name "parameters",
                                               :required true,
                                               :schema {:reference/definitions "ResourcesMoveInfo"}}
                                              {:reference/parameters "ApiVersionParameter"}
                                              {:reference/parameters "SubscriptionIdParameter"}],
                                 :verb :post},
       :DeploymentOperations_ListAtTenantScope {:path "/providers/Microsoft.Resources/deployments/{deploymentName}/operations",
                                                :description "Gets all deployments operations for a deployment.",
                                                :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                             {:description "The number of results to return.",
                                                              :format "int32",
                                                              :in "query",
                                                              :name "$top",
                                                              :required false,
                                                              :type "integer"}
                                                             {:reference/parameters "ApiVersionParameter"}],
                                                :verb :get},
       :Providers_Register {:path "/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}/register",
                            :description "Registers a subscription with a resource provider.",
                            :parameters [{:description "The namespace of the resource provider to register.",
                                          :in "path",
                                          :name "resourceProviderNamespace",
                                          :required true,
                                          :type "string"}
                                         {:reference/parameters "ApiVersionParameter"}
                                         {:reference/parameters "SubscriptionIdParameter"}],
                            :verb :post},
       :ResourceGroups_List {:path "/subscriptions/{subscriptionId}/resourcegroups",
                             :description "Gets all the resource groups for a subscription.",
                             :parameters [{:description "The filter to apply on the operation.<br><br>You can filter by tag names and values. For example, to filter for a tag name and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'",
                                           :in "query",
                                           :name "$filter",
                                           :required false,
                                           :type "string"}
                                          {:description "The number of results to return. If null is passed, returns all resource groups.",
                                           :format "int32",
                                           :in "query",
                                           :name "$top",
                                           :required false,
                                           :type "integer"}
                                          {:reference/parameters "ApiVersionParameter"}
                                          {:reference/parameters "SubscriptionIdParameter"}],
                             :verb :get},
       :Deployments_ValidateAtScope {:path "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/validate",
                                     :description "Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..",
                                     :parameters [{:reference/parameters "ScopeParameter"}
                                                  {:reference/parameters "DeploymentNameParameter"}
                                                  {:description "Parameters to validate.",
                                                   :in "body",
                                                   :name "parameters",
                                                   :required true,
                                                   :schema {:reference/definitions "Deployment"}}
                                                  {:reference/parameters "ApiVersionParameter"}],
                                     :verb :post},
       :Deployments_ListByResourceGroup {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/",
                                         :description "Get all the deployments for a resource group.",
                                         :parameters [{:description "The name of the resource group with the deployments to get. The name is case insensitive.",
                                                       :in "path",
                                                       :maxLength 90,
                                                       :minLength 1,
                                                       :name "resourceGroupName",
                                                       :pattern "^[-\\w\\._\\(\\)]+$",
                                                       :required true,
                                                       :type "string"}
                                                      {:description "The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.",
                                                       :in "query",
                                                       :name "$filter",
                                                       :required false,
                                                       :type "string"}
                                                      {:description "The number of results to get. If null is passed, returns all deployments.",
                                                       :format "int32",
                                                       :in "query",
                                                       :name "$top",
                                                       :required false,
                                                       :type "integer"}
                                                      {:reference/parameters "ApiVersionParameter"}
                                                      {:reference/parameters "SubscriptionIdParameter"}],
                                         :verb :get},
       :DeploymentOperations_Get {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/deployments/{deploymentName}/operations/{operationId}",
                                  :description "Gets a deployments operation.",
                                  :parameters [{:description "The name of the resource group. The name is case insensitive.",
                                                :in "path",
                                                :maxLength 90,
                                                :minLength 1,
                                                :name "resourceGroupName",
                                                :pattern "^[-\\w\\._\\(\\)]+$",
                                                :required true,
                                                :type "string"}
                                               {:reference/parameters "DeploymentNameParameter"}
                                               {:description "The ID of the operation to get.",
                                                :in "path",
                                                :name "operationId",
                                                :required true,
                                                :type "string"}
                                               {:reference/parameters "ApiVersionParameter"}
                                               {:reference/parameters "SubscriptionIdParameter"}],
                                  :verb :get},
       :Resources_ValidateMoveResources {:path "/subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/validateMoveResources",
                                         :description "This operation checks whether the specified resources can be moved to the target. The resources to move must be in the same source resource group. The target resource group may be in a different subscription. If validation succeeds, it returns HTTP response code 204 (no content). If validation fails, it returns HTTP response code 409 (Conflict) with an error message. Retrieve the URL in the Location header value to check the result of the long-running operation.",
                                         :parameters [{:description "The name of the resource group containing the resources to validate for move.",
                                                       :in "path",
                                                       :maxLength 90,
                                                       :minLength 1,
                                                       :name "sourceResourceGroupName",
                                                       :pattern "^[-\\w\\._\\(\\)]+$",
                                                       :required true,
                                                       :type "string"}
                                                      {:description "Parameters for moving resources.",
                                                       :in "body",
                                                       :name "parameters",
                                                       :required true,
                                                       :schema {:reference/definitions "ResourcesMoveInfo"}}
                                                      {:reference/parameters "ApiVersionParameter"}
                                                      {:reference/parameters "SubscriptionIdParameter"}],
                                         :verb :post},
       :Deployments_ListAtTenantScope {:path "/providers/Microsoft.Resources/deployments/",
                                       :description "Get all the deployments at the tenant scope.",
                                       :parameters [{:description "The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.",
                                                     :in "query",
                                                     :name "$filter",
                                                     :required false,
                                                     :type "string"}
                                                    {:description "The number of results to get. If null is passed, returns all deployments.",
                                                     :format "int32",
                                                     :in "query",
                                                     :name "$top",
                                                     :required false,
                                                     :type "integer"}
                                                    {:reference/parameters "ApiVersionParameter"}],
                                       :verb :get},
       :Deployments_Validate {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/validate",
                              :description "Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..",
                              :parameters [{:description "The name of the resource group the template will be deployed to. The name is case insensitive.",
                                            :in "path",
                                            :maxLength 90,
                                            :minLength 1,
                                            :name "resourceGroupName",
                                            :pattern "^[-\\w\\._\\(\\)]+$",
                                            :required true,
                                            :type "string"}
                                           {:reference/parameters "DeploymentNameParameter"}
                                           {:description "Parameters to validate.",
                                            :in "body",
                                            :name "parameters",
                                            :required true,
                                            :schema {:reference/definitions "Deployment"}}
                                           {:reference/parameters "ApiVersionParameter"}
                                           {:reference/parameters "SubscriptionIdParameter"}],
                              :verb :post},
       :Deployments_ListAtScope {:path "/{scope}/providers/Microsoft.Resources/deployments/",
                                 :description "Get all the deployments at the given scope.",
                                 :parameters [{:reference/parameters "ScopeParameter"}
                                              {:description "The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.",
                                               :in "query",
                                               :name "$filter",
                                               :required false,
                                               :type "string"}
                                              {:description "The number of results to get. If null is passed, returns all deployments.",
                                               :format "int32",
                                               :in "query",
                                               :name "$top",
                                               :required false,
                                               :type "integer"}
                                              {:reference/parameters "ApiVersionParameter"}],
                                 :verb :get},
       :DeploymentOperations_GetAtSubscriptionScope {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/operations/{operationId}",
                                                     :description "Gets a deployments operation.",
                                                     :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                                  {:description "The ID of the operation to get.",
                                                                   :in "path",
                                                                   :name "operationId",
                                                                   :required true,
                                                                   :type "string"}
                                                                  {:reference/parameters "ApiVersionParameter"}
                                                                  {:reference/parameters "SubscriptionIdParameter"}],
                                                     :verb :get},
       :Deployments_DeleteAtSubscriptionScope {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                               :description "A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.",
                                               :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                            {:reference/parameters "ApiVersionParameter"}
                                                            {:reference/parameters "SubscriptionIdParameter"}],
                                               :verb :delete},
       :DeploymentOperations_ListAtManagementGroupScope {:path "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/operations",
                                                         :description "Gets all deployments operations for a deployment.",
                                                         :parameters [{:reference/parameters "GroupIdParameter"}
                                                                      {:reference/parameters "DeploymentNameParameter"}
                                                                      {:description "The number of results to return.",
                                                                       :format "int32",
                                                                       :in "query",
                                                                       :name "$top",
                                                                       :required false,
                                                                       :type "integer"}
                                                                      {:reference/parameters "ApiVersionParameter"}],
                                                         :verb :get},
       :Deployments_ValidateAtTenantScope {:path "/providers/Microsoft.Resources/deployments/{deploymentName}/validate",
                                           :description "Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..",
                                           :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                        {:description "Parameters to validate.",
                                                         :in "body",
                                                         :name "parameters",
                                                         :required true,
                                                         :schema {:reference/definitions "ScopedDeployment"}}
                                                        {:reference/parameters "ApiVersionParameter"}],
                                           :verb :post},
       :Tags_CreateOrUpdateAtScope {:path "/{scope}/providers/Microsoft.Resources/tags/default",
                                    :description "This operation allows adding or replacing the entire set of tags on the specified resource or subscription. The specified entity can have a maximum of 50 tags.",
                                    :parameters [{:reference/parameters "ScopeParameter"}
                                                 {:reference/parameters "ApiVersionParameter"}
                                                 {:in "body",
                                                  :name "parameters",
                                                  :required true,
                                                  :schema {:reference/definitions "TagsResource"}}],
                                    :verb :put},
       :ResourceGroups_CreateOrUpdate {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}",
                                       :description "Creates or updates a resource group.",
                                       :parameters [{:description "The name of the resource group to create or update. Can include alphanumeric, underscore, parentheses, hyphen, period (except at end), and Unicode characters that match the allowed characters.",
                                                     :in "path",
                                                     :maxLength 90,
                                                     :minLength 1,
                                                     :name "resourceGroupName",
                                                     :pattern "^[-\\w\\._\\(\\)]+$",
                                                     :required true,
                                                     :type "string"}
                                                    {:description "Parameters supplied to the create or update a resource group.",
                                                     :in "body",
                                                     :name "parameters",
                                                     :required true,
                                                     :schema {:reference/definitions "ResourceGroup"}}
                                                    {:reference/parameters "ApiVersionParameter"}
                                                    {:reference/parameters "SubscriptionIdParameter"}],
                                       :verb :put},
       :Resources_CheckExistenceById {:path "/{resourceId}",
                                      :description "Checks by ID whether a resource exists.",
                                      :parameters [{:description "The fully qualified ID of the resource, including the resource name and resource type. Use the format, /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}",
                                                    :in "path",
                                                    :name "resourceId",
                                                    :required true,
                                                    :type "string",
                                                    :x-ms-skip-url-encoding true}
                                                   {:description "The API version to use for the operation.",
                                                    :in "query",
                                                    :name "api-version",
                                                    :required true,
                                                    :type "string"}],
                                      :verb :head},
       :Tags_DeleteValue {:path "/subscriptions/{subscriptionId}/tagNames/{tagName}/tagValues/{tagValue}",
                          :description "This operation allows deleting a value from the list of predefined values for an existing predefined tag name. The value being deleted must not be in use as a tag value for the given tag name for any resource.",
                          :parameters [{:description "The name of the tag.",
                                        :in "path",
                                        :name "tagName",
                                        :required true,
                                        :type "string"}
                                       {:description "The value of the tag to delete.",
                                        :in "path",
                                        :name "tagValue",
                                        :required true,
                                        :type "string"}
                                       {:reference/parameters "ApiVersionParameter"}
                                       {:reference/parameters "SubscriptionIdParameter"}],
                          :verb :delete},
       :Deployments_ExportTemplateAtManagementGroupScope {:path "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate",
                                                          :description "Exports the template used for specified deployment.",
                                                          :parameters [{:reference/parameters "GroupIdParameter"}
                                                                       {:reference/parameters "DeploymentNameParameter"}
                                                                       {:reference/parameters "ApiVersionParameter"}],
                                                          :verb :post},
       :Deployments_CreateOrUpdateAtManagementGroupScope {:path "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                                          :description "You can provide the template and parameters directly in the request or link to JSON files.",
                                                          :parameters [{:reference/parameters "GroupIdParameter"}
                                                                       {:reference/parameters "DeploymentNameParameter"}
                                                                       {:description "Additional parameters supplied to the operation.",
                                                                        :in "body",
                                                                        :name "parameters",
                                                                        :required true,
                                                                        :schema {:reference/definitions "ScopedDeployment"}}
                                                                       {:reference/parameters "ApiVersionParameter"}],
                                                          :verb :put},
       :Deployments_Cancel {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel",
                            :description "You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resource group partially deployed.",
                            :parameters [{:description "The name of the resource group. The name is case insensitive.",
                                          :in "path",
                                          :maxLength 90,
                                          :minLength 1,
                                          :name "resourceGroupName",
                                          :pattern "^[-\\w\\._\\(\\)]+$",
                                          :required true,
                                          :type "string"}
                                         {:reference/parameters "DeploymentNameParameter"}
                                         {:reference/parameters "ApiVersionParameter"}
                                         {:reference/parameters "SubscriptionIdParameter"}],
                            :verb :post},
       :Deployments_ExportTemplateAtSubscriptionScope {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate",
                                                       :description "Exports the template used for specified deployment.",
                                                       :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                                    {:reference/parameters "ApiVersionParameter"}
                                                                    {:reference/parameters "SubscriptionIdParameter"}],
                                                       :verb :post},
       :DeploymentOperations_List {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/deployments/{deploymentName}/operations",
                                   :description "Gets all deployments operations for a deployment.",
                                   :parameters [{:description "The name of the resource group. The name is case insensitive.",
                                                 :in "path",
                                                 :maxLength 90,
                                                 :minLength 1,
                                                 :name "resourceGroupName",
                                                 :pattern "^[-\\w\\._\\(\\)]+$",
                                                 :required true,
                                                 :type "string"}
                                                {:reference/parameters "DeploymentNameParameter"}
                                                {:description "The number of results to return.",
                                                 :format "int32",
                                                 :in "query",
                                                 :name "$top",
                                                 :required false,
                                                 :type "integer"}
                                                {:reference/parameters "ApiVersionParameter"}
                                                {:reference/parameters "SubscriptionIdParameter"}],
                                   :verb :get},
       :Deployments_WhatIf {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf",
                            :description "Returns changes that will be made by the deployment if executed at the scope of the resource group.",
                            :parameters [{:description "The name of the resource group the template will be deployed to. The name is case insensitive.",
                                          :in "path",
                                          :maxLength 90,
                                          :minLength 1,
                                          :name "resourceGroupName",
                                          :pattern "^[-\\w\\._\\(\\)]+$",
                                          :required true,
                                          :type "string"}
                                         {:reference/parameters "DeploymentNameParameter"}
                                         {:description "Parameters to validate.",
                                          :in "body",
                                          :name "parameters",
                                          :required true,
                                          :schema {:reference/definitions "DeploymentWhatIf"}}
                                         {:reference/parameters "ApiVersionParameter"}
                                         {:reference/parameters "SubscriptionIdParameter"}],
                            :verb :post},
       :Deployments_Delete {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}",
                            :description "A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. Deleting a template deployment does not affect the state of the resource group. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.",
                            :parameters [{:description "The name of the resource group with the deployment to delete. The name is case insensitive.",
                                          :in "path",
                                          :maxLength 90,
                                          :minLength 1,
                                          :name "resourceGroupName",
                                          :pattern "^[-\\w\\._\\(\\)]+$",
                                          :required true,
                                          :type "string"}
                                         {:reference/parameters "DeploymentNameParameter"}
                                         {:reference/parameters "ApiVersionParameter"}
                                         {:reference/parameters "SubscriptionIdParameter"}],
                            :verb :delete},
       :Tags_CreateOrUpdateValue {:path "/subscriptions/{subscriptionId}/tagNames/{tagName}/tagValues/{tagValue}",
                                  :description "This operation allows adding a value to the list of predefined values for an existing predefined tag name. A tag value can have a maximum of 256 characters.",
                                  :parameters [{:description "The name of the tag.",
                                                :in "path",
                                                :name "tagName",
                                                :required true,
                                                :type "string"}
                                               {:description "The value of the tag to create.",
                                                :in "path",
                                                :name "tagValue",
                                                :required true,
                                                :type "string"}
                                               {:reference/parameters "ApiVersionParameter"}
                                               {:reference/parameters "SubscriptionIdParameter"}],
                                  :verb :put},
       :Resources_UpdateById {:path "/{resourceId}",
                              :description "Updates a resource by ID.",
                              :parameters [{:description "The fully qualified ID of the resource, including the resource name and resource type. Use the format, /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}",
                                            :in "path",
                                            :name "resourceId",
                                            :required true,
                                            :type "string",
                                            :x-ms-skip-url-encoding true}
                                           {:description "The API version to use for the operation.",
                                            :in "query",
                                            :name "api-version",
                                            :required true,
                                            :type "string"}
                                           {:description "Update resource parameters.",
                                            :in "body",
                                            :name "parameters",
                                            :required true,
                                            :schema {:reference/definitions "GenericResource"}}],
                              :verb :patch},
       :Resources_GetById {:path "/{resourceId}",
                           :description "Gets a resource by ID.",
                           :parameters [{:description "The fully qualified ID of the resource, including the resource name and resource type. Use the format, /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}",
                                         :in "path",
                                         :name "resourceId",
                                         :required true,
                                         :type "string",
                                         :x-ms-skip-url-encoding true}
                                        {:description "The API version to use for the operation.",
                                         :in "query",
                                         :name "api-version",
                                         :required true,
                                         :type "string"}],
                           :verb :get},
       :Resources_CreateOrUpdateById {:path "/{resourceId}",
                                      :description "Create a resource by ID.",
                                      :parameters [{:description "The fully qualified ID of the resource, including the resource name and resource type. Use the format, /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}",
                                                    :in "path",
                                                    :name "resourceId",
                                                    :required true,
                                                    :type "string",
                                                    :x-ms-skip-url-encoding true}
                                                   {:description "The API version to use for the operation.",
                                                    :in "query",
                                                    :name "api-version",
                                                    :required true,
                                                    :type "string"}
                                                   {:description "Create or update resource parameters.",
                                                    :in "body",
                                                    :name "parameters",
                                                    :required true,
                                                    :schema {:reference/definitions "GenericResource"}}],
                                      :verb :put},
       :Deployments_DeleteAtManagementGroupScope {:path "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                                  :description "A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.",
                                                  :parameters [{:reference/parameters "GroupIdParameter"}
                                                               {:reference/parameters "DeploymentNameParameter"}
                                                               {:reference/parameters "ApiVersionParameter"}],
                                                  :verb :delete},
       :Deployments_CheckExistence {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                    :description "Checks whether the deployment exists.",
                                    :parameters [{:description "The name of the resource group with the deployment to check. The name is case insensitive.",
                                                  :in "path",
                                                  :maxLength 90,
                                                  :minLength 1,
                                                  :name "resourceGroupName",
                                                  :pattern "^[-\\w\\._\\(\\)]+$",
                                                  :required true,
                                                  :type "string"}
                                                 {:reference/parameters "DeploymentNameParameter"}
                                                 {:reference/parameters "ApiVersionParameter"}
                                                 {:reference/parameters "SubscriptionIdParameter"}],
                                    :verb :head},
       :Providers_Get {:path "/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}",
                       :description "Gets the specified resource provider.",
                       :parameters [{:description "The $expand query parameter. For example, to include property aliases in response, use $expand=resourceTypes/aliases.",
                                     :in "query",
                                     :name "$expand",
                                     :required false,
                                     :type "string"}
                                    {:description "The namespace of the resource provider.",
                                     :in "path",
                                     :name "resourceProviderNamespace",
                                     :required true,
                                     :type "string"}
                                    {:reference/parameters "ApiVersionParameter"}
                                    {:reference/parameters "SubscriptionIdParameter"}],
                       :verb :get},
       :Providers_ListAtTenantScope {:path "/providers",
                                     :description "Gets all resource providers for the tenant.",
                                     :parameters [{:description "The number of results to return. If null is passed returns all providers.",
                                                   :format "int32",
                                                   :in "query",
                                                   :name "$top",
                                                   :required false,
                                                   :type "integer"}
                                                  {:description "The properties to include in the results. For example, use &$expand=metadata in the query string to retrieve resource provider metadata. To include property aliases in response, use $expand=resourceTypes/aliases.",
                                                   :in "query",
                                                   :name "$expand",
                                                   :required false,
                                                   :type "string"}
                                                  {:reference/parameters "ApiVersionParameter"}],
                                     :verb :get},
       :Deployments_CheckExistenceAtScope {:path "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                           :description "Checks whether the deployment exists.",
                                           :parameters [{:reference/parameters "ScopeParameter"}
                                                        {:reference/parameters "DeploymentNameParameter"}
                                                        {:reference/parameters "ApiVersionParameter"}],
                                           :verb :head},
       :Deployments_WhatIfAtSubscriptionScope {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf",
                                               :description "Returns changes that will be made by the deployment if executed at the scope of the subscription.",
                                               :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                            {:description "Parameters to What If.",
                                                             :in "body",
                                                             :name "parameters",
                                                             :required true,
                                                             :schema {:reference/definitions "DeploymentWhatIf"}}
                                                            {:reference/parameters "ApiVersionParameter"}
                                                            {:reference/parameters "SubscriptionIdParameter"}],
                                               :verb :post},
       :Resources_Update {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}",
                          :description "Updates a resource.",
                          :parameters [{:description "The name of the resource group for the resource. The name is case insensitive.",
                                        :in "path",
                                        :maxLength 90,
                                        :minLength 1,
                                        :name "resourceGroupName",
                                        :pattern "^[-\\w\\._\\(\\)]+$",
                                        :required true,
                                        :type "string"}
                                       {:description "The namespace of the resource provider.",
                                        :in "path",
                                        :name "resourceProviderNamespace",
                                        :required true,
                                        :type "string"}
                                       {:description "The parent resource identity.",
                                        :in "path",
                                        :name "parentResourcePath",
                                        :required true,
                                        :type "string",
                                        :x-ms-skip-url-encoding true}
                                       {:description "The resource type of the resource to update.",
                                        :in "path",
                                        :name "resourceType",
                                        :required true,
                                        :type "string",
                                        :x-ms-skip-url-encoding true}
                                       {:description "The name of the resource to update.",
                                        :in "path",
                                        :name "resourceName",
                                        :required true,
                                        :type "string"}
                                       {:description "The API version to use for the operation.",
                                        :in "query",
                                        :name "api-version",
                                        :required true,
                                        :type "string"}
                                       {:description "Parameters for updating the resource.",
                                        :in "body",
                                        :name "parameters",
                                        :required true,
                                        :schema {:reference/definitions "GenericResource"}}
                                       {:reference/parameters "SubscriptionIdParameter"}],
                          :verb :patch},
       :Deployments_CancelAtManagementGroupScope {:path "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel",
                                                  :description "You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.",
                                                  :parameters [{:reference/parameters "GroupIdParameter"}
                                                               {:reference/parameters "DeploymentNameParameter"}
                                                               {:reference/parameters "ApiVersionParameter"}],
                                                  :verb :post},
       :Deployments_ListAtManagementGroupScope {:path "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/",
                                                :description "Get all the deployments for a management group.",
                                                :parameters [{:reference/parameters "GroupIdParameter"}
                                                             {:description "The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.",
                                                              :in "query",
                                                              :name "$filter",
                                                              :required false,
                                                              :type "string"}
                                                             {:description "The number of results to get. If null is passed, returns all deployments.",
                                                              :format "int32",
                                                              :in "query",
                                                              :name "$top",
                                                              :required false,
                                                              :type "integer"}
                                                             {:reference/parameters "ApiVersionParameter"}],
                                                :verb :get},
       :Providers_List {:path "/subscriptions/{subscriptionId}/providers",
                        :description "Gets all resource providers for a subscription.",
                        :parameters [{:description "The number of results to return. If null is passed returns all deployments.",
                                      :format "int32",
                                      :in "query",
                                      :name "$top",
                                      :required false,
                                      :type "integer"}
                                     {:description "The properties to include in the results. For example, use &$expand=metadata in the query string to retrieve resource provider metadata. To include property aliases in response, use $expand=resourceTypes/aliases.",
                                      :in "query",
                                      :name "$expand",
                                      :required false,
                                      :type "string"}
                                     {:reference/parameters "ApiVersionParameter"}
                                     {:reference/parameters "SubscriptionIdParameter"}],
                        :verb :get},
       :ResourceGroups_ExportTemplate {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/exportTemplate",
                                       :description "Captures the specified resource group as a template.",
                                       :parameters [{:description "The ID of the target subscription.",
                                                     :in "path",
                                                     :minLength 1,
                                                     :name "subscriptionId",
                                                     :required true,
                                                     :type "string"}
                                                    {:description "The name of the resource group. The name is case insensitive.",
                                                     :name "resourceGroupName",
                                                     :type "string",
                                                     :minLength 1,
                                                     :x-ms-parameter-location "method",
                                                     :maxLength 90,
                                                     :required true,
                                                     :in "path",
                                                     :pattern "^[-\\w\\._\\(\\)]+$"}
                                                    {:description "The API version to use for this operation.",
                                                     :in "query",
                                                     :minLength 1,
                                                     :name "api-version",
                                                     :required true,
                                                     :type "string"}
                                                    {:description "Parameters for exporting the template.",
                                                     :in "body",
                                                     :name "parameters",
                                                     :required true,
                                                     :schema {:reference/definitions "ExportTemplateRequest"}}],
                                       :verb :post},
       :Deployments_DeleteAtScope {:path "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                   :description "A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.",
                                   :parameters [{:reference/parameters "ScopeParameter"}
                                                {:reference/parameters "DeploymentNameParameter"}
                                                {:reference/parameters "ApiVersionParameter"}],
                                   :verb :delete},
       :Deployments_CreateOrUpdateAtSubscriptionScope {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                                       :description "You can provide the template and parameters directly in the request or link to JSON files.",
                                                       :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                                    {:description "Additional parameters supplied to the operation.",
                                                                     :in "body",
                                                                     :name "parameters",
                                                                     :required true,
                                                                     :schema {:reference/definitions "Deployment"}}
                                                                    {:reference/parameters "ApiVersionParameter"}
                                                                    {:reference/parameters "SubscriptionIdParameter"}],
                                                       :verb :put},
       :Resources_ListByResourceGroup {:path "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/resources",
                                       :description "Get all the resources for a resource group.",
                                       :parameters [{:description "The resource group with the resources to get.",
                                                     :in "path",
                                                     :maxLength 90,
                                                     :minLength 1,
                                                     :name "resourceGroupName",
                                                     :pattern "^[-\\w\\._\\(\\)]+$",
                                                     :required true,
                                                     :type "string"}
                                                    {:description "The filter to apply on the operation.<br><br>The properties you can use for eq (equals) or ne (not equals) are: location, resourceType, name, resourceGroup, identity, identity/principalId, plan, plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.<br><br>For example, to filter by a resource type, use: $filter=resourceType eq 'Microsoft.Network/virtualNetworks'<br><br>You can use substringof(value, property) in the filter. The properties you can use for substring are: name and resourceGroup.<br><br>For example, to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo', name)<br><br>You can link more than one substringof together by adding and/or operators.<br><br>You can filter by tag names and values. For example, to filter for a tag name and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value, the tags for each resource are not returned in the results.<br><br>You can use some properties together when filtering. The combinations you can use are: substringof and/or resourceType, plan and plan/publisher and plan/name, identity and identity/principalId.",
                                                     :in "query",
                                                     :name "$filter",
                                                     :required false,
                                                     :type "string"}
                                                    {:description "The $expand query parameter. You can expand createdTime and changedTime. For example, to expand both properties, use $expand=changedTime,createdTime",
                                                     :in "query",
                                                     :name "$expand",
                                                     :required false,
                                                     :type "string"}
                                                    {:description "The number of results to return. If null is passed, returns all resources.",
                                                     :format "int32",
                                                     :in "query",
                                                     :name "$top",
                                                     :required false,
                                                     :type "integer"}
                                                    {:reference/parameters "ApiVersionParameter"}
                                                    {:reference/parameters "SubscriptionIdParameter"}],
                                       :verb :get},
       :Deployments_ListAtSubscriptionScope {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/",
                                             :description "Get all the deployments for a subscription.",
                                             :parameters [{:description "The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.",
                                                           :in "query",
                                                           :name "$filter",
                                                           :required false,
                                                           :type "string"}
                                                          {:description "The number of results to get. If null is passed, returns all deployments.",
                                                           :format "int32",
                                                           :in "query",
                                                           :name "$top",
                                                           :required false,
                                                           :type "integer"}
                                                          {:reference/parameters "ApiVersionParameter"}
                                                          {:reference/parameters "SubscriptionIdParameter"}],
                                             :verb :get},
       :Resources_Delete {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}",
                          :description "Deletes a resource.",
                          :parameters [{:description "The name of the resource group that contains the resource to delete. The name is case insensitive.",
                                        :in "path",
                                        :maxLength 90,
                                        :minLength 1,
                                        :name "resourceGroupName",
                                        :pattern "^[-\\w\\._\\(\\)]+$",
                                        :required true,
                                        :type "string"}
                                       {:description "The namespace of the resource provider.",
                                        :in "path",
                                        :name "resourceProviderNamespace",
                                        :required true,
                                        :type "string"}
                                       {:description "The parent resource identity.",
                                        :in "path",
                                        :name "parentResourcePath",
                                        :required true,
                                        :type "string",
                                        :x-ms-skip-url-encoding true}
                                       {:description "The resource type.",
                                        :in "path",
                                        :name "resourceType",
                                        :required true,
                                        :type "string",
                                        :x-ms-skip-url-encoding true}
                                       {:description "The name of the resource to delete.",
                                        :in "path",
                                        :name "resourceName",
                                        :required true,
                                        :type "string"}
                                       {:description "The API version to use for the operation.",
                                        :in "query",
                                        :name "api-version",
                                        :required true,
                                        :type "string"}
                                       {:reference/parameters "SubscriptionIdParameter"}],
                          :verb :delete},
       :Deployments_CreateOrUpdateAtScope {:path "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                           :description "You can provide the template and parameters directly in the request or link to JSON files.",
                                           :parameters [{:reference/parameters "ScopeParameter"}
                                                        {:reference/parameters "DeploymentNameParameter"}
                                                        {:description "Additional parameters supplied to the operation.",
                                                         :in "body",
                                                         :name "parameters",
                                                         :required true,
                                                         :schema {:reference/definitions "Deployment"}}
                                                        {:reference/parameters "ApiVersionParameter"}],
                                           :verb :put},
       :Deployments_ValidateAtManagementGroupScope {:path "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate",
                                                    :description "Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..",
                                                    :parameters [{:reference/parameters "GroupIdParameter"}
                                                                 {:reference/parameters "DeploymentNameParameter"}
                                                                 {:description "Parameters to validate.",
                                                                  :in "body",
                                                                  :name "parameters",
                                                                  :required true,
                                                                  :schema {:reference/definitions "ScopedDeployment"}}
                                                                 {:reference/parameters "ApiVersionParameter"}],
                                                    :verb :post},
       :Tags_UpdateAtScope {:path "/{scope}/providers/Microsoft.Resources/tags/default",
                            :description "This operation allows replacing, merging or selectively deleting tags on the specified resource or subscription. The specified entity can have a maximum of 50 tags at the end of the operation. The 'replace' option replaces the entire set of existing tags with a new set. The 'merge' option allows adding tags with new names and updating the values of tags with existing names. The 'delete' option allows selectively deleting tags based on given names or name/value pairs.",
                            :parameters [{:reference/parameters "ScopeParameter"}
                                         {:reference/parameters "ApiVersionParameter"}
                                         {:in "body",
                                          :name "parameters",
                                          :required true,
                                          :schema {:reference/definitions "TagsPatchResource"}}],
                            :verb :patch},
       :DeploymentOperations_GetAtManagementGroupScope {:path "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/operations/{operationId}",
                                                        :description "Gets a deployments operation.",
                                                        :parameters [{:reference/parameters "GroupIdParameter"}
                                                                     {:reference/parameters "DeploymentNameParameter"}
                                                                     {:description "The ID of the operation to get.",
                                                                      :in "path",
                                                                      :name "operationId",
                                                                      :required true,
                                                                      :type "string"}
                                                                     {:reference/parameters "ApiVersionParameter"}],
                                                        :verb :get},
       :Deployments_ExportTemplate {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate",
                                    :description "Exports the template used for specified deployment.",
                                    :parameters [{:description "The name of the resource group. The name is case insensitive.",
                                                  :in "path",
                                                  :maxLength 90,
                                                  :minLength 1,
                                                  :name "resourceGroupName",
                                                  :pattern "^[-\\w\\._\\(\\)]+$",
                                                  :required true,
                                                  :type "string"}
                                                 {:reference/parameters "DeploymentNameParameter"}
                                                 {:reference/parameters "ApiVersionParameter"}
                                                 {:reference/parameters "SubscriptionIdParameter"}],
                                    :verb :post},
       :Tags_DeleteAtScope {:path "/{scope}/providers/Microsoft.Resources/tags/default",
                            :description nil,
                            :parameters [{:reference/parameters "ScopeParameter"}
                                         {:reference/parameters "ApiVersionParameter"}],
                            :verb :delete},
       :Deployments_GetAtTenantScope {:path "/providers/Microsoft.Resources/deployments/{deploymentName}",
                                      :description "Gets a deployment.",
                                      :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                   {:reference/parameters "ApiVersionParameter"}],
                                      :verb :get},
       :Deployments_GetAtScope {:path "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                :description "Gets a deployment.",
                                :parameters [{:reference/parameters "ScopeParameter"}
                                             {:reference/parameters "DeploymentNameParameter"}
                                             {:reference/parameters "ApiVersionParameter"}],
                                :verb :get},
       :Deployments_CreateOrUpdate {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                    :description "You can provide the template and parameters directly in the request or link to JSON files.",
                                    :parameters [{:description "The name of the resource group to deploy the resources to. The name is case insensitive. The resource group must already exist.",
                                                  :in "path",
                                                  :maxLength 90,
                                                  :minLength 1,
                                                  :name "resourceGroupName",
                                                  :pattern "^[-\\w\\._\\(\\)]+$",
                                                  :required true,
                                                  :type "string"}
                                                 {:reference/parameters "DeploymentNameParameter"}
                                                 {:description "Additional parameters supplied to the operation.",
                                                  :in "body",
                                                  :name "parameters",
                                                  :required true,
                                                  :schema {:reference/definitions "Deployment"}}
                                                 {:reference/parameters "ApiVersionParameter"}
                                                 {:reference/parameters "SubscriptionIdParameter"}],
                                    :verb :put},
       :Resources_List {:path "/subscriptions/{subscriptionId}/resources",
                        :description "Get all the resources in a subscription.",
                        :parameters [{:description "The filter to apply on the operation.<br><br>The properties you can use for eq (equals) or ne (not equals) are: location, resourceType, name, resourceGroup, identity, identity/principalId, plan, plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.<br><br>For example, to filter by a resource type, use: $filter=resourceType eq 'Microsoft.Network/virtualNetworks'<br><br>You can use substringof(value, property) in the filter. The properties you can use for substring are: name and resourceGroup.<br><br>For example, to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo', name)<br><br>You can link more than one substringof together by adding and/or operators.<br><br>You can filter by tag names and values. For example, to filter for a tag name and value, use $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value, the tags for each resource are not returned in the results.<br><br>You can use some properties together when filtering. The combinations you can use are: substringof and/or resourceType, plan and plan/publisher and plan/name, identity and identity/principalId.",
                                      :in "query",
                                      :name "$filter",
                                      :required false,
                                      :type "string"}
                                     {:description "The $expand query parameter. You can expand createdTime and changedTime. For example, to expand both properties, use $expand=changedTime,createdTime",
                                      :in "query",
                                      :name "$expand",
                                      :required false,
                                      :type "string"}
                                     {:description "The number of results to return. If null is passed, returns all resource groups.",
                                      :format "int32",
                                      :in "query",
                                      :name "$top",
                                      :required false,
                                      :type "integer"}
                                     {:reference/parameters "ApiVersionParameter"}
                                     {:reference/parameters "SubscriptionIdParameter"}],
                        :verb :get},
       :Resources_DeleteById {:path "/{resourceId}",
                              :description "Deletes a resource by ID.",
                              :parameters [{:description "The fully qualified ID of the resource, including the resource name and resource type. Use the format, /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}",
                                            :in "path",
                                            :name "resourceId",
                                            :required true,
                                            :type "string",
                                            :x-ms-skip-url-encoding true}
                                           {:description "The API version to use for the operation.",
                                            :in "query",
                                            :name "api-version",
                                            :required true,
                                            :type "string"}],
                              :verb :delete},
       :Resources_Get {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}",
                       :description "Gets a resource.",
                       :parameters [{:description "The name of the resource group containing the resource to get. The name is case insensitive.",
                                     :in "path",
                                     :maxLength 90,
                                     :minLength 1,
                                     :name "resourceGroupName",
                                     :pattern "^[-\\w\\._\\(\\)]+$",
                                     :required true,
                                     :type "string"}
                                    {:description "The namespace of the resource provider.",
                                     :in "path",
                                     :name "resourceProviderNamespace",
                                     :required true,
                                     :type "string"}
                                    {:description "The parent resource identity.",
                                     :in "path",
                                     :name "parentResourcePath",
                                     :required true,
                                     :type "string",
                                     :x-ms-skip-url-encoding true}
                                    {:description "The resource type of the resource.",
                                     :in "path",
                                     :name "resourceType",
                                     :required true,
                                     :type "string",
                                     :x-ms-skip-url-encoding true}
                                    {:description "The name of the resource to get.",
                                     :in "path",
                                     :name "resourceName",
                                     :required true,
                                     :type "string"}
                                    {:description "The API version to use for the operation.",
                                     :in "query",
                                     :name "api-version",
                                     :required true,
                                     :type "string"}
                                    {:reference/parameters "SubscriptionIdParameter"}],
                       :verb :get},
       :Deployments_CheckExistenceAtSubscriptionScope {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                                       :description "Checks whether the deployment exists.",
                                                       :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                                    {:reference/parameters "ApiVersionParameter"}
                                                                    {:reference/parameters "SubscriptionIdParameter"}],
                                                       :verb :head},
       :Tags_CreateOrUpdate {:path "/subscriptions/{subscriptionId}/tagNames/{tagName}",
                             :description "This operation allows adding a name to the list of predefined tag names for the given subscription. A tag name can have a maximum of 512 characters and is case-insensitive. Tag names cannot have the following prefixes which are reserved for Azure use: 'microsoft', 'azure', 'windows'.",
                             :parameters [{:description "The name of the tag to create.",
                                           :in "path",
                                           :name "tagName",
                                           :required true,
                                           :type "string"}
                                          {:reference/parameters "ApiVersionParameter"}
                                          {:reference/parameters "SubscriptionIdParameter"}],
                             :verb :put},
       :Providers_GetAtTenantScope {:path "/providers/{resourceProviderNamespace}",
                                    :description "Gets the specified resource provider at the tenant level.",
                                    :parameters [{:description "The $expand query parameter. For example, to include property aliases in response, use $expand=resourceTypes/aliases.",
                                                  :in "query",
                                                  :name "$expand",
                                                  :required false,
                                                  :type "string"}
                                                 {:description "The namespace of the resource provider.",
                                                  :in "path",
                                                  :name "resourceProviderNamespace",
                                                  :required true,
                                                  :type "string"}
                                                 {:reference/parameters "ApiVersionParameter"}],
                                    :verb :get},
       :Deployments_ExportTemplateAtTenantScope {:path "/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate",
                                                 :description "Exports the template used for specified deployment.",
                                                 :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                              {:reference/parameters "ApiVersionParameter"}],
                                                 :verb :post},
       :Deployments_CheckExistenceAtTenantScope {:path "/providers/Microsoft.Resources/deployments/{deploymentName}",
                                                 :description "Checks whether the deployment exists.",
                                                 :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                              {:reference/parameters "ApiVersionParameter"}],
                                                 :verb :head},
       :Deployments_ValidateAtSubscriptionScope {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate",
                                                 :description "Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..",
                                                 :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                              {:description "Parameters to validate.",
                                                               :in "body",
                                                               :name "parameters",
                                                               :required true,
                                                               :schema {:reference/definitions "Deployment"}}
                                                              {:reference/parameters "ApiVersionParameter"}
                                                              {:reference/parameters "SubscriptionIdParameter"}],
                                                 :verb :post},
       :Deployments_Get {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}",
                         :description "Gets a deployment.",
                         :parameters [{:description "The name of the resource group. The name is case insensitive.",
                                       :in "path",
                                       :maxLength 90,
                                       :minLength 1,
                                       :name "resourceGroupName",
                                       :pattern "^[-\\w\\._\\(\\)]+$",
                                       :required true,
                                       :type "string"}
                                      {:reference/parameters "DeploymentNameParameter"}
                                      {:reference/parameters "ApiVersionParameter"}
                                      {:reference/parameters "SubscriptionIdParameter"}],
                         :verb :get},
       :Tags_GetAtScope {:path "/{scope}/providers/Microsoft.Resources/tags/default",
                         :description nil,
                         :parameters [{:reference/parameters "ScopeParameter"}
                                      {:reference/parameters "ApiVersionParameter"}],
                         :verb :get},
       :DeploymentOperations_ListAtSubscriptionScope {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/operations",
                                                      :description "Gets all deployments operations for a deployment.",
                                                      :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                                   {:description "The number of results to return.",
                                                                    :format "int32",
                                                                    :in "query",
                                                                    :name "$top",
                                                                    :required false,
                                                                    :type "integer"}
                                                                   {:reference/parameters "ApiVersionParameter"}
                                                                   {:reference/parameters "SubscriptionIdParameter"}],
                                                      :verb :get},
       :Deployments_GetAtManagementGroupScope {:path "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                               :description "Gets a deployment.",
                                               :parameters [{:reference/parameters "GroupIdParameter"}
                                                            {:reference/parameters "DeploymentNameParameter"}
                                                            {:reference/parameters "ApiVersionParameter"}],
                                               :verb :get},
       :DeploymentOperations_GetAtScope {:path "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/operations/{operationId}",
                                         :description "Gets a deployments operation.",
                                         :parameters [{:reference/parameters "ScopeParameter"}
                                                      {:reference/parameters "DeploymentNameParameter"}
                                                      {:description "The ID of the operation to get.",
                                                       :in "path",
                                                       :name "operationId",
                                                       :required true,
                                                       :type "string"}
                                                      {:reference/parameters "ApiVersionParameter"}],
                                         :verb :get},
       :Operations_List {:path "/providers/Microsoft.Resources/operations",
                         :description "Lists all of the available Microsoft.Resources REST API operations.",
                         :parameters [{:reference/parameters "ApiVersionParameter"}],
                         :verb :get},
       :Deployments_GetAtSubscriptionScope {:path "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                            :description "Gets a deployment.",
                                            :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                         {:reference/parameters "ApiVersionParameter"}
                                                         {:reference/parameters "SubscriptionIdParameter"}],
                                            :verb :get},
       :ResourceGroups_Delete {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}",
                               :description "When you delete a resource group, all of its resources are also deleted. Deleting a resource group deletes all of its template deployments and currently stored operations.",
                               :parameters [{:description "The name of the resource group to delete. The name is case insensitive.",
                                             :in "path",
                                             :maxLength 90,
                                             :minLength 1,
                                             :name "resourceGroupName",
                                             :pattern "^[-\\w\\._\\(\\)]+$",
                                             :required true,
                                             :type "string"}
                                            {:reference/parameters "ApiVersionParameter"}
                                            {:reference/parameters "SubscriptionIdParameter"}],
                               :verb :delete},
       :ResourceGroups_Get {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}",
                            :description "Gets a resource group.",
                            :parameters [{:description "The name of the resource group to get. The name is case insensitive.",
                                          :in "path",
                                          :maxLength 90,
                                          :minLength 1,
                                          :name "resourceGroupName",
                                          :pattern "^[-\\w\\._\\(\\)]+$",
                                          :required true,
                                          :type "string"}
                                         {:reference/parameters "ApiVersionParameter"}
                                         {:reference/parameters "SubscriptionIdParameter"}],
                            :verb :get},
       :Resources_CheckExistence {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}",
                                  :description "Checks whether a resource exists.",
                                  :parameters [{:description "The name of the resource group containing the resource to check. The name is case insensitive.",
                                                :in "path",
                                                :maxLength 90,
                                                :minLength 1,
                                                :name "resourceGroupName",
                                                :pattern "^[-\\w\\._\\(\\)]+$",
                                                :required true,
                                                :type "string"}
                                               {:description "The resource provider of the resource to check.",
                                                :in "path",
                                                :name "resourceProviderNamespace",
                                                :required true,
                                                :type "string"}
                                               {:description "The parent resource identity.",
                                                :in "path",
                                                :name "parentResourcePath",
                                                :required true,
                                                :type "string",
                                                :x-ms-skip-url-encoding true}
                                               {:description "The resource type.",
                                                :in "path",
                                                :name "resourceType",
                                                :required true,
                                                :type "string",
                                                :x-ms-skip-url-encoding true}
                                               {:description "The name of the resource to check whether it exists.",
                                                :in "path",
                                                :name "resourceName",
                                                :required true,
                                                :type "string"}
                                               {:description "The API version to use for the operation.",
                                                :in "query",
                                                :name "api-version",
                                                :required true,
                                                :type "string"}
                                               {:reference/parameters "SubscriptionIdParameter"}],
                                  :verb :head},
       :Deployments_CancelAtScope {:path "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel",
                                   :description "You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.",
                                   :parameters [{:reference/parameters "ScopeParameter"}
                                                {:reference/parameters "DeploymentNameParameter"}
                                                {:reference/parameters "ApiVersionParameter"}],
                                   :verb :post},
       :ResourceGroups_CheckExistence {:path "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}",
                                       :description "Checks whether a resource group exists.",
                                       :parameters [{:description "The name of the resource group to check. The name is case insensitive.",
                                                     :in "path",
                                                     :maxLength 90,
                                                     :minLength 1,
                                                     :name "resourceGroupName",
                                                     :pattern "^[-\\w\\._\\(\\)]+$",
                                                     :required true,
                                                     :type "string"}
                                                    {:reference/parameters "ApiVersionParameter"}
                                                    {:reference/parameters "SubscriptionIdParameter"}],
                                       :verb :head},
       :Deployments_CancelAtTenantScope {:path "/providers/Microsoft.Resources/deployments/{deploymentName}/cancel",
                                         :description "You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.",
                                         :parameters [{:reference/parameters "DeploymentNameParameter"}
                                                      {:reference/parameters "ApiVersionParameter"}],
                                         :verb :post},
       :Providers_Unregister {:path "/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}/unregister",
                              :description "Unregisters a subscription from a resource provider.",
                              :parameters [{:description "The namespace of the resource provider to unregister.",
                                            :in "path",
                                            :name "resourceProviderNamespace",
                                            :required true,
                                            :type "string"}
                                           {:reference/parameters "ApiVersionParameter"}
                                           {:reference/parameters "SubscriptionIdParameter"}],
                              :verb :post},
       :Deployments_CheckExistenceAtManagementGroupScope {:path "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}",
                                                          :description "Checks whether the deployment exists.",
                                                          :parameters [{:reference/parameters "GroupIdParameter"}
                                                                       {:reference/parameters "DeploymentNameParameter"}
                                                                       {:reference/parameters "ApiVersionParameter"}],
                                                          :verb :head},
       :Tags_Delete {:path "/subscriptions/{subscriptionId}/tagNames/{tagName}",
                     :description "This operation allows deleting a name from the list of predefined tag names for the given subscription. The name being deleted must not be in use as a tag name for any resource. All predefined values for the given name must have already been deleted.",
                     :parameters [{:description "The name of the tag.",
                                   :in "path",
                                   :name "tagName",
                                   :required true,
                                   :type "string"}
                                  {:reference/parameters "ApiVersionParameter"}
                                  {:reference/parameters "SubscriptionIdParameter"}],
                     :verb :delete}},
 :parameters {:ApiVersionParameter {:description "The API version to use for this operation.",
                                    :in "query",
                                    :name "api-version",
                                    :required true,
                                    :type "string"},
              :DeploymentNameParameter {:description "The name of the deployment.",
                                        :name "deploymentName",
                                        :type "string",
                                        :minLength 1,
                                        :x-ms-parameter-location "method",
                                        :maxLength 64,
                                        :required true,
                                        :in "path",
                                        :pattern "^[-\\w\\._\\(\\)]+$"},
              :GroupIdParameter {:description "The management group ID.",
                                 :in "path",
                                 :maxLength 90,
                                 :minLength 1,
                                 :name "groupId",
                                 :required true,
                                 :type "string",
                                 :x-ms-parameter-location "method"},
              :ScopeParameter {:description "The resource scope.",
                               :in "path",
                               :name "scope",
                               :required true,
                               :type "string",
                               :x-ms-parameter-location "method"},
              :SubscriptionIdParameter {:description "The ID of the target subscription.",
                                        :in "path",
                                        :name "subscriptionId",
                                        :required true,
                                        :type "string"}},
 :definitions {:ResourceGroup {:description "Resource group information.",
                               :properties {:id {:description "The ID of the resource group.",
                                                 :readOnly true,
                                                 :type "string"},
                                            :location {:description "The location of the resource group. It cannot be changed after the resource group has been created. It must be one of the supported Azure locations.",
                                                       :type "string"},
                                            :managedBy {:description "The ID of the resource that manages this resource group.",
                                                        :type "string"},
                                            :name {:description "The name of the resource group.",
                                                   :readOnly true,
                                                   :type "string"},
                                            :properties {:reference/definitions "ResourceGroupProperties"},
                                            :tags {:additionalProperties {:description "The additional properties. ",
                                                                          :type "string"},
                                                   :description "The tags attached to the resource group.",
                                                   :type "object"},
                                            :type {:description "The type of the resource group.",
                                                   :readOnly true,
                                                   :type "string"}},
                               :required ["location"],
                               :x-ms-azure-resource true},
               :TagsResource {:description "Wrapper resource for tags API requests and responses.",
                              :properties {:id {:description "The ID of the tags wrapper resource.",
                                                :readOnly true,
                                                :type "string"},
                                           :name {:description "The name of the tags wrapper resource.",
                                                  :readOnly true,
                                                  :type "string"},
                                           :properties {:reference/definitions "Tags"},
                                           :type {:description "The type of the tags wrapper resource.",
                                                  :readOnly true,
                                                  :type "string"}},
                              :required ["properties"],
                              :type "object",
                              :x-ms-azure-resource true},
               :OnErrorDeploymentExtended {:description "Deployment on error behavior with additional details.",
                                           :properties {:deploymentName {:description "The deployment to be used on error case.",
                                                                         :type "string"},
                                                        :provisioningState {:description "The state of the provisioning for the on error deployment.",
                                                                            :readOnly true,
                                                                            :type "string"},
                                                        :type {:description "The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.",
                                                               :enum ["LastSuccessful"
                                                                      "SpecificDeployment"],
                                                               :type "string",
                                                               :x-ms-enum {:modelAsString false,
                                                                           :name "OnErrorDeploymentType"}}}},
               :HttpMessage {:description "HTTP message.",
                             :properties {:content {:description "HTTP message content.",
                                                    :type "object"}}},
               :OperationListResult {:description "Result of the request to list Microsoft.Resources operations. It contains a list of operations and a URL link to get the next set of results.",
                                     :properties {:nextLink {:description "URL to get the next set of operation list results if there are any.",
                                                             :type "string"},
                                                  :value {:description "List of Microsoft.Resources operations.",
                                                          :items {:reference/definitions "Operation"},
                                                          :type "array"}}},
               :ExportTemplateRequest {:description "Export resource group template request parameters.",
                                       :properties {:options {:description "The export template options. A CSV-formatted list containing zero or more of the following: 'IncludeParameterDefaultValue', 'IncludeComments', 'SkipResourceNameParameterization', 'SkipAllParameterization'",
                                                              :type "string"},
                                                    :resources {:description "The IDs of the resources to filter the export by. To export all resources, supply an array with single entry '*'.",
                                                                :items {:type "string"},
                                                                :type "array"}}},
               :WhatIfPropertyChange {:description "The predicted change to the resource property.",
                                      :properties {:after {:description "The value of the property after the deployment is executed.",
                                                           :type "object"},
                                                   :before {:description "The value of the property before the deployment is executed.",
                                                            :type "object"},
                                                   :children {:description "Nested property changes.",
                                                              :items {:reference/definitions "WhatIfPropertyChange"},
                                                              :type "array"},
                                                   :path {:description "The path of the property.",
                                                          :type "string"},
                                                   :propertyChangeType {:description "The type of property change.",
                                                                        :enum ["Create"
                                                                               "Delete"
                                                                               "Modify"
                                                                               "Array"],
                                                                        :type "string",
                                                                        :x-ms-enum {:modelAsString false,
                                                                                    :name "PropertyChangeType",
                                                                                    :values [{:description "The property does not exist in the current state but is present in the desired state. The property will be created when the deployment is executed.",
                                                                                              :value "Create"}
                                                                                             {:description "The property exists in the current state and is missing from the desired state. It will be deleted when the deployment is executed.",
                                                                                              :value "Delete"}
                                                                                             {:description "The property exists in both current and desired state and is different. The value of the property will change when the deployment is executed.",
                                                                                              :value "Modify"}
                                                                                             {:description "The property is an array and contains nested changes.",
                                                                                              :value "Array"}]}}},
                                      :required ["path"
                                                 "propertyChangeType"]},
               :TemplateHashResult {:description "Result of the request to calculate template hash. It contains a string of minified template and its hash.",
                                    :properties {:minifiedTemplate {:description "The minified template string.",
                                                                    :type "string"},
                                                 :templateHash {:description "The template hash.",
                                                                :type "string"}}},
               :Identity {:description "Identity for the resource.",
                          :properties {:principalId {:description "The principal ID of resource identity.",
                                                     :readOnly true,
                                                     :type "string"},
                                       :tenantId {:description "The tenant ID of resource.",
                                                  :readOnly true,
                                                  :type "string"},
                                       :type {:description "The identity type.",
                                              :enum ["SystemAssigned"
                                                     "UserAssigned"
                                                     "SystemAssigned, UserAssigned"
                                                     "None"],
                                              :type "string",
                                              :x-ms-enum {:modelAsString false,
                                                          :name "ResourceIdentityType"}},
                                       :userAssignedIdentities {:additionalProperties {:properties {:clientId {:description "The client id of user assigned identity.",
                                                                                                               :readOnly true,
                                                                                                               :type "string"},
                                                                                                    :principalId {:description "The principal id of user assigned identity.",
                                                                                                                  :readOnly true,
                                                                                                                  :type "string"}},
                                                                                       :type "object"},
                                                                :description "The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.",
                                                                :type "object"}}},
               :DebugSetting {:description "The debug setting.",
                              :properties {:detailLevel {:description "Specifies the type of information to log for debugging. The permitted values are none, requestContent, responseContent, or both requestContent and responseContent separated by a comma. The default is none. When setting this value, carefully consider the type of information you are passing in during deployment. By logging information about the request or response, you could potentially expose sensitive data that is retrieved through the deployment operations.",
                                                         :type "string"}}},
               :DeploymentExtendedFilter {:description "Deployment filter.",
                                          :properties {:provisioningState {:description "The provisioning state.",
                                                                           :type "string"}}},
               :Operation {:description "Microsoft.Resources operation",
                           :properties {:display {:description "The object that represents the operation.",
                                                  :properties {:description {:description "Description of the operation.",
                                                                             :type "string"},
                                                               :operation {:description "Operation type: Read, write, delete, etc.",
                                                                           :type "string"},
                                                               :provider {:description "Service provider: Microsoft.Resources",
                                                                          :type "string"},
                                                               :resource {:description "Resource on which the operation is performed: Profile, endpoint, etc.",
                                                                          :type "string"}}},
                                        :name {:description "Operation name: {provider}/{resource}/{operation}",
                                               :type "string"}},
                           :type "object"},
               :DeploymentProperties {:description "Deployment properties.",
                                      :properties {:debugSetting {:reference/definitions "DebugSetting"},
                                                   :mode {:description "The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode, resources are deployed without deleting existing resources that are not included in the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included in the template are deleted. Be careful when using Complete mode as you may unintentionally delete resources.",
                                                          :enum ["Incremental"
                                                                 "Complete"],
                                                          :type "string",
                                                          :x-ms-enum {:modelAsString false,
                                                                      :name "DeploymentMode"}},
                                                   :onErrorDeployment {:reference/definitions "OnErrorDeployment"},
                                                   :parameters {:description "Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide the parameter values directly in the request rather than link to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.",
                                                                :type "object"},
                                                   :parametersLink {:reference/definitions "ParametersLink"},
                                                   :template {:description "The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both.",
                                                              :type "object"},
                                                   :templateLink {:reference/definitions "TemplateLink"}},
                                      :required ["mode"]},
               :Tags {:description "A dictionary of name and value pairs.",
                      :properties {:tags {:additionalProperties {:description "The tag value.",
                                                                 :type "string"},
                                          :type "object"}}},
               :DeploymentValidateResult {:description "Information from validate template deployment response.",
                                          :properties {:error {:description "The resource management error response.",
                                                               :properties {:additionalInfo {:description "The error additional info.",
                                                                                             :items {:description "The resource management error additional info.",
                                                                                                     :properties {:info {:description "The additional info.",
                                                                                                                         :readOnly true,
                                                                                                                         :type "object"},
                                                                                                                  :type {:description "The additional info type.",
                                                                                                                         :readOnly true,
                                                                                                                         :type "string"}}},
                                                                                             :readOnly true,
                                                                                             :type "array"},
                                                                            :code {:description "The error code.",
                                                                                   :readOnly true,
                                                                                   :type "string"},
                                                                            :details {:description "The error details.",
                                                                                      :items {:reference/definitions "ErrorResponse"},
                                                                                      :readOnly true,
                                                                                      :type "array"},
                                                                            :message {:description "The error message.",
                                                                                      :readOnly true,
                                                                                      :type "string"},
                                                                            :target {:description "The error target.",
                                                                                     :readOnly true,
                                                                                     :type "string"}}},
                                                       :properties {:reference/definitions "DeploymentPropertiesExtended"}}},
               :OnErrorDeployment {:description "Deployment on error behavior.",
                                   :properties {:deploymentName {:description "The deployment to be used on error case.",
                                                                 :type "string"},
                                                :type {:description "The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.",
                                                       :enum ["LastSuccessful"
                                                              "SpecificDeployment"],
                                                       :type "string",
                                                       :x-ms-enum {:modelAsString false,
                                                                   :name "OnErrorDeploymentType"}}}},
               :DeploymentExtended {:description "Deployment information.",
                                    :properties {:id {:description "The ID of the deployment.",
                                                      :readOnly true,
                                                      :type "string"},
                                                 :location {:description "the location of the deployment.",
                                                            :type "string"},
                                                 :name {:description "The name of the deployment.",
                                                        :readOnly true,
                                                        :type "string"},
                                                 :properties {:reference/definitions "DeploymentPropertiesExtended"},
                                                 :type {:description "The type of the deployment.",
                                                        :readOnly true,
                                                        :type "string"}},
                                    :x-ms-azure-resource true},
               :SubResource {:description "Sub-resource.",
                             :properties {:id {:description "Resource ID",
                                               :type "string"}},
                             :x-ms-azure-resource true},
               :ScopedDeployment {:description "Deployment operation parameters.",
                                  :properties {:location {:description "The location to store the deployment data.",
                                                          :type "string"},
                                               :properties {:reference/definitions "DeploymentProperties"}},
                                  :required ["location" "properties"]},
               :TagDetails {:description "Tag details.",
                            :properties {:count {:reference/definitions "TagCount"},
                                         :id {:description "The tag name ID.",
                                              :readOnly true,
                                              :type "string"},
                                         :tagName {:description "The tag name.",
                                                   :type "string"},
                                         :values {:description "The list of tag values.",
                                                  :items {:reference/definitions "TagValue"},
                                                  :type "array"}}},
               :DeploymentPropertiesExtended {:description "Deployment properties with additional details.",
                                              :properties {:providers {:description "The list of resource providers needed for the deployment.",
                                                                       :items {:reference/definitions "Provider"},
                                                                       :type "array"},
                                                           :templateLink {:reference/definitions "TemplateLink"},
                                                           :provisioningState {:description "The state of the provisioning.",
                                                                               :readOnly true,
                                                                               :type "string"},
                                                           :correlationId {:description "The correlation ID of the deployment.",
                                                                           :readOnly true,
                                                                           :type "string"},
                                                           :mode {:description "The deployment mode. Possible values are Incremental and Complete.",
                                                                  :enum ["Incremental"
                                                                         "Complete"],
                                                                  :type "string",
                                                                  :x-ms-enum {:modelAsString false,
                                                                              :name "DeploymentMode"}},
                                                           :template {:description "The template content. Use only one of Template or TemplateLink.",
                                                                      :type "object"},
                                                           :duration {:description "The duration of the template deployment.",
                                                                      :readOnly true,
                                                                      :type "string"},
                                                           :parametersLink {:reference/definitions "ParametersLink"},
                                                           :debugSetting {:reference/definitions "DebugSetting"},
                                                           :outputs {:description "Key/value pairs that represent deployment output.",
                                                                     :type "object"},
                                                           :timestamp {:description "The timestamp of the template deployment.",
                                                                       :format "date-time",
                                                                       :readOnly true,
                                                                       :type "string"},
                                                           :parameters {:description "Deployment parameters. Use only one of Parameters or ParametersLink.",
                                                                        :type "object"},
                                                           :dependencies {:description "The list of deployment dependencies.",
                                                                          :items {:reference/definitions "Dependency"},
                                                                          :type "array"},
                                                           :onErrorDeployment {:reference/definitions "OnErrorDeploymentExtended"}}},
               :DeploymentOperationsListResult {:description "List of deployment operations.",
                                                :properties {:nextLink {:description "The URL to use for getting the next set of results.",
                                                                        :readOnly true,
                                                                        :type "string"},
                                                             :value {:description "An array of deployment operations.",
                                                                     :items {:reference/definitions "DeploymentOperation"},
                                                                     :type "array"}}},
               :AliasType {:description "The alias type. ",
                           :properties {:name {:description "The alias name.",
                                               :type "string"},
                                        :paths {:description "The paths for an alias.",
                                                :items {:reference/definitions "AliasPathType"},
                                                :type "array"}}},
               :Plan {:description "Plan for the resource.",
                      :properties {:name {:description "The plan ID.",
                                          :type "string"},
                                   :product {:description "The offer ID.",
                                             :type "string"},
                                   :promotionCode {:description "The promotion code.",
                                                   :type "string"},
                                   :publisher {:description "The publisher ID.",
                                               :type "string"},
                                   :version {:description "The plan's version.",
                                             :type "string"}}},
               :GenericResourceFilter {:description "Resource filter.",
                                       :properties {:resourceType {:description "The resource type.",
                                                                   :type "string"},
                                                    :tagname {:description "The tag name.",
                                                              :type "string"},
                                                    :tagvalue {:description "The tag value.",
                                                               :type "string"}}},
               :CloudError {:description "An error response for a resource management request.",
                            :properties {:error {:description "The resource management error response.",
                                                 :properties {:additionalInfo {:description "The error additional info.",
                                                                               :items {:description "The resource management error additional info.",
                                                                                       :properties {:info {:description "The additional info.",
                                                                                                           :readOnly true,
                                                                                                           :type "object"},
                                                                                                    :type {:description "The additional info type.",
                                                                                                           :readOnly true,
                                                                                                           :type "string"}}},
                                                                               :readOnly true,
                                                                               :type "array"},
                                                              :code {:description "The error code.",
                                                                     :readOnly true,
                                                                     :type "string"},
                                                              :details {:description "The error details.",
                                                                        :items {:reference/definitions "ErrorResponse"},
                                                                        :readOnly true,
                                                                        :type "array"},
                                                              :message {:description "The error message.",
                                                                        :readOnly true,
                                                                        :type "string"},
                                                              :target {:description "The error target.",
                                                                       :readOnly true,
                                                                       :type "string"}}}},
                            :x-ms-external true},
               :ResourceGroupProperties {:description "The resource group properties.",
                                         :properties {:provisioningState {:description "The provisioning state. ",
                                                                          :readOnly true,
                                                                          :type "string"}}},
               :ResourceGroupFilter {:description "Resource group filter.",
                                     :properties {:tagName {:description "The tag name.",
                                                            :type "string"},
                                                  :tagValue {:description "The tag value.",
                                                             :type "string"}}},
               :TagValue {:description "Tag information.",
                          :properties {:count {:reference/definitions "TagCount"},
                                       :id {:description "The tag value ID.",
                                            :readOnly true,
                                            :type "string"},
                                       :tagValue {:description "The tag value.",
                                                  :type "string"}},
                          :x-ms-azure-resource true},
               :BasicDependency {:description "Deployment dependency information.",
                                 :properties {:id {:description "The ID of the dependency.",
                                                   :type "string"},
                                              :resourceName {:description "The dependency resource name.",
                                                             :type "string"},
                                              :resourceType {:description "The dependency resource type.",
                                                             :type "string"}}},
               :Dependency {:description "Deployment dependency information.",
                            :properties {:dependsOn {:description "The list of dependencies.",
                                                     :items {:reference/definitions "BasicDependency"},
                                                     :type "array"},
                                         :id {:description "The ID of the dependency.",
                                              :type "string"},
                                         :resourceName {:description "The dependency resource name.",
                                                        :type "string"},
                                         :resourceType {:description "The dependency resource type.",
                                                        :type "string"}}},
               :ResourceGroupListResult {:description "List of resource groups.",
                                         :properties {:nextLink {:description "The URL to use for getting the next set of results.",
                                                                 :readOnly true,
                                                                 :type "string"},
                                                      :value {:description "An array of resource groups.",
                                                              :items {:reference/definitions "ResourceGroup"},
                                                              :type "array"}}},
               :WhatIfOperationResult {:description "Result of the What-If operation. Contains a list of predicted changes and a URL link to get to the next set of results.",
                                       :properties {:error {:description "The resource management error response.",
                                                            :properties {:additionalInfo {:description "The error additional info.",
                                                                                          :items {:description "The resource management error additional info.",
                                                                                                  :properties {:info {:description "The additional info.",
                                                                                                                      :readOnly true,
                                                                                                                      :type "object"},
                                                                                                               :type {:description "The additional info type.",
                                                                                                                      :readOnly true,
                                                                                                                      :type "string"}}},
                                                                                          :readOnly true,
                                                                                          :type "array"},
                                                                         :code {:description "The error code.",
                                                                                :readOnly true,
                                                                                :type "string"},
                                                                         :details {:description "The error details.",
                                                                                   :items {:reference/definitions "ErrorResponse"},
                                                                                   :readOnly true,
                                                                                   :type "array"},
                                                                         :message {:description "The error message.",
                                                                                   :readOnly true,
                                                                                   :type "string"},
                                                                         :target {:description "The error target.",
                                                                                  :readOnly true,
                                                                                  :type "string"}}},
                                                    :properties {:reference/definitions "WhatIfOperationProperties"},
                                                    :status {:description "Status of the What-If operation.",
                                                             :type "string"}}},
               :ResourceGroupExportResult {:description "Resource group export result.",
                                           :properties {:error {:description "The resource management error response.",
                                                                :properties {:additionalInfo {:description "The error additional info.",
                                                                                              :items {:description "The resource management error additional info.",
                                                                                                      :properties {:info {:description "The additional info.",
                                                                                                                          :readOnly true,
                                                                                                                          :type "object"},
                                                                                                                   :type {:description "The additional info type.",
                                                                                                                          :readOnly true,
                                                                                                                          :type "string"}}},
                                                                                              :readOnly true,
                                                                                              :type "array"},
                                                                             :code {:description "The error code.",
                                                                                    :readOnly true,
                                                                                    :type "string"},
                                                                             :details {:description "The error details.",
                                                                                       :items {:reference/definitions "ErrorResponse"},
                                                                                       :readOnly true,
                                                                                       :type "array"},
                                                                             :message {:description "The error message.",
                                                                                       :readOnly true,
                                                                                       :type "string"},
                                                                             :target {:description "The error target.",
                                                                                      :readOnly true,
                                                                                      :type "string"}}},
                                                        :template {:description "The template content.",
                                                                   :type "object"}}},
               :DeploymentOperationProperties {:description "Deployment operation properties.",
                                               :properties {:response {:reference/definitions "HttpMessage"},
                                                            :request {:reference/definitions "HttpMessage"},
                                                            :provisioningState {:description "The state of the provisioning.",
                                                                                :readOnly true,
                                                                                :type "string"},
                                                            :targetResource {:reference/definitions "TargetResource"},
                                                            :statusMessage {:description "Operation status message.",
                                                                            :readOnly true,
                                                                            :type "object"},
                                                            :duration {:description "The duration of the operation.",
                                                                       :readOnly true,
                                                                       :type "string"},
                                                            :serviceRequestId {:description "Deployment operation service request id.",
                                                                               :readOnly true,
                                                                               :type "string"},
                                                            :timestamp {:description "The date and time of the operation.",
                                                                        :format "date-time",
                                                                        :readOnly true,
                                                                        :type "string"},
                                                            :statusCode {:description "Operation status code.",
                                                                         :readOnly true,
                                                                         :type "string"}}},
               :AliasPathType {:description "The type of the paths for alias. ",
                               :properties {:apiVersions {:description "The API versions.",
                                                          :items {:type "string"},
                                                          :type "array"},
                                            :path {:description "The path of an alias.",
                                                   :type "string"}}},
               :WhatIfOperationProperties {:description "Deployment operation properties.",
                                           :properties {:changes {:description "List of resource changes predicted by What-If operation.",
                                                                  :items {:reference/definitions "WhatIfChange"},
                                                                  :type "array"}}},
               :ParametersLink {:description "Entity representing the reference to the deployment parameters.",
                                :properties {:contentVersion {:description "If included, must match the ContentVersion in the template.",
                                                              :type "string"},
                                             :uri {:description "The URI of the parameters file.",
                                                   :type "string"}},
                                :required ["uri"]},
               :ProviderListResult {:description "List of resource providers.",
                                    :properties {:nextLink {:description "The URL to use for getting the next set of results.",
                                                            :readOnly true,
                                                            :type "string"},
                                                 :value {:description "An array of resource providers.",
                                                         :items {:reference/definitions "Provider"},
                                                         :type "array"}}},
               :ResourceListResult {:description "List of resource groups.",
                                    :properties {:nextLink {:description "The URL to use for getting the next set of results.",
                                                            :readOnly true,
                                                            :type "string"},
                                                 :value {:description "An array of resources.",
                                                         :items {:reference/definitions "GenericResource"},
                                                         :type "array"}}},
               :ResourceProviderOperationDisplayProperties {:description "Resource provider operation's display properties.",
                                                            :properties {:description {:description "Operation description.",
                                                                                       :type "string"},
                                                                         :operation {:description "Resource provider operation.",
                                                                                     :type "string"},
                                                                         :provider {:description "Operation provider.",
                                                                                    :type "string"},
                                                                         :publisher {:description "Operation description.",
                                                                                     :type "string"},
                                                                         :resource {:description "Operation resource.",
                                                                                    :type "string"}}},
               :DeploymentWhatIfProperties {:allOf [{:reference/definitions "DeploymentProperties"}],
                                            :description "Deployment What-if properties.",
                                            :properties {:whatIfSettings {:reference/definitions "DeploymentWhatIfSettings"}}},
               :WhatIfChange {:description "Information about a single resource change predicted by What-If operation.",
                              :properties {:after {:description "The predicted snapshot of the resource after the deployment is executed.",
                                                   :type "object"},
                                           :before {:description "The snapshot of the resource before the deployment is executed.",
                                                    :type "object"},
                                           :changeType {:description "Type of change that will be made to the resource when the deployment is executed.",
                                                        :enum ["Create"
                                                               "Delete"
                                                               "Ignore"
                                                               "Deploy"
                                                               "NoChange"
                                                               "Modify"],
                                                        :type "string",
                                                        :x-ms-enum {:modelAsString false,
                                                                    :name "ChangeType",
                                                                    :values [{:description "The resource does not exist in the current state but is present in the desired state. The resource will be created when the deployment is executed.",
                                                                              :value "Create"}
                                                                             {:description "The resource exists in the current state and is missing from the desired state. The resource will be deleted when the deployment is executed.",
                                                                              :value "Delete"}
                                                                             {:description "The resource exists in the current state and is missing from the desired state. The resource will not be deployed or modified when the deployment is executed.",
                                                                              :value "Ignore"}
                                                                             {:description "The resource exists in the current state and the desired state and will be redeployed when the deployment is executed. The properties of the resource may or may not change.",
                                                                              :value "Deploy"}
                                                                             {:description "The resource exists in the current state and the desired state and will be redeployed when the deployment is executed. The properties of the resource will not change.",
                                                                              :value "NoChange"}
                                                                             {:description "The resource exists in the current state and the desired state and will be redeployed when the deployment is executed. The properties of the resource will change.",
                                                                              :value "Modify"}]}},
                                           :delta {:description "The predicted changes to resource properties.",
                                                   :items {:reference/definitions "WhatIfPropertyChange"},
                                                   :type "array"},
                                           :resourceId {:description "Resource ID",
                                                        :type "string"}},
                              :required ["resourceId" "changeType"]},
               :TargetResource {:description "Target resource.",
                                :properties {:id {:description "The ID of the resource.",
                                                  :type "string"},
                                             :resourceName {:description "The name of the resource.",
                                                            :type "string"},
                                             :resourceType {:description "The type of the resource.",
                                                            :type "string"}}},
               :DeploymentExportResult {:description "The deployment export result. ",
                                        :properties {:template {:description "The template content.",
                                                                :type "object"}}},
               :ResourcesMoveInfo {:description "Parameters of move resources.",
                                   :properties {:resources {:description "The IDs of the resources.",
                                                            :items {:type "string"},
                                                            :type "array"},
                                                :targetResourceGroup {:description "The target resource group.",
                                                                      :type "string"}}},
               :ProviderResourceType {:description "Resource type managed by the resource provider.",
                                      :properties {:aliases {:description "The aliases that are supported by this resource type.",
                                                             :items {:reference/definitions "AliasType"},
                                                             :type "array"},
                                                   :apiVersions {:description "The API version.",
                                                                 :items {:type "string"},
                                                                 :type "array"},
                                                   :capabilities {:description "The additional capabilities offered by this resource type.",
                                                                  :type "string"},
                                                   :locations {:description "The collection of locations where this resource type can be created.",
                                                               :items {:type "string"},
                                                               :type "array"},
                                                   :properties {:additionalProperties {:description "The additional properties. ",
                                                                                       :type "string"},
                                                                :description "The properties.",
                                                                :type "object"},
                                                   :resourceType {:description "The resource type.",
                                                                  :type "string"}}},
               :Resource {:description "Specified resource.",
                          :properties {:id {:description "Resource ID",
                                            :readOnly true,
                                            :type "string"},
                                       :location {:description "Resource location",
                                                  :type "string"},
                                       :name {:description "Resource name",
                                              :readOnly true,
                                              :type "string"},
                                       :tags {:additionalProperties {:type "string"},
                                              :description "Resource tags",
                                              :type "object"},
                                       :type {:description "Resource type",
                                              :readOnly true,
                                              :type "string"}},
                          :x-ms-azure-resource true},
               :ResourceGroupPatchable {:description "Resource group information.",
                                        :properties {:managedBy {:description "The ID of the resource that manages this resource group.",
                                                                 :type "string"},
                                                     :name {:description "The name of the resource group.",
                                                            :type "string"},
                                                     :properties {:reference/definitions "ResourceGroupProperties"},
                                                     :tags {:additionalProperties {:description "The additional properties. ",
                                                                                   :type "string"},
                                                            :description "The tags attached to the resource group.",
                                                            :type "object"}}},
               :DeploymentListResult {:description "List of deployments.",
                                      :properties {:nextLink {:description "The URL to use for getting the next set of results.",
                                                              :readOnly true,
                                                              :type "string"},
                                                   :value {:description "An array of deployments.",
                                                           :items {:reference/definitions "DeploymentExtended"},
                                                           :type "array"}}},
               :Deployment {:description "Deployment operation parameters.",
                            :properties {:location {:description "The location to store the deployment data.",
                                                    :type "string"},
                                         :properties {:reference/definitions "DeploymentProperties"}},
                            :required ["properties"]},
               :ErrorResponse {},
               :Sku {:description "SKU for the resource.",
                     :properties {:capacity {:description "The SKU capacity.",
                                             :format "int32",
                                             :type "integer"},
                                  :family {:description "The SKU family.",
                                           :type "string"},
                                  :model {:description "The SKU model.",
                                          :type "string"},
                                  :name {:description "The SKU name.",
                                         :type "string"},
                                  :size {:description "The SKU size.",
                                         :type "string"},
                                  :tier {:description "The SKU tier.",
                                         :type "string"}}},
               :Provider {:description "Resource provider information.",
                          :properties {:id {:description "The provider ID.",
                                            :readOnly true,
                                            :type "string"},
                                       :namespace {:description "The namespace of the resource provider.",
                                                   :type "string"},
                                       :registrationPolicy {:description "The registration policy of the resource provider.",
                                                            :readOnly true,
                                                            :type "string"},
                                       :registrationState {:description "The registration state of the resource provider.",
                                                           :readOnly true,
                                                           :type "string"},
                                       :resourceTypes {:description "The collection of provider resource types.",
                                                       :items {:reference/definitions "ProviderResourceType"},
                                                       :readOnly true,
                                                       :type "array"}}},
               :DeploymentWhatIf {:description "Deployment What-if operation parameters.",
                                  :properties {:location {:description "The location to store the deployment data.",
                                                          :type "string"},
                                               :properties {:reference/definitions "DeploymentWhatIfProperties"}},
                                  :required ["properties"]},
               :TagsListResult {:description "List of subscription tags.",
                                :properties {:nextLink {:description "The URL to use for getting the next set of results.",
                                                        :readOnly true,
                                                        :type "string"},
                                             :value {:description "An array of tags.",
                                                     :items {:reference/definitions "TagDetails"},
                                                     :type "array"}}},
               :TemplateLink {:description "Entity representing the reference to the template.",
                              :properties {:contentVersion {:description "If included, must match the ContentVersion in the template.",
                                                            :type "string"},
                                           :uri {:description "The URI of the template to deploy.",
                                                 :type "string"}},
                              :required ["uri"]},
               :GenericResource {:allOf [{:reference/definitions "Resource"}],
                                 :description "Resource information.",
                                 :properties {:identity {:reference/definitions "Identity"},
                                              :kind {:description "The kind of the resource.",
                                                     :pattern "^[-\\w\\._,\\(\\)]+$",
                                                     :type "string"},
                                              :managedBy {:description "ID of the resource that manages this resource.",
                                                          :type "string"},
                                              :plan {:reference/definitions "Plan"},
                                              :properties {:description "The resource properties.",
                                                           :type "object"},
                                              :sku {:reference/definitions "Sku"}}},
               :TagCount {:description "Tag count.",
                          :properties {:type {:description "Type of count.",
                                              :type "string"},
                                       :value {:description "Value of count.",
                                               :type "integer"}}},
               :DeploymentOperation {:description "Deployment operation information.",
                                     :properties {:id {:description "Full deployment operation ID.",
                                                       :readOnly true,
                                                       :type "string"},
                                                  :operationId {:description "Deployment operation ID.",
                                                                :readOnly true,
                                                                :type "string"},
                                                  :properties {:reference/definitions "DeploymentOperationProperties"}}},
               :DeploymentWhatIfSettings {:description "Deployment What-If operation settings.",
                                          :properties {:resultFormat {:description "The format of the What-If results",
                                                                      :enum ["ResourceIdOnly"
                                                                             "FullResourcePayloads"],
                                                                      :type "string",
                                                                      :x-ms-enum {:modelAsString false,
                                                                                  :name "WhatIfResultFormat"}}}},
               :TagsPatchResource {:description "Wrapper resource for tags patch API request only.",
                                   :properties {:operation {:description "The operation type for the patch API.",
                                                            :enum ["Replace"
                                                                   "Merge"
                                                                   "Delete"],
                                                            :type "string"},
                                                :properties {:reference/definitions "Tags"}},
                                   :type "object"}}}
  
  )
