# ardoq-clojure-client

Clojure wrapper for the [Ardoq](http://ardoq.com) REST-api.

## Install

To use the wrapper one has to set it up. Given that the file sits in src.ardoq you can import it in the following ways. 

```
(:require [ardoq.client :as client])
;;OR
(use 'ardoq.client)
```

The next steps are only needed if one wants to create a client outside the actual application. If one already has workspaces and organizations these can be skipped.

To start, one will need a client. The client is created as follows. If you are in the namespace, skip the client/ part of commands

```
;;Create a new client
(def client (client/client {:url "Ardoq server url"
                           :token "Your unique id of the client
                           :org "Name of the client/organization}))
```

This creates a local variable called client and adds it to the database. It doesn't however have any workspaces.

The workspace has to be set up with a componentModel. As this is a basic intro and not a complete setup we will do so with an empty model. If one has a model ready it can easily be used instead with something like the following 

```
(def model 
     (-> (client/map->Model (parse-string (slurp (io/resource "model.json")) true))
         (client/create client)))  
```
If you don't have a model however you can use the default ones. The default ones are JavaDoc, .Net, Process Flow, Application Service, Buisness Process, Chapter Model, Enterprise Model, Enterprise Architecture, Infrastructure and Requirements.

You can also use this if you already have a model of your own in your system.

```
;;Using JavaDoc here, but can switch with any of the models you like.
(defn model (client/find-or-create-model client "JavaDoc")) 
```

With this we can create a workspace

```
(def workspace 
    (-> (client/->Workspace "Name" "Description" (:_id model))
    (client/create client))
```

This should then have us up and running with a workspace, a model and a client

## Usage

The system itself is based on the idea of items being resources, which we refer to as ArdoqResources. These can possibly be Workspace, Component, Model, Reference, Field and Tag. While they are part of the same super class, the ArdoqResource, they all have slight variations on their signature.

An ArdoqResource is then used by all the basic client functions. These include create, update, find-by-id, find-all and delete. 

All these functions will require a resource of some type and a client to work.

Doing for example

```
(client/create resource client)
```

would create that resource within that client. All the other function calls work exactly the same way, they all just take a resource and then the client.

### Workspace 

The workspace is where we contain all the data. A single workspace can therefor contain components, references, fields ands tags. They will require a model to be based on.

```
;;As stated, workspace requires an model, which is identified by the id it has
(def workspace (client/->Workspace name description ModelId))
;;You would then want to create the workspace as well with 
(client/create workspace client)
```

### Compnent

### Model

A model is what all of the workspaces are based on. They serve as the outline for how the workspace is setup. For example a model can be based on Swagger the the contents of the workspace will then reflect that.

A model is created as such

```
(c/->Model name description)
```

However, the model requires a number of details to be an valid model. So you would either want to have the model from one of the defaults or you can have it from your own file.

If the model is either already part of the organization or a default model you can do

```
(client/find-or-create-model client modelname)
```

This will then either create a model in the organization based on defaults or retrieve one that currently excists in the organization.

### Reference

### Field

### Tag

## License

Copyright © 2015 Ardoq

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.