/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.route;

import com.appsflyer.donkey.server.route.HandlerMode;
import com.appsflyer.donkey.server.route.PathDefinition;
import com.appsflyer.donkey.server.route.RouteCreator;
import com.appsflyer.donkey.server.route.RouteDefinition;
import com.appsflyer.donkey.server.route.RouteList;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.Collection;
import java.util.Set;

public abstract class AbstractRouteCreator
implements RouteCreator {
    private static final Collection<HttpMethod> METHODS_WITH_BODY = Set.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private final Router router;
    private final Collection<RouteDefinition> routeDefinitions;

    private static boolean hasBody(Route route) {
        Set methods = route.methods();
        if (methods == null) {
            return true;
        }
        return route.methods().stream().anyMatch(METHODS_WITH_BODY::contains);
    }

    protected AbstractRouteCreator(Router router, RouteList routeList) {
        this.router = router;
        this.routeDefinitions = routeList.routes();
    }

    @Override
    public Router addRoutes() {
        this.routeDefinitions.forEach(rd -> this.buildRoute(this.router.route(), (RouteDefinition)rd));
        return this.router;
    }

    protected abstract void buildRoute(Route var1, RouteDefinition var2);

    @Override
    public void setPath(Route route, RouteDefinition rd) {
        if (rd.path() != null) {
            if (rd.path().matchType() == PathDefinition.MatchType.REGEX) {
                route.pathRegex(rd.path().value());
            } else {
                route.path(rd.path().value());
            }
        }
    }

    @Override
    public void setMethods(Route route, RouteDefinition rd) {
        rd.methods().forEach(arg_0 -> ((Route)route).method(arg_0));
    }

    @Override
    public void setConsumes(Route route, RouteDefinition rd) {
        rd.consumes().forEach(arg_0 -> ((Route)route).consumes(arg_0));
    }

    @Override
    public void setProduces(Route route, RouteDefinition rd) {
        rd.produces().forEach(arg_0 -> ((Route)route).produces(arg_0));
    }

    @Override
    public void addBodyHandler(Route route) {
        if (AbstractRouteCreator.hasBody(route)) {
            route.handler((Handler)BodyHandler.create());
        }
    }

    @Override
    public void addHandler(Route route, Handler<RoutingContext> handler, HandlerMode handlerMode) {
        if (handlerMode == HandlerMode.BLOCKING) {
            route.blockingHandler(handler, false);
        } else {
            route.handler(handler);
        }
    }
}

