/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.ring.middleware;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.RT;
import com.appsflyer.donkey.server.ring.handler.RingRequestField;
import com.appsflyer.donkey.server.ring.middleware.RingMiddleware;
import com.appsflyer.donkey.util.TypeConverter;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class QueryParamsParser
implements RingMiddleware {
    private static final Keyword QUERY_PARAMS = Keyword.intern((String)"query-params");
    private final Function<String, ?> mappingFunc;

    public static RingMiddleware create() {
        return new QueryParamsParser(Options.DEFAULT);
    }

    public static RingMiddleware create(Options opts) {
        return new QueryParamsParser(opts);
    }

    private QueryParamsParser(Options opts) {
        this.mappingFunc = opts.keywordizeKeys ? Keyword::intern : Function.identity();
    }

    @Override
    public IPersistentMap handle(IPersistentMap request) {
        Objects.requireNonNull(request, "Request map cannot be null");
        if (request.containsKey((Object)QUERY_PARAMS)) {
            return request;
        }
        String queryString = (String)request.valAt((Object)RingRequestField.QUERY_STRING.keyword(), null);
        if (queryString == null || queryString.isBlank()) {
            return request;
        }
        Map decodedParams = new QueryStringDecoder(queryString, false).parameters();
        Object[] values = new Object[decodedParams.size() * 2];
        int valueIndex = 0;
        for (Map.Entry entry : decodedParams.entrySet()) {
            values[valueIndex] = this.mappingFunc.apply((String)entry.getKey());
            List val = (List)entry.getValue();
            values[valueIndex + 1] = val.size() > 1 ? TypeConverter.toVector(val) : val.get(0);
            valueIndex += 2;
        }
        return request.assoc((Object)QUERY_PARAMS, (Object)RT.mapUniqueKeys((Object[])values));
    }

    public static class Options {
        private static final Options DEFAULT = new Options();
        private boolean keywordizeKeys;

        public Options keywordizeKeys(boolean keywordizeKeys) {
            this.keywordizeKeys = keywordizeKeys;
            return this;
        }
    }
}

