/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.client.ring;

import clojure.lang.IPersistentMap;
import com.appsflyer.donkey.client.ring.RingResponseField;
import com.appsflyer.donkey.util.TypeConverter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpResponse;

public final class RingResponseAdapter
implements Handler<AsyncResult<HttpResponse<Buffer>>> {
    private final Promise<IPersistentMap> promise;

    public static RingResponseAdapter create(Promise<IPersistentMap> promise) {
        return new RingResponseAdapter(promise);
    }

    private RingResponseAdapter(Promise<IPersistentMap> promise) {
        this.promise = promise;
    }

    public void handle(AsyncResult<HttpResponse<Buffer>> event) {
        if (event.succeeded()) {
            HttpResponse res = (HttpResponse)event.result();
            RingResponseField[] fields = RingResponseField.values();
            Object[] values = new Object[fields.length * 2];
            int valueIndex = 0;
            for (int i = 0; i < fields.length; ++i) {
                RingResponseField field = fields[i];
                Object v = field.from(res);
                if (v == null) continue;
                values[valueIndex] = field.keyword();
                values[valueIndex + 1] = v;
                valueIndex += 2;
            }
            if (valueIndex == values.length) {
                this.promise.complete((Object)TypeConverter.toPersistentMap(values));
            } else {
                Object[] copy = new Object[valueIndex];
                System.arraycopy(values, 0, copy, 0, valueIndex);
                this.promise.complete((Object)TypeConverter.toPersistentMap(copy));
            }
        } else {
            this.promise.fail(event.cause());
        }
    }
}

