/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.ring.handler;

import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import com.appsflyer.donkey.server.ring.handler.RingHandler;
import com.appsflyer.donkey.server.ring.handler.RingResponseField;
import com.appsflyer.donkey.util.TypeConverter;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RingResponseAdapter
implements RingHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)RingResponseAdapter.class.getName());

    public static RingHandler create() {
        return new RingResponseAdapter();
    }

    private RingResponseAdapter() {
    }

    public void handle(RoutingContext ctx) {
        IPersistentMap ringResponse = (IPersistentMap)ctx.get("RING_HANDLER_RESULT");
        if (ringResponse == null) {
            ctx.response().end();
            return;
        }
        HttpServerResponse serverResponse = ctx.response();
        this.addHeaders(serverResponse, ringResponse);
        this.setStatus(serverResponse, ringResponse);
        this.sendResponse(serverResponse, ringResponse);
    }

    private void addHeaders(HttpServerResponse serverResponse, IPersistentMap ringResponse) {
        IPersistentMap headers = (IPersistentMap)RingResponseField.HEADERS.from(ringResponse);
        if (headers != null) {
            for (Object obj : headers) {
                IMapEntry pair = (IMapEntry)obj;
                serverResponse.putHeader((CharSequence)pair.getKey(), (CharSequence)pair.getValue());
            }
        }
    }

    private void setStatus(HttpServerResponse serverResponse, IPersistentMap ringResponse) {
        serverResponse.setStatusCode(((Integer)RingResponseField.STATUS.from(ringResponse)).intValue());
    }

    private void sendResponse(HttpServerResponse serverResponse, IPersistentMap ringResponse) {
        Object body = RingResponseField.BODY.from(ringResponse);
        if (body instanceof File) {
            this.sendFile(serverResponse, (File)body);
        } else {
            serverResponse.end(TypeConverter.toBuffer(body));
        }
    }

    private void sendFile(HttpServerResponse serverResponse, File file) {
        try {
            serverResponse.sendFile(file.getCanonicalPath(), 0L, file.length()).onFailure(ex -> {
                this.logFileFailure(file, (Throwable)ex);
                serverResponse.setStatusCode(500).end();
            });
        }
        catch (IOException ex2) {
            this.logFileFailure(file, ex2);
            serverResponse.setStatusCode(500).end();
        }
    }

    private void logFileFailure(File file, Throwable ex) {
        logger.error("Failed to send file '{}': {}", (Object)file.getPath(), (Object)ex.getMessage());
    }
}

