/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server;

import com.appsflyer.donkey.server.handler.ErrorHandler;
import com.appsflyer.donkey.server.route.RouteCreatorFactory;
import com.appsflyer.donkey.server.route.RouteList;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import java.util.Objects;

public final class ServerConfig {
    private Vertx vertx;
    private HttpServerOptions serverOptions;
    private RouteCreatorFactory routeCreatorFactory;
    private RouteList routeList;
    private ErrorHandler<?> errorHandler;
    private int instances;
    private boolean addDateHeader;
    private boolean addContentTypeHeader;
    private boolean addServerHeader;

    public static ServerConfigBuilder builder() {
        return new ServerConfigBuilder();
    }

    private ServerConfig() {
    }

    public Vertx vertx() {
        return this.vertx;
    }

    HttpServerOptions serverOptions() {
        return this.serverOptions;
    }

    public RouteCreatorFactory routeCreatorFactory() {
        return this.routeCreatorFactory;
    }

    public RouteList routeList() {
        return this.routeList;
    }

    ErrorHandler<?> errorHandler() {
        return this.errorHandler;
    }

    public int instances() {
        return this.instances;
    }

    boolean addDateHeader() {
        return this.addDateHeader;
    }

    boolean addContentTypeHeader() {
        return this.addContentTypeHeader;
    }

    boolean addServerHeader() {
        return this.addServerHeader;
    }

    public static final class ServerConfigBuilder {
        private ServerConfig instance = new ServerConfig();

        public static ServerConfigBuilder create() {
            return new ServerConfigBuilder();
        }

        private ServerConfigBuilder() {
        }

        public ServerConfigBuilder vertx(Vertx vertx) {
            this.instance.vertx = vertx;
            return this;
        }

        public ServerConfigBuilder serverOptions(HttpServerOptions serverOptions) {
            this.instance.serverOptions = serverOptions;
            return this;
        }

        public ServerConfigBuilder routeCreatorFactory(RouteCreatorFactory routeCreatorFactory) {
            this.instance.routeCreatorFactory = routeCreatorFactory;
            return this;
        }

        public ServerConfigBuilder routeList(RouteList routeList) {
            this.instance.routeList = routeList;
            return this;
        }

        public ServerConfigBuilder errorHandler(ErrorHandler<?> errorHandler) {
            this.instance.errorHandler = errorHandler;
            return this;
        }

        public ServerConfigBuilder instances(int val) {
            this.instance.instances = val;
            return this;
        }

        public ServerConfigBuilder addDateHeader(boolean val) {
            this.instance.addDateHeader = val;
            return this;
        }

        public ServerConfigBuilder addContentTypeHeader(boolean val) {
            this.instance.addContentTypeHeader = val;
            return this;
        }

        public ServerConfigBuilder addServerHeader(boolean val) {
            this.instance.addServerHeader = val;
            return this;
        }

        public ServerConfig build() {
            this.assertValidState();
            ServerConfig res = this.instance;
            this.instance = null;
            return res;
        }

        private void assertValidState() {
            Objects.requireNonNull(this.instance.vertx, "Vertx instance is missing");
            Objects.requireNonNull(this.instance.serverOptions, "Server options is missing");
            Objects.requireNonNull(this.instance.routeCreatorFactory, "Route creator factory is missing");
            Objects.requireNonNull(this.instance.routeList, "Route definition list is missing");
            if (this.instance.instances < 1) {
                throw new IllegalArgumentException("Number of instances must be greater than 0");
            }
        }
    }
}

