/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.route;

import com.appsflyer.donkey.server.route.RouteDefinition;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class RouteList {
    private final Deque<RouteDefinition> routes;

    public static RouteList from(RouteDefinition route) {
        return new RouteList(List.of(route));
    }

    public static RouteList from(RouteDefinition[] routes) {
        return new RouteList(List.of(routes));
    }

    public static RouteList from(List<RouteDefinition> routes) {
        return new RouteList(routes);
    }

    private RouteList(List<RouteDefinition> routes) {
        Objects.requireNonNull(routes, "Routes cannot be null");
        if (routes.isEmpty()) {
            throw new IllegalArgumentException("Routes cannot be empty");
        }
        this.routes = new LinkedList<RouteDefinition>(routes);
    }

    public List<RouteDefinition> routes() {
        return List.copyOf(this.routes);
    }

    public RouteList addFirst(RouteDefinition rd) {
        Objects.requireNonNull(rd, "Route definition cannot be null");
        this.routes.addFirst(rd);
        return this;
    }

    public RouteList addLast(RouteDefinition rd) {
        Objects.requireNonNull(rd, "Route definition cannot be null");
        this.routes.addLast(rd);
        return this;
    }

    public RouteList addAll(RouteList other) {
        if (other == null) {
            return this;
        }
        this.routes.addAll(other.routes);
        return this;
    }
}

