/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.ring.middleware;

import clojure.lang.IPersistentMap;
import com.appsflyer.donkey.server.exception.DeserializationException;
import com.appsflyer.donkey.server.ring.handler.RingRequestField;
import com.appsflyer.donkey.server.ring.middleware.RingMiddleware;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;

public final class JsonBodyDeserializer
implements RingMiddleware {
    private final ObjectMapper mapper;

    public static RingMiddleware create(ObjectMapper mapper) {
        return new JsonBodyDeserializer(mapper);
    }

    private JsonBodyDeserializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public IPersistentMap handle(IPersistentMap request) {
        Objects.requireNonNull(request, "Request map cannot be null");
        byte[] body = (byte[])request.valAt((Object)RingRequestField.BODY.keyword(), null);
        if (body == null) {
            return request;
        }
        try {
            Object entity = this.mapper.readValue(body, Object.class);
            return request.assoc((Object)RingRequestField.BODY.keyword(), entity);
        }
        catch (IOException e) {
            throw new DeserializationException(e.getMessage(), e);
        }
    }
}

