/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.ring.handler;

import clojure.lang.Keyword;
import io.vertx.core.http.HttpMethod;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class HttpMethodMapping {
    private static final Map<HttpMethod, Keyword> enumToKeyword = new HashMap<HttpMethod, Keyword>();
    private static final Map<Keyword, HttpMethod> keywordToEnum = new HashMap<Keyword, HttpMethod>();

    private HttpMethodMapping() {
    }

    public static Keyword get(HttpMethod method) {
        return enumToKeyword.get(method);
    }

    public static HttpMethod get(Keyword keyword) {
        return keywordToEnum.get(keyword);
    }

    static {
        for (HttpMethod method : HttpMethod.values()) {
            Keyword keyword = Keyword.intern((String)method.name().toLowerCase(Locale.ENGLISH));
            enumToKeyword.put(method, keyword);
            keywordToEnum.put(keyword, method);
        }
    }
}

