/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.util;

import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import io.vertx.ext.web.multipart.MultipartForm;
import java.util.Objects;

public final class MultipartFormConverter {
    private MultipartFormConverter() {
    }

    public static MultipartForm from(IPersistentMap map) {
        Objects.requireNonNull(map, "Cannot convert a null map to MultipartForm");
        MultipartForm res = MultipartForm.create();
        for (Object obj : map) {
            IMapEntry entry = (IMapEntry)obj;
            Object val = entry.val();
            Objects.requireNonNull(val, "Form attribute value cannot be null");
            if (val instanceof String) {
                res.attribute((String)entry.key(), (String)val);
                continue;
            }
            MultipartFormConverter.addFile(res, (String)entry.key(), (IPersistentMap)val);
        }
        return res;
    }

    private static void addFile(MultipartForm form, String key, IPersistentMap fileOpts) {
        String filename = (String)fileOpts.valAt((Object)"filename");
        String pathname = (String)fileOpts.valAt((Object)"pathname");
        String mediaType = (String)fileOpts.valAt((Object)"media-type");
        String uploadAs = (String)fileOpts.valAt((Object)"upload-as", (Object)"");
        if ("text".equals(uploadAs)) {
            form.textFileUpload(key, filename, pathname, mediaType);
        } else {
            form.binaryFileUpload(key, filename, pathname, mediaType);
        }
    }
}

