/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server;

import com.appsflyer.donkey.server.ServerConfig;
import com.appsflyer.donkey.server.router.RouterFactoryImpl;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.ext.web.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerVerticle
extends AbstractVerticle {
    private static final Logger logger = LoggerFactory.getLogger((String)ServerVerticle.class.getName());
    private final ServerConfig config;

    ServerVerticle(ServerConfig config) {
        this.config = config;
    }

    public void start(Promise<Void> promise) {
        this.vertx.createHttpServer(this.config.serverOptions()).requestHandler((Handler)this.createRouter()).listen(res -> {
            if (res.failed()) {
                logger.error(res.cause().getMessage(), res.cause());
                promise.fail(res.cause());
            } else {
                promise.complete();
            }
        });
    }

    private Router createRouter() {
        return RouterFactoryImpl.create(this.vertx, this.config.routeList()).withRouteCreator(this.config.routeCreatorFactory());
    }
}

