/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.client.ring;

import clojure.lang.IPersistentMap;
import com.appsflyer.donkey.client.ClientConfig;
import com.appsflyer.donkey.client.ring.RequestFactory;
import com.appsflyer.donkey.client.ring.RingClient;
import com.appsflyer.donkey.client.ring.RingResponseAdapter;
import com.appsflyer.donkey.util.TypeConverter;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.multipart.MultipartForm;

public class RingClientImpl
implements RingClient {
    private final WebClient client;
    private final RequestFactory requestFactory;

    RingClientImpl(ClientConfig config) {
        this.client = WebClient.create((Vertx)config.vertx(), (WebClientOptions)config.clientOptions());
        this.requestFactory = new RequestFactory(this.client);
    }

    @Override
    public HttpRequest<Buffer> request(IPersistentMap opts) {
        return this.requestFactory.create(opts);
    }

    @Override
    public Future<IPersistentMap> send(HttpRequest<Buffer> request) {
        Promise promise = Promise.promise();
        request.send((Handler)new RingResponseAdapter((Promise<IPersistentMap>)promise));
        return promise.future();
    }

    @Override
    public Future<IPersistentMap> send(HttpRequest<Buffer> request, Object body) {
        Buffer buffer;
        try {
            buffer = TypeConverter.toBuffer(body);
        }
        catch (Throwable ex) {
            Promise promise = Promise.promise();
            promise.fail(ex);
            return promise.future();
        }
        return this.send(request, buffer);
    }

    @Override
    public Future<IPersistentMap> send(HttpRequest<Buffer> request, Buffer body) {
        Promise promise = Promise.promise();
        request.sendBuffer(body, (Handler)new RingResponseAdapter((Promise<IPersistentMap>)promise));
        return promise.future();
    }

    @Override
    public Future<IPersistentMap> sendForm(HttpRequest<Buffer> request, IPersistentMap body) {
        return this.sendForm(request, TypeConverter.toMultiMap(body));
    }

    @Override
    public Future<IPersistentMap> sendForm(HttpRequest<Buffer> request, MultiMap body) {
        Promise promise = Promise.promise();
        request.sendForm(body, (Handler)new RingResponseAdapter((Promise<IPersistentMap>)promise));
        return promise.future();
    }

    @Override
    public Future<IPersistentMap> sendMultiPartForm(HttpRequest<Buffer> request, IPersistentMap body) {
        return this.sendMultiPartForm(request, TypeConverter.toMultipartForm(body));
    }

    @Override
    public Future<IPersistentMap> sendMultiPartForm(HttpRequest<Buffer> request, MultipartForm body) {
        Promise promise = Promise.promise();
        request.sendMultipartForm(body, (Handler)new RingResponseAdapter((Promise<IPersistentMap>)promise));
        return promise.future();
    }

    @Override
    public void shutdown() {
        this.client.close();
    }
}

