/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey;

import clojure.lang.ExceptionInfo;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.RT;
import com.appsflyer.donkey.CompletableResult;
import io.vertx.core.Future;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public final class FutureResult<T>
implements CompletableResult<T>,
IDeref {
    private final CompletableFuture<Object> impl;

    public static <V> FutureResult<V> create() {
        return new FutureResult(CompletableFuture.completedFuture(null));
    }

    public static <V> FutureResult<V> create(V value) {
        return new FutureResult(CompletableFuture.completedFuture(value));
    }

    public static <V> FutureResult<V> create(CompletableFuture<Object> future) {
        return new FutureResult(future);
    }

    public static <V> FutureResult<V> create(Future<V> vertxFuture) {
        CompletableFuture<Object> impl = new CompletableFuture<Object>();
        vertxFuture.onComplete(event -> {
            if (event.succeeded()) {
                impl.complete(event.result());
            } else {
                impl.completeExceptionally(event.cause());
            }
        });
        return new FutureResult(impl);
    }

    private FutureResult(CompletableFuture<Object> impl) {
        this.impl = impl;
    }

    @Override
    public FutureResult<T> onComplete(IFn handler) {
        return new FutureResult<T>((CompletableFuture<Object>)this.impl.handle((v, t) -> {
            Throwable ex = t;
            if (t != null) {
                ex = t.getCause() == null ? t : t.getCause();
            }
            return handler.invoke(v, (Object)ex);
        }));
    }

    @Override
    public FutureResult<T> onSuccess(IFn handler) {
        return new FutureResult<T>((CompletableFuture<Object>)this.impl.thenApply(arg_0 -> ((IFn)handler).invoke(arg_0)));
    }

    @Override
    public FutureResult<T> onFail(IFn handler) {
        return new FutureResult<T>((CompletableFuture<Object>)this.impl.handle((v, t) -> {
            if (t == null) {
                return v;
            }
            return handler.invoke((Object)(t.getCause() == null ? t : t.getCause()));
        }));
    }

    public Object deref() {
        try {
            return this.impl.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new ExceptionInfo(e.getMessage(), RT.map((Object[])new Object[0]), (Throwable)e);
        }
        catch (ExecutionException e) {
            return new ExceptionInfo(e.getCause().getMessage(), RT.map((Object[])new Object[0]), e.getCause());
        }
    }
}

