/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server;

import com.appsflyer.donkey.server.Server;
import com.appsflyer.donkey.server.ServerConfig;
import com.appsflyer.donkey.server.ServerVerticle;
import com.appsflyer.donkey.server.exception.ServerInitializationException;
import com.appsflyer.donkey.server.exception.ServerShutdownException;
import com.appsflyer.donkey.server.handler.DateHeaderHandler;
import com.appsflyer.donkey.server.handler.ServerHeaderHandler;
import com.appsflyer.donkey.server.route.RouteDefinition;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.handler.ResponseContentTypeHandler;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ServerImpl
implements Server {
    private static final Logger logger = LoggerFactory.getLogger((String)ServerImpl.class.getName());
    private static final int TIMEOUT_SECONDS = 10;
    private final ServerConfig config;

    ServerImpl(ServerConfig config) {
        config.vertx().exceptionHandler(ex -> logger.error((Object)ex.getMessage(), ex.getCause()));
        this.config = config;
        this.addOptionalHandlers();
    }

    private void addOptionalHandlers() {
        ArrayList<Object> handlers = new ArrayList<Object>();
        if (this.config.debug()) {
            handlers.add(LoggerHandler.create());
        }
        if (this.config.addDateHeader()) {
            handlers.add(DateHeaderHandler.create(this.config.vertx()));
        }
        if (this.config.addContentTypeHeader()) {
            handlers.add(ResponseContentTypeHandler.create());
        }
        if (this.config.addServerHeader()) {
            handlers.add(ServerHeaderHandler.create());
        }
        handlers.forEach(h -> this.config.routeList().addFirst(RouteDefinition.create().handler((Handler<RoutingContext>)h)));
    }

    @Override
    public Vertx vertx() {
        return this.config.vertx();
    }

    @Override
    public Future<String> start() {
        Promise promise = Promise.promise();
        DeploymentOptions deploymentOptions = new DeploymentOptions().setInstances(this.config.instances());
        this.config.vertx().deployVerticle(() -> new ServerVerticle(this.config), deploymentOptions, (Handler)promise);
        return promise.future();
    }

    @Override
    public void startSync() throws ServerInitializationException {
        this.startSync(10, TimeUnit.SECONDS);
    }

    @Override
    public void startSync(int timeout, TimeUnit unit) throws ServerInitializationException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference error = new AtomicReference();
        this.start().onComplete(v -> {
            if (v.failed()) {
                error.set(v.cause());
            }
            latch.countDown();
        });
        try {
            if (!latch.await(timeout, unit)) {
                throw new ServerInitializationException(String.format("Server start up timed out after %d %s", timeout, unit.name().toLowerCase(Locale.ENGLISH)));
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ServerInitializationException("Thread interrupted during initialization", ex);
        }
        if (error.get() != null) {
            throw new ServerInitializationException((Throwable)error.get());
        }
    }

    @Override
    public Future<Void> shutdown() {
        Promise promise = Promise.promise();
        this.config.vertx().close((Handler)promise);
        return promise.future();
    }

    @Override
    public void shutdownSync() throws ServerShutdownException {
        this.shutdownSync(10, TimeUnit.SECONDS);
    }

    @Override
    public void shutdownSync(int timeout, TimeUnit unit) throws ServerShutdownException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference error = new AtomicReference();
        this.shutdown().onComplete(v -> {
            if (v.failed()) {
                error.set(v.cause());
            }
            latch.countDown();
        });
        try {
            if (!latch.await(timeout, unit)) {
                throw new ServerShutdownException(String.format("Server shutdown timed out after %d %s", timeout, unit.name().toLowerCase(Locale.ENGLISH)));
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ServerShutdownException("Thread interrupted during shutdown", ex);
        }
        if (error.get() != null) {
            throw new ServerShutdownException((Throwable)error.get());
        }
    }
}

