/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.ring.middleware;

import clojure.lang.IPersistentMap;
import com.appsflyer.donkey.server.exception.SerializationException;
import com.appsflyer.donkey.server.ring.handler.RingResponseField;
import com.appsflyer.donkey.server.ring.middleware.RingMiddleware;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;

public class JsonBodySerializer
implements RingMiddleware {
    private final ObjectMapper mapper;

    public JsonBodySerializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public IPersistentMap handle(IPersistentMap response) {
        Objects.requireNonNull(response, "Response map cannot be null");
        Object body = response.valAt((Object)RingResponseField.BODY.keyword(), null);
        if (body == null) {
            return response;
        }
        try {
            return response.assoc((Object)RingResponseField.BODY.keyword(), (Object)this.mapper.writeValueAsBytes(body));
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }
}

