/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.util;

import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.RT;
import com.appsflyer.donkey.client.exception.UnsupportedDataTypeException;
import com.appsflyer.donkey.util.MultipartFormConverter;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.multipart.MultipartForm;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class TypeConverter {
    private static final Function<String, String> STRING_IDENTITY = Function.identity();

    private TypeConverter() {
    }

    public static String stringJoiner(Iterable<String> v) {
        return String.join((CharSequence)",", v);
    }

    public static IPersistentVector toVector(Collection<?> v) {
        return LazilyPersistentVector.createOwning((Object[])v.toArray());
    }

    public static IPersistentMap toPersistentMap(MultiMap entries) {
        return TypeConverter.toPersistentMap(entries, TypeConverter::toVector);
    }

    public static IPersistentMap toPersistentMap(MultiMap entries, Function<List<String>, Object> aggregator) {
        return TypeConverter.toPersistentMap(entries, STRING_IDENTITY, aggregator);
    }

    public static IPersistentMap toPersistentMap(MultiMap entries, Function<String, String> keyTransformer, Function<List<String>, Object> aggregator) {
        Object[] entriesArray = new Object[entries.size() * 2];
        int i = 0;
        for (String name : entries.names()) {
            entriesArray[i] = keyTransformer.apply(name);
            List entryList = entries.getAll(name);
            entriesArray[i + 1] = entryList.size() == 1 ? entryList.get(0) : aggregator.apply(entryList);
            i += 2;
        }
        return RT.mapUniqueKeys((Object[])entriesArray);
    }

    public static IPersistentMap toUrlDecodedPersistentMap(MultiMap entries) {
        Object[] entriesArray = new Object[entries.size() * 2];
        int i = 0;
        for (String name : entries.names()) {
            entriesArray[i] = QueryStringDecoder.decodeComponent((String)name);
            entriesArray[i + 1] = QueryStringDecoder.decodeComponent((String)entries.get(name));
            i += 2;
        }
        return RT.mapUniqueKeys((Object[])entriesArray);
    }

    public static IPersistentMap toPersistentMap(Object[] values) {
        return RT.mapUniqueKeys((Object[])values);
    }

    public static byte[] toBytes(Object obj) {
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes(StandardCharsets.UTF_8);
        }
        if (obj instanceof InputStream) {
            try {
                return ((InputStream)obj).readAllBytes();
            }
            catch (IOException e) {
                throw new RuntimeException("Exception caught while consuming input stream", e);
            }
        }
        throw new UnsupportedDataTypeException(String.format("Cannot create a byte[] from %s. Only byte[] and String are supported.", obj.getClass().getCanonicalName()));
    }

    public static Buffer toBuffer(Object obj) {
        return Buffer.buffer((byte[])TypeConverter.toBytes(obj));
    }

    public static MultiMap toMultiMap(IPersistentMap map) {
        Objects.requireNonNull(map, "Cannot convert a null map to MultiMap");
        MultiMap res = MultiMap.caseInsensitiveMultiMap();
        for (Object obj : map) {
            IMapEntry entry = (IMapEntry)obj;
            res.add((String)entry.key(), (String)entry.val());
        }
        return res;
    }

    public static MultipartForm toMultipartForm(IPersistentMap map) {
        return MultipartFormConverter.from(map);
    }
}

