/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.CachingResolver;
import com.aphyr.riemann.client.ChannelGroupHandler;
import com.aphyr.riemann.client.ExceptionReporter;
import com.aphyr.riemann.client.Promise;
import com.aphyr.riemann.client.ReconnectHandler;
import com.aphyr.riemann.client.Resolver;
import com.aphyr.riemann.client.SynchronousTransport;
import com.aphyr.riemann.client.Transport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.handler.codec.protobuf.ProtobufEncoder;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class UdpTransport
implements SynchronousTransport {
    public static final Promise<Proto.Msg> blackhole = new Promise();
    public static final ProtobufEncoder pbEncoder = new ProtobufEncoder();
    public final DiscardHandler discardHandler = new DiscardHandler();
    public static final int DEFAULT_PORT = 5555;
    public volatile State state = State.DISCONNECTED;
    public volatile Timer timer;
    public volatile ConnectionlessBootstrap bootstrap;
    public final ChannelGroup channels = new DefaultChannelGroup();
    public final AtomicLong reconnectDelay = new AtomicLong(5000L);
    public final AtomicLong connectTimeout = new AtomicLong(5000L);
    public final AtomicInteger sendBufferSize = new AtomicInteger(16384);
    public final AtomicBoolean cacheDns = new AtomicBoolean(true);
    public final InetSocketAddress address;
    public volatile ExceptionReporter exceptionReporter = new ExceptionReporter(){

        @Override
        public void reportException(Throwable t) {
            t.printStackTrace();
        }
    };

    public void setExceptionReporter(ExceptionReporter exceptionReporter) {
        this.exceptionReporter = exceptionReporter;
    }

    public UdpTransport(InetSocketAddress address) {
        this.address = address;
    }

    public UdpTransport(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port));
    }

    public UdpTransport(String host) throws IOException {
        this(host, 5555);
    }

    public UdpTransport(int port) throws IOException {
        this(InetAddress.getLocalHost().getHostAddress(), port);
    }

    @Override
    public boolean isConnected() {
        return this.state == State.CONNECTED;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.state != State.DISCONNECTED) {
            return;
        }
        this.state = State.CONNECTING;
        NioDatagramChannelFactory channelFactory = new NioDatagramChannelFactory((Executor)Executors.newCachedThreadPool());
        this.timer = new HashedWheelTimer();
        this.bootstrap = new ConnectionlessBootstrap((ChannelFactory)channelFactory);
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                ChannelPipeline p = Channels.pipeline();
                p.addLast("reconnect", (ChannelHandler)new ReconnectHandler(UdpTransport.this.bootstrap, UdpTransport.this.timer, UdpTransport.this.reconnectDelay, TimeUnit.MILLISECONDS));
                p.addLast("protobuf-encoder", (ChannelHandler)pbEncoder);
                p.addLast("channelgroups", (ChannelHandler)new ChannelGroupHandler(UdpTransport.this.channels));
                p.addLast("discard", (ChannelHandler)UdpTransport.this.discardHandler);
                return p;
            }
        });
        Resolver resolver = this.cacheDns.get() ? new CachingResolver(this.address) : new Resolver(this.address);
        this.bootstrap.setOption("resolver", (Object)resolver);
        this.bootstrap.setOption("remoteAddress", (Object)resolver.resolve());
        this.bootstrap.setOption("sendBufferSize", (Object)this.sendBufferSize.get());
        ChannelFuture result = this.bootstrap.connect().awaitUninterruptibly();
        if (!result.isSuccess()) {
            this.close(true);
            throw new IOException("Connection failed", result.getCause());
        }
        this.state = State.CONNECTED;
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean force) {
        if (!force && this.state != State.CONNECTED) {
            return;
        }
        try {
            if (this.timer != null) {
                this.timer.stop();
            }
        }
        finally {
            this.timer = null;
            try {
                this.channels.close().awaitUninterruptibly();
            }
            finally {
                try {
                    this.bootstrap.releaseExternalResources();
                }
                finally {
                    this.bootstrap = null;
                    this.state = State.DISCONNECTED;
                }
            }
        }
    }

    @Override
    public void reconnect() throws IOException {
        this.close();
        this.connect();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public Proto.Msg sendMessage(Proto.Msg msg) {
        this.channels.write((Object)msg);
        return null;
    }

    @Override
    public Transport transport() {
        return null;
    }

    public class DiscardHandler
    extends SimpleChannelHandler {
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
            ctx.getChannel().setReadable(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            try {
                UdpTransport.this.exceptionReporter.reportException(e.getCause());
            }
            catch (Exception ee) {
            }
            finally {
                try {
                    ctx.getChannel().close();
                }
                catch (Exception ee) {
                    UdpTransport.this.exceptionReporter.reportException(ee);
                }
            }
        }
    }

    public static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

