/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;

public class SSL {
    public static char[] keyStorePassword = "GheesBetDyPhuvwotNolofamLydMues9".toCharArray();

    public static CertificateFactory X509CertFactory() throws CertificateException {
        return CertificateFactory.getInstance("X.509");
    }

    public static KeyFactory RSAKeyFactory() throws NoSuchAlgorithmException {
        return KeyFactory.getInstance("RSA");
    }

    public static byte[] base64toBinary(String string) {
        return DatatypeConverter.parseBase64Binary((String)string);
    }

    public static FileInputStream inputStream(String fileName) throws FileNotFoundException {
        return new FileInputStream(new File(fileName));
    }

    public static String slurp(String file) throws FileNotFoundException {
        return new Scanner(new File(file)).useDelimiter("\\Z").next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate loadCertificate(String file) throws IOException, CertificateException {
        FileInputStream stream = null;
        try {
            stream = SSL.inputStream(file);
            X509Certificate x509Certificate = (X509Certificate)SSL.X509CertFactory().generateCertificate(stream);
            return x509Certificate;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static PublicKey publicKey(String file) throws IOException, CertificateException {
        return SSL.loadCertificate(file).getPublicKey();
    }

    public static PrivateKey privateKey(String file) throws FileNotFoundException, NoSuchAlgorithmException, InvalidKeySpecException {
        Pattern p = Pattern.compile("^-----BEGIN ?.*? PRIVATE KEY-----$(.+)^-----END ?.*? PRIVATE KEY-----$", 40);
        Matcher matcher = p.matcher(SSL.slurp(file));
        matcher.find();
        return SSL.RSAKeyFactory().generatePrivate(new PKCS8EncodedKeySpec(SSL.base64toBinary(matcher.group(1))));
    }

    public static KeyStore keyStore(String keyFile, String certFile, String caCertFile) throws FileNotFoundException, IOException, KeyStoreException, NoSuchAlgorithmException, InvalidKeySpecException, CertificateException {
        PrivateKey key = SSL.privateKey(keyFile);
        X509Certificate cert = SSL.loadCertificate(certFile);
        X509Certificate caCert = SSL.loadCertificate(caCertFile);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        keyStore.setKeyEntry("key", key, keyStorePassword, new Certificate[]{cert});
        return keyStore;
    }

    public static KeyStore trustStore(String caCertFile) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        keyStore.setCertificateEntry("cacert", SSL.loadCertificate(caCertFile));
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrustManager trustManager(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException {
        TrustManagerFactory factory;
        TrustManagerFactory trustManagerFactory = factory = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
        synchronized (trustManagerFactory) {
            factory.init(keyStore);
            for (TrustManager tm : factory.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                return tm;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyManager keyManager(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException, UnrecoverableKeyException {
        KeyManagerFactory factory;
        KeyManagerFactory keyManagerFactory = factory = KeyManagerFactory.getInstance("PKIX", "SunJSSE");
        synchronized (keyManagerFactory) {
            factory.init(keyStore, keyStorePassword);
            for (KeyManager km : factory.getKeyManagers()) {
                if (!(km instanceof X509KeyManager)) continue;
                return km;
            }
            return null;
        }
    }

    public static SSLContext sslContext(String keyFile, String certFile, String caCertFile) throws KeyManagementException, NoSuchAlgorithmException, FileNotFoundException, KeyStoreException, IOException, InvalidKeySpecException, CertificateException, NoSuchProviderException, UnrecoverableKeyException {
        KeyManager keyManager = SSL.keyManager(SSL.keyStore(keyFile, certFile, caCertFile));
        TrustManager trustManager = SSL.trustManager(SSL.trustStore(caCertFile));
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(new KeyManager[]{keyManager}, new TrustManager[]{trustManager}, null);
        return context;
    }

    public static SSLContext uncheckedSSLContext(String keyFile, String certFile, String caCertFile) {
        try {
            return SSL.sslContext(keyFile, certFile, caCertFile);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
    }
}

