/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class ReconnectHandler
extends SimpleChannelUpstreamHandler {
    final ClientBootstrap bootstrap;
    public final Timer timer;
    public long startTime = -1L;
    public final AtomicLong delay;
    public final TimeUnit unit;

    public ReconnectHandler(ClientBootstrap bootstrap, Timer timer, AtomicLong delay, TimeUnit unit) {
        this.bootstrap = bootstrap;
        this.timer = timer;
        this.delay = delay;
        this.unit = unit;
    }

    InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.bootstrap.getOption("remoteAddress");
    }

    public void channelDisconnected(ChannelHandlerContext c, ChannelStateEvent e) {
        e.getChannel().close();
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        try {
            this.timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    ReconnectHandler.this.bootstrap.connect();
                }
            }, this.delay.get(), this.unit);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void channelConnected(ChannelHandlerContext c, ChannelStateEvent e) {
        if (this.startTime < 0L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public void exceptionCaught(ChannelHandlerContext c, ExceptionEvent e) {
        Throwable cause = e.getCause();
        if (cause instanceof ConnectException) {
            this.startTime = -1L;
        } else if (cause instanceof ReadTimeoutException) {
            // empty if block
        }
        c.getChannel().close();
    }
}

