/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.EventDSL;
import com.aphyr.riemann.client.MsgTooLargeException;
import com.aphyr.riemann.client.RiemannScheduler;
import com.aphyr.riemann.client.ServerError;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractRiemannClient {
    public static final int DEFAULT_PORT = 5555;
    protected final InetSocketAddress server;
    protected RiemannScheduler scheduler = null;

    public AbstractRiemannClient(InetSocketAddress server) {
        this.server = server;
    }

    public AbstractRiemannClient(int port) throws UnknownHostException {
        this.server = new InetSocketAddress(InetAddress.getLocalHost(), port);
    }

    public AbstractRiemannClient() throws UnknownHostException {
        this(new InetSocketAddress(InetAddress.getLocalHost(), 5555));
    }

    public EventDSL event() {
        return new EventDSL(this);
    }

    public Boolean sendEventsWithAck(Proto.Event ... events) throws IOException, ServerError, MsgTooLargeException {
        this.validate(this.sendRecvMessage(Proto.Msg.newBuilder().addAllEvents(Arrays.asList(events)).build()));
        return true;
    }

    public void sendEvents(Proto.Event ... events) {
        try {
            this.sendMaybeRecvMessage(Proto.Msg.newBuilder().addAllEvents(Arrays.asList(events)).build());
        }
        catch (IOException e) {
        }
        catch (MsgTooLargeException msgTooLargeException) {
            // empty catch block
        }
    }

    public void sendException(String service, Throwable t) {
        StringBuilder desc = new StringBuilder();
        desc.append(t.toString());
        desc.append("\n\n");
        for (StackTraceElement e : t.getStackTrace()) {
            desc.append(e);
            desc.append("\n");
        }
        this.event().service(service).state("error").tag("exception").tag(t.getClass().getSimpleName()).description(desc.toString()).send();
    }

    public List<Proto.Event> query(String q) throws IOException, ServerError, MsgTooLargeException {
        Proto.Msg m = this.sendRecvMessage(Proto.Msg.newBuilder().setQuery(Proto.Query.newBuilder().setString(q).build()).build());
        this.validate(m);
        return Collections.unmodifiableList(m.getEventsList());
    }

    public abstract void sendMessage(Proto.Msg var1) throws IOException, MsgTooLargeException;

    public abstract Proto.Msg recvMessage() throws IOException;

    public abstract Proto.Msg sendRecvMessage(Proto.Msg var1) throws IOException, MsgTooLargeException;

    public abstract Proto.Msg sendMaybeRecvMessage(Proto.Msg var1) throws IOException, MsgTooLargeException;

    public abstract boolean isConnected();

    public abstract void connect() throws IOException;

    public abstract void disconnect() throws IOException;

    public synchronized RiemannScheduler scheduler() {
        if (this.scheduler == null) {
            this.scheduler = new RiemannScheduler(this);
        }
        return this.scheduler;
    }

    public ScheduledFuture every(long interval, Runnable f) {
        return this.scheduler().every(interval, f);
    }

    public ScheduledFuture every(long interval, RiemannScheduler.Task f) {
        return this.scheduler().every(interval, f);
    }

    public ScheduledFuture every(long interval, TimeUnit unit, Runnable f) {
        return this.scheduler().every(interval, unit, f);
    }

    public ScheduledFuture every(long interval, TimeUnit unit, RiemannScheduler.Task f) {
        return this.scheduler().every(interval, unit, f);
    }

    public ScheduledFuture every(long interval, long delay, Runnable f) {
        return this.scheduler().every(interval, delay, f);
    }

    public ScheduledFuture every(long interval, long delay, RiemannScheduler.Task f) {
        return this.scheduler().every(interval, delay, f);
    }

    public ScheduledFuture every(long interval, long delay, TimeUnit unit, Runnable f) {
        return this.scheduler().every(interval, delay, unit, f);
    }

    public ScheduledFuture every(long interval, long delay, TimeUnit unit, RiemannScheduler.Task f) {
        return this.scheduler().every(interval, delay, unit, f);
    }

    public Proto.Msg validate(Proto.Msg message) throws IOException, ServerError {
        if (message.hasOk() && !message.getOk()) {
            throw new ServerError(message.getError());
        }
        return message;
    }
}

