// Compiled by ClojureScript 1.9.89 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_time.core');
goog.require('cljs.core');
goog.require('cljs_time.internal.core');
goog.require('clojure.string');
goog.require('goog.date.Interval');
goog.require('goog.date');
goog.require('goog.date.Date');
goog.require('goog.date.DateTime');
goog.require('goog.date.UtcDateTime');
cljs_time.core.deprecated = (function cljs_time$core$deprecated(message){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["DEPRECATION WARNING: ",message], 0));
});
/**
 * **Note:** Equality in goog.date.* (and also with plain
 * javascript dates) is not the same as in Joda/clj-time. Two date
 * objects representing the same instant in time in goog.date.* are not
 * equal.
 * 
 * If you need to test for equality use either `cljs-time.core/=`, or
 * optionally you can require the `cljs-time.extend` namespace which will
 * extend the goog.date.* datatypes, so that clojure.core/= works as
 * expected.
 */
cljs_time.core._EQ_ = cljs_time.internal.core._EQ_;

/**
 * Interface for various date time functions
 * @interface
 */
cljs_time.core.DateTimeProtocol = function(){};

/**
 * Return the year component of the given date/time.
 */
cljs_time.core.year = (function cljs_time$core$year(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$year$arity$1 == null)))){
return this$.cljs_time$core$DateTimeProtocol$year$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.year[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.year["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.year",this$);
}
}
}
});

/**
 * Return the month component of the given date/time.
 */
cljs_time.core.month = (function cljs_time$core$month(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$month$arity$1 == null)))){
return this$.cljs_time$core$DateTimeProtocol$month$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.month[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.month["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.month",this$);
}
}
}
});

/**
 * Return the day of month component of the given date/time.
 */
cljs_time.core.day = (function cljs_time$core$day(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$day$arity$1 == null)))){
return this$.cljs_time$core$DateTimeProtocol$day$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.day[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.day["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.day",this$);
}
}
}
});

/**
 * Return the day of week component of the given date/time. Monday is 1 and Sunday is 7
 */
cljs_time.core.day_of_week = (function cljs_time$core$day_of_week(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$day_of_week$arity$1 == null)))){
return this$.cljs_time$core$DateTimeProtocol$day_of_week$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.day_of_week[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.day_of_week["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.day-of-week",this$);
}
}
}
});

/**
 * Return the hour of day component of the given date/time. A time of 12:01am will have an hour component of 0.
 */
cljs_time.core.hour = (function cljs_time$core$hour(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$hour$arity$1 == null)))){
return this$.cljs_time$core$DateTimeProtocol$hour$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.hour[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.hour["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.hour",this$);
}
}
}
});

/**
 * Return the minute of hour component of the given date/time.
 */
cljs_time.core.minute = (function cljs_time$core$minute(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$minute$arity$1 == null)))){
return this$.cljs_time$core$DateTimeProtocol$minute$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.minute[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.minute["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.minute",this$);
}
}
}
});

/**
 * Return the second of minute component of the given date/time.
 */
cljs_time.core.sec = (function cljs_time$core$sec(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$sec$arity$1 == null)))){
return this$.cljs_time$core$DateTimeProtocol$sec$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.sec[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.sec["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.sec",this$);
}
}
}
});

/**
 * Return the second of minute component of the given date/time.
 */
cljs_time.core.second = (function cljs_time$core$second(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$second$arity$1 == null)))){
return this$.cljs_time$core$DateTimeProtocol$second$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.second[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.second["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.second",this$);
}
}
}
});

/**
 * Return the millisecond of second component of the given date/time.
 */
cljs_time.core.milli = (function cljs_time$core$milli(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$milli$arity$1 == null)))){
return this$.cljs_time$core$DateTimeProtocol$milli$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.milli[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.milli["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.milli",this$);
}
}
}
});

/**
 * Returns true if DateTime 'this' is strictly equal to date/time 'that'.
 */
cljs_time.core.equal_QMARK_ = (function cljs_time$core$equal_QMARK_(this$,that){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$equal_QMARK_$arity$2 == null)))){
return this$.cljs_time$core$DateTimeProtocol$equal_QMARK_$arity$2(this$,that);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.equal_QMARK_[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$2(this$,that) : m__7210__auto__.call(null,this$,that));
} else {
var m__7210__auto____$1 = (cljs_time.core.equal_QMARK_["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,that) : m__7210__auto____$1.call(null,this$,that));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.equal?",this$);
}
}
}
});

/**
 * Returns true if DateTime 'this' is strictly after date/time 'that'.
 */
cljs_time.core.after_QMARK_ = (function cljs_time$core$after_QMARK_(this$,that){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$after_QMARK_$arity$2 == null)))){
return this$.cljs_time$core$DateTimeProtocol$after_QMARK_$arity$2(this$,that);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.after_QMARK_[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$2(this$,that) : m__7210__auto__.call(null,this$,that));
} else {
var m__7210__auto____$1 = (cljs_time.core.after_QMARK_["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,that) : m__7210__auto____$1.call(null,this$,that));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.after?",this$);
}
}
}
});

/**
 * Returns true if DateTime 'this' is strictly before date/time 'that'.
 */
cljs_time.core.before_QMARK_ = (function cljs_time$core$before_QMARK_(this$,that){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$before_QMARK_$arity$2 == null)))){
return this$.cljs_time$core$DateTimeProtocol$before_QMARK_$arity$2(this$,that);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.before_QMARK_[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$2(this$,that) : m__7210__auto__.call(null,this$,that));
} else {
var m__7210__auto____$1 = (cljs_time.core.before_QMARK_["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,that) : m__7210__auto____$1.call(null,this$,that));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.before?",this$);
}
}
}
});

/**
 * Returns a new date/time corresponding to the given date/time moved forwards by the given Period(s).
 */
cljs_time.core.plus_ = (function cljs_time$core$plus_(this$,period){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$plus_$arity$2 == null)))){
return this$.cljs_time$core$DateTimeProtocol$plus_$arity$2(this$,period);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.plus_[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$2(this$,period) : m__7210__auto__.call(null,this$,period));
} else {
var m__7210__auto____$1 = (cljs_time.core.plus_["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,period) : m__7210__auto____$1.call(null,this$,period));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.plus-",this$);
}
}
}
});

/**
 * Returns a new date/time corresponding to the given date/time moved backwards by the given Period(s).
 */
cljs_time.core.minus_ = (function cljs_time$core$minus_(this$,period){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$minus_$arity$2 == null)))){
return this$.cljs_time$core$DateTimeProtocol$minus_$arity$2(this$,period);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.minus_[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$2(this$,period) : m__7210__auto__.call(null,this$,period));
} else {
var m__7210__auto____$1 = (cljs_time.core.minus_["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,period) : m__7210__auto____$1.call(null,this$,period));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.minus-",this$);
}
}
}
});

/**
 * Returns the first day of the month
 */
cljs_time.core.first_day_of_the_month_ = (function cljs_time$core$first_day_of_the_month_(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$first_day_of_the_month_$arity$1 == null)))){
return this$.cljs_time$core$DateTimeProtocol$first_day_of_the_month_$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.first_day_of_the_month_[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.first_day_of_the_month_["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.first-day-of-the-month-",this$);
}
}
}
});

/**
 * Returns the last day of the month
 */
cljs_time.core.last_day_of_the_month_ = (function cljs_time$core$last_day_of_the_month_(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$last_day_of_the_month_$arity$1 == null)))){
return this$.cljs_time$core$DateTimeProtocol$last_day_of_the_month_$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.last_day_of_the_month_[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.last_day_of_the_month_["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.last-day-of-the-month-",this$);
}
}
}
});

/**
 * Returs the number of weeks in the year
 */
cljs_time.core.week_number_of_year = (function cljs_time$core$week_number_of_year(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$DateTimeProtocol$week_number_of_year$arity$1 == null)))){
return this$.cljs_time$core$DateTimeProtocol$week_number_of_year$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.week_number_of_year[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.week_number_of_year["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("DateTimeProtocol.week-number-of-year",this$);
}
}
}
});


/**
 * Interface for in-<time unit> functions
 * @interface
 */
cljs_time.core.InTimeUnitProtocol = function(){};

/**
 * Return the time in milliseconds.
 */
cljs_time.core.in_millis = (function cljs_time$core$in_millis(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$InTimeUnitProtocol$in_millis$arity$1 == null)))){
return this$.cljs_time$core$InTimeUnitProtocol$in_millis$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.in_millis[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.in_millis["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("InTimeUnitProtocol.in-millis",this$);
}
}
}
});

/**
 * Return the time in seconds.
 */
cljs_time.core.in_seconds = (function cljs_time$core$in_seconds(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$InTimeUnitProtocol$in_seconds$arity$1 == null)))){
return this$.cljs_time$core$InTimeUnitProtocol$in_seconds$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.in_seconds[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.in_seconds["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("InTimeUnitProtocol.in-seconds",this$);
}
}
}
});

/**
 * Return the time in minutes.
 */
cljs_time.core.in_minutes = (function cljs_time$core$in_minutes(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$InTimeUnitProtocol$in_minutes$arity$1 == null)))){
return this$.cljs_time$core$InTimeUnitProtocol$in_minutes$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.in_minutes[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.in_minutes["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("InTimeUnitProtocol.in-minutes",this$);
}
}
}
});

/**
 * Return the time in hours.
 */
cljs_time.core.in_hours = (function cljs_time$core$in_hours(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$InTimeUnitProtocol$in_hours$arity$1 == null)))){
return this$.cljs_time$core$InTimeUnitProtocol$in_hours$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.in_hours[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.in_hours["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("InTimeUnitProtocol.in-hours",this$);
}
}
}
});

/**
 * Return the time in days.
 */
cljs_time.core.in_days = (function cljs_time$core$in_days(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$InTimeUnitProtocol$in_days$arity$1 == null)))){
return this$.cljs_time$core$InTimeUnitProtocol$in_days$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.in_days[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.in_days["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("InTimeUnitProtocol.in-days",this$);
}
}
}
});

/**
 * Return the time in weeks
 */
cljs_time.core.in_weeks = (function cljs_time$core$in_weeks(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$InTimeUnitProtocol$in_weeks$arity$1 == null)))){
return this$.cljs_time$core$InTimeUnitProtocol$in_weeks$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.in_weeks[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.in_weeks["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("InTimeUnitProtocol.in-weeks",this$);
}
}
}
});

/**
 * Return the time in months
 */
cljs_time.core.in_months = (function cljs_time$core$in_months(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$InTimeUnitProtocol$in_months$arity$1 == null)))){
return this$.cljs_time$core$InTimeUnitProtocol$in_months$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.in_months[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.in_months["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("InTimeUnitProtocol.in-months",this$);
}
}
}
});

/**
 * Return the time in years
 */
cljs_time.core.in_years = (function cljs_time$core$in_years(this$){
if((!((this$ == null))) && (!((this$.cljs_time$core$InTimeUnitProtocol$in_years$arity$1 == null)))){
return this$.cljs_time$core$InTimeUnitProtocol$in_years$arity$1(this$);
} else {
var x__7209__auto__ = (((this$ == null))?null:this$);
var m__7210__auto__ = (cljs_time.core.in_years[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto__.call(null,this$));
} else {
var m__7210__auto____$1 = (cljs_time.core.in_years["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7210__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("InTimeUnitProtocol.in-years",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs_time.core.Interval = (function (start,end,__meta,__extmap,__hash){
this.start = start;
this.end = end;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs_time.core.Interval.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7168__auto__,k__7169__auto__){
var self__ = this;
var this__7168__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__7168__auto____$1,k__7169__auto__,null);
});

cljs_time.core.Interval.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7170__auto__,k12465,else__7171__auto__){
var self__ = this;
var this__7170__auto____$1 = this;
var G__12467 = (((k12465 instanceof cljs.core.Keyword))?k12465.fqn:null);
switch (G__12467) {
case "start":
return self__.start;

break;
case "end":
return self__.end;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12465,else__7171__auto__);

}
});

cljs_time.core.Interval.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7182__auto__,writer__7183__auto__,opts__7184__auto__){
var self__ = this;
var this__7182__auto____$1 = this;
var pr_pair__7185__auto__ = ((function (this__7182__auto____$1){
return (function (keyval__7186__auto__){
return cljs.core.pr_sequential_writer(writer__7183__auto__,cljs.core.pr_writer,""," ","",opts__7184__auto__,keyval__7186__auto__);
});})(this__7182__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7183__auto__,pr_pair__7185__auto__,"#cljs-time.core.Interval{",", ","}",opts__7184__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$start,self__.start],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$end,self__.end],null))], null),self__.__extmap));
});

cljs_time.core.Interval.prototype.cljs$core$IIterable$ = true;

cljs_time.core.Interval.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12464){
var self__ = this;
var G__12464__$1 = this;
return (new cljs.core.RecordIter((0),G__12464__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$start,cljs.core.cst$kw$end], null),cljs.core._iterator(self__.__extmap)));
});

cljs_time.core.Interval.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7166__auto__){
var self__ = this;
var this__7166__auto____$1 = this;
return self__.__meta;
});

cljs_time.core.Interval.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7162__auto__){
var self__ = this;
var this__7162__auto____$1 = this;
return (new cljs_time.core.Interval(self__.start,self__.end,self__.__meta,self__.__extmap,self__.__hash));
});

cljs_time.core.Interval.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7172__auto__){
var self__ = this;
var this__7172__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

cljs_time.core.Interval.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7163__auto__){
var self__ = this;
var this__7163__auto____$1 = this;
var h__6981__auto__ = self__.__hash;
if(!((h__6981__auto__ == null))){
return h__6981__auto__;
} else {
var h__6981__auto____$1 = cljs.core.hash_imap(this__7163__auto____$1);
self__.__hash = h__6981__auto____$1;

return h__6981__auto____$1;
}
});

cljs_time.core.Interval.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7164__auto__,other__7165__auto__){
var self__ = this;
var this__7164__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6534__auto__ = other__7165__auto__;
if(cljs.core.truth_(and__6534__auto__)){
var and__6534__auto____$1 = (this__7164__auto____$1.constructor === other__7165__auto__.constructor);
if(and__6534__auto____$1){
return cljs.core.equiv_map(this__7164__auto____$1,other__7165__auto__);
} else {
return and__6534__auto____$1;
}
} else {
return and__6534__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljs_time.core.Interval.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7177__auto__,k__7178__auto__){
var self__ = this;
var this__7177__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$start,null,cljs.core.cst$kw$end,null], null), null),k__7178__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7177__auto____$1),self__.__meta),k__7178__auto__);
} else {
return (new cljs_time.core.Interval(self__.start,self__.end,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7178__auto__)),null));
}
});

cljs_time.core.Interval.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7175__auto__,k__7176__auto__,G__12464){
var self__ = this;
var this__7175__auto____$1 = this;
var pred__12468 = cljs.core.keyword_identical_QMARK_;
var expr__12469 = k__7176__auto__;
if(cljs.core.truth_((pred__12468.cljs$core$IFn$_invoke$arity$2 ? pred__12468.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$start,expr__12469) : pred__12468.call(null,cljs.core.cst$kw$start,expr__12469)))){
return (new cljs_time.core.Interval(G__12464,self__.end,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12468.cljs$core$IFn$_invoke$arity$2 ? pred__12468.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$end,expr__12469) : pred__12468.call(null,cljs.core.cst$kw$end,expr__12469)))){
return (new cljs_time.core.Interval(self__.start,G__12464,self__.__meta,self__.__extmap,null));
} else {
return (new cljs_time.core.Interval(self__.start,self__.end,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7176__auto__,G__12464),null));
}
}
});

cljs_time.core.Interval.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7180__auto__){
var self__ = this;
var this__7180__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$start,self__.start],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$end,self__.end],null))], null),self__.__extmap));
});

cljs_time.core.Interval.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7167__auto__,G__12464){
var self__ = this;
var this__7167__auto____$1 = this;
return (new cljs_time.core.Interval(self__.start,self__.end,G__12464,self__.__extmap,self__.__hash));
});

cljs_time.core.Interval.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7173__auto__,entry__7174__auto__){
var self__ = this;
var this__7173__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7174__auto__)){
return cljs.core._assoc(this__7173__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7174__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7174__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7173__auto____$1,entry__7174__auto__);
}
});

cljs_time.core.Interval.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end], null);
});

cljs_time.core.Interval.cljs$lang$type = true;

cljs_time.core.Interval.cljs$lang$ctorPrSeq = (function (this__7202__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"cljs-time.core/Interval");
});

cljs_time.core.Interval.cljs$lang$ctorPrWriter = (function (this__7202__auto__,writer__7203__auto__){
return cljs.core._write(writer__7203__auto__,"cljs-time.core/Interval");
});

cljs_time.core.__GT_Interval = (function cljs_time$core$__GT_Interval(start,end){
return (new cljs_time.core.Interval(start,end,null,null,null));
});

cljs_time.core.map__GT_Interval = (function cljs_time$core$map__GT_Interval(G__12466){
return (new cljs_time.core.Interval(cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(G__12466),cljs.core.cst$kw$end.cljs$core$IFn$_invoke$arity$1(G__12466),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12466,cljs.core.cst$kw$start,cljs.core.array_seq([cljs.core.cst$kw$end], 0)),null));
});

/**
 * Returns an Interval representing the span between the two given DateTime.
 *   Note that intervals are closed on the left and open on the right.
 */
cljs_time.core.interval = (function cljs_time$core$interval(start,end){
if((start.getTime() <= end.getTime())){
} else {
throw (new Error("Assert failed: (<= (.getTime start) (.getTime end))"));
}

return cljs_time.core.__GT_Interval(start,end);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs_time.core.Period = (function (years,months,weeks,days,hours,minutes,seconds,millis,__meta,__extmap,__hash){
this.years = years;
this.months = months;
this.weeks = weeks;
this.days = days;
this.hours = hours;
this.minutes = minutes;
this.seconds = seconds;
this.millis = millis;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs_time.core.Period.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7168__auto__,k__7169__auto__){
var self__ = this;
var this__7168__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__7168__auto____$1,k__7169__auto__,null);
});

cljs_time.core.Period.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7170__auto__,k12473,else__7171__auto__){
var self__ = this;
var this__7170__auto____$1 = this;
var G__12475 = (((k12473 instanceof cljs.core.Keyword))?k12473.fqn:null);
switch (G__12475) {
case "years":
return self__.years;

break;
case "months":
return self__.months;

break;
case "weeks":
return self__.weeks;

break;
case "days":
return self__.days;

break;
case "hours":
return self__.hours;

break;
case "minutes":
return self__.minutes;

break;
case "seconds":
return self__.seconds;

break;
case "millis":
return self__.millis;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12473,else__7171__auto__);

}
});

cljs_time.core.Period.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7182__auto__,writer__7183__auto__,opts__7184__auto__){
var self__ = this;
var this__7182__auto____$1 = this;
var pr_pair__7185__auto__ = ((function (this__7182__auto____$1){
return (function (keyval__7186__auto__){
return cljs.core.pr_sequential_writer(writer__7183__auto__,cljs.core.pr_writer,""," ","",opts__7184__auto__,keyval__7186__auto__);
});})(this__7182__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7183__auto__,pr_pair__7185__auto__,"#cljs-time.core.Period{",", ","}",opts__7184__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$years,self__.years],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$months,self__.months],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$weeks,self__.weeks],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$days,self__.days],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$hours,self__.hours],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$minutes,self__.minutes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$seconds,self__.seconds],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$millis,self__.millis],null))], null),self__.__extmap));
});

cljs_time.core.Period.prototype.cljs$core$IIterable$ = true;

cljs_time.core.Period.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12472){
var self__ = this;
var G__12472__$1 = this;
return (new cljs.core.RecordIter((0),G__12472__$1,8,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$years,cljs.core.cst$kw$months,cljs.core.cst$kw$weeks,cljs.core.cst$kw$days,cljs.core.cst$kw$hours,cljs.core.cst$kw$minutes,cljs.core.cst$kw$seconds,cljs.core.cst$kw$millis], null),cljs.core._iterator(self__.__extmap)));
});

cljs_time.core.Period.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7166__auto__){
var self__ = this;
var this__7166__auto____$1 = this;
return self__.__meta;
});

cljs_time.core.Period.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7162__auto__){
var self__ = this;
var this__7162__auto____$1 = this;
return (new cljs_time.core.Period(self__.years,self__.months,self__.weeks,self__.days,self__.hours,self__.minutes,self__.seconds,self__.millis,self__.__meta,self__.__extmap,self__.__hash));
});

cljs_time.core.Period.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7172__auto__){
var self__ = this;
var this__7172__auto____$1 = this;
return (8 + cljs.core.count(self__.__extmap));
});

cljs_time.core.Period.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7163__auto__){
var self__ = this;
var this__7163__auto____$1 = this;
var h__6981__auto__ = self__.__hash;
if(!((h__6981__auto__ == null))){
return h__6981__auto__;
} else {
var h__6981__auto____$1 = cljs.core.hash_imap(this__7163__auto____$1);
self__.__hash = h__6981__auto____$1;

return h__6981__auto____$1;
}
});

cljs_time.core.Period.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7164__auto__,other__7165__auto__){
var self__ = this;
var this__7164__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6534__auto__ = other__7165__auto__;
if(cljs.core.truth_(and__6534__auto__)){
var and__6534__auto____$1 = (this__7164__auto____$1.constructor === other__7165__auto__.constructor);
if(and__6534__auto____$1){
return cljs.core.equiv_map(this__7164__auto____$1,other__7165__auto__);
} else {
return and__6534__auto____$1;
}
} else {
return and__6534__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljs_time.core.Period.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7177__auto__,k__7178__auto__){
var self__ = this;
var this__7177__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$months,null,cljs.core.cst$kw$days,null,cljs.core.cst$kw$seconds,null,cljs.core.cst$kw$hours,null,cljs.core.cst$kw$years,null,cljs.core.cst$kw$minutes,null,cljs.core.cst$kw$weeks,null,cljs.core.cst$kw$millis,null], null), null),k__7178__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7177__auto____$1),self__.__meta),k__7178__auto__);
} else {
return (new cljs_time.core.Period(self__.years,self__.months,self__.weeks,self__.days,self__.hours,self__.minutes,self__.seconds,self__.millis,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7178__auto__)),null));
}
});

cljs_time.core.Period.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7175__auto__,k__7176__auto__,G__12472){
var self__ = this;
var this__7175__auto____$1 = this;
var pred__12476 = cljs.core.keyword_identical_QMARK_;
var expr__12477 = k__7176__auto__;
if(cljs.core.truth_((pred__12476.cljs$core$IFn$_invoke$arity$2 ? pred__12476.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$years,expr__12477) : pred__12476.call(null,cljs.core.cst$kw$years,expr__12477)))){
return (new cljs_time.core.Period(G__12472,self__.months,self__.weeks,self__.days,self__.hours,self__.minutes,self__.seconds,self__.millis,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12476.cljs$core$IFn$_invoke$arity$2 ? pred__12476.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$months,expr__12477) : pred__12476.call(null,cljs.core.cst$kw$months,expr__12477)))){
return (new cljs_time.core.Period(self__.years,G__12472,self__.weeks,self__.days,self__.hours,self__.minutes,self__.seconds,self__.millis,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12476.cljs$core$IFn$_invoke$arity$2 ? pred__12476.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$weeks,expr__12477) : pred__12476.call(null,cljs.core.cst$kw$weeks,expr__12477)))){
return (new cljs_time.core.Period(self__.years,self__.months,G__12472,self__.days,self__.hours,self__.minutes,self__.seconds,self__.millis,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12476.cljs$core$IFn$_invoke$arity$2 ? pred__12476.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$days,expr__12477) : pred__12476.call(null,cljs.core.cst$kw$days,expr__12477)))){
return (new cljs_time.core.Period(self__.years,self__.months,self__.weeks,G__12472,self__.hours,self__.minutes,self__.seconds,self__.millis,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12476.cljs$core$IFn$_invoke$arity$2 ? pred__12476.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$hours,expr__12477) : pred__12476.call(null,cljs.core.cst$kw$hours,expr__12477)))){
return (new cljs_time.core.Period(self__.years,self__.months,self__.weeks,self__.days,G__12472,self__.minutes,self__.seconds,self__.millis,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12476.cljs$core$IFn$_invoke$arity$2 ? pred__12476.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$minutes,expr__12477) : pred__12476.call(null,cljs.core.cst$kw$minutes,expr__12477)))){
return (new cljs_time.core.Period(self__.years,self__.months,self__.weeks,self__.days,self__.hours,G__12472,self__.seconds,self__.millis,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12476.cljs$core$IFn$_invoke$arity$2 ? pred__12476.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$seconds,expr__12477) : pred__12476.call(null,cljs.core.cst$kw$seconds,expr__12477)))){
return (new cljs_time.core.Period(self__.years,self__.months,self__.weeks,self__.days,self__.hours,self__.minutes,G__12472,self__.millis,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12476.cljs$core$IFn$_invoke$arity$2 ? pred__12476.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$millis,expr__12477) : pred__12476.call(null,cljs.core.cst$kw$millis,expr__12477)))){
return (new cljs_time.core.Period(self__.years,self__.months,self__.weeks,self__.days,self__.hours,self__.minutes,self__.seconds,G__12472,self__.__meta,self__.__extmap,null));
} else {
return (new cljs_time.core.Period(self__.years,self__.months,self__.weeks,self__.days,self__.hours,self__.minutes,self__.seconds,self__.millis,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7176__auto__,G__12472),null));
}
}
}
}
}
}
}
}
});

cljs_time.core.Period.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7180__auto__){
var self__ = this;
var this__7180__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$years,self__.years],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$months,self__.months],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$weeks,self__.weeks],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$days,self__.days],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$hours,self__.hours],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$minutes,self__.minutes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$seconds,self__.seconds],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$millis,self__.millis],null))], null),self__.__extmap));
});

cljs_time.core.Period.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7167__auto__,G__12472){
var self__ = this;
var this__7167__auto____$1 = this;
return (new cljs_time.core.Period(self__.years,self__.months,self__.weeks,self__.days,self__.hours,self__.minutes,self__.seconds,self__.millis,G__12472,self__.__extmap,self__.__hash));
});

cljs_time.core.Period.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7173__auto__,entry__7174__auto__){
var self__ = this;
var this__7173__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7174__auto__)){
return cljs.core._assoc(this__7173__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7174__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7174__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7173__auto____$1,entry__7174__auto__);
}
});

cljs_time.core.Period.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$years,cljs.core.cst$sym$months,cljs.core.cst$sym$weeks,cljs.core.cst$sym$days,cljs.core.cst$sym$hours,cljs.core.cst$sym$minutes,cljs.core.cst$sym$seconds,cljs.core.cst$sym$millis], null);
});

cljs_time.core.Period.cljs$lang$type = true;

cljs_time.core.Period.cljs$lang$ctorPrSeq = (function (this__7202__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"cljs-time.core/Period");
});

cljs_time.core.Period.cljs$lang$ctorPrWriter = (function (this__7202__auto__,writer__7203__auto__){
return cljs.core._write(writer__7203__auto__,"cljs-time.core/Period");
});

cljs_time.core.__GT_Period = (function cljs_time$core$__GT_Period(years,months,weeks,days,hours,minutes,seconds,millis){
return (new cljs_time.core.Period(years,months,weeks,days,hours,minutes,seconds,millis,null,null,null));
});

cljs_time.core.map__GT_Period = (function cljs_time$core$map__GT_Period(G__12474){
return (new cljs_time.core.Period(cljs.core.cst$kw$years.cljs$core$IFn$_invoke$arity$1(G__12474),cljs.core.cst$kw$months.cljs$core$IFn$_invoke$arity$1(G__12474),cljs.core.cst$kw$weeks.cljs$core$IFn$_invoke$arity$1(G__12474),cljs.core.cst$kw$days.cljs$core$IFn$_invoke$arity$1(G__12474),cljs.core.cst$kw$hours.cljs$core$IFn$_invoke$arity$1(G__12474),cljs.core.cst$kw$minutes.cljs$core$IFn$_invoke$arity$1(G__12474),cljs.core.cst$kw$seconds.cljs$core$IFn$_invoke$arity$1(G__12474),cljs.core.cst$kw$millis.cljs$core$IFn$_invoke$arity$1(G__12474),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12474,cljs.core.cst$kw$years,cljs.core.array_seq([cljs.core.cst$kw$months,cljs.core.cst$kw$weeks,cljs.core.cst$kw$days,cljs.core.cst$kw$hours,cljs.core.cst$kw$minutes,cljs.core.cst$kw$seconds,cljs.core.cst$kw$millis], 0)),null));
});

cljs_time.core.period = (function cljs_time$core$period(var_args){
var args12480 = [];
var len__7621__auto___12486 = arguments.length;
var i__7622__auto___12487 = (0);
while(true){
if((i__7622__auto___12487 < len__7621__auto___12486)){
args12480.push((arguments[i__7622__auto___12487]));

var G__12488 = (i__7622__auto___12487 + (1));
i__7622__auto___12487 = G__12488;
continue;
} else {
}
break;
}

var G__12485 = args12480.length;
switch (G__12485) {
case 2:
return cljs_time.core.period.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7640__auto__ = (new cljs.core.IndexedSeq(args12480.slice((2)),(0),null));
return cljs_time.core.period.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7640__auto__);

}
});

cljs_time.core.period.cljs$core$IFn$_invoke$arity$2 = (function (period,value){
return cljs_time.core.map__GT_Period(cljs.core.PersistentArrayMap.fromArray([period,value], true, false));
});

cljs_time.core.period.cljs$core$IFn$_invoke$arity$variadic = (function (p1,v1,kvs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc,cljs_time.core.period.cljs$core$IFn$_invoke$arity$2(p1,v1),kvs);
});

cljs_time.core.period.cljs$lang$applyTo = (function (seq12481){
var G__12482 = cljs.core.first(seq12481);
var seq12481__$1 = cljs.core.next(seq12481);
var G__12483 = cljs.core.first(seq12481__$1);
var seq12481__$2 = cljs.core.next(seq12481__$1);
return cljs_time.core.period.cljs$core$IFn$_invoke$arity$variadic(G__12482,G__12483,seq12481__$2);
});

cljs_time.core.period.cljs$lang$maxFixedArity = (2);

cljs_time.core.period_fns = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$millis,(function (date,op,value){
var ms = (function (){var G__12490 = date.getTime();
var G__12491 = value;
return (op.cljs$core$IFn$_invoke$arity$2 ? op.cljs$core$IFn$_invoke$arity$2(G__12490,G__12491) : op.call(null,G__12490,G__12491));
})();
var G__12492 = date;
G__12492.setTime(ms);

return G__12492;
}),cljs.core.cst$kw$weeks,(function (date,op,value){
var days = (function (){var G__12493 = (0);
var G__12494 = (value * (7));
return (op.cljs$core$IFn$_invoke$arity$2 ? op.cljs$core$IFn$_invoke$arity$2(G__12493,G__12494) : op.call(null,G__12493,G__12494));
})();
var G__12495 = date;
G__12495.add((new goog.date.Interval(goog.date.Interval.DAYS,days)));

return G__12495;
})], null);
cljs_time.core.periods = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$seconds,goog.date.Interval.SECONDS,cljs.core.cst$kw$minutes,goog.date.Interval.MINUTES,cljs.core.cst$kw$hours,goog.date.Interval.HOURS,cljs.core.cst$kw$days,goog.date.Interval.DAYS,cljs.core.cst$kw$months,goog.date.Interval.MONTHS,cljs.core.cst$kw$years,goog.date.Interval.YEARS], null);
cljs_time.core.period_fn = (function cljs_time$core$period_fn(p){
return (function (operator,date){
var date_SINGLEQUOTE_ = date.clone();
var __GT_goog_interval = ((function (date_SINGLEQUOTE_){
return (function (op,interval,value){
if(cljs.core.truth_((function (){var and__6534__auto__ = interval;
if(cljs.core.truth_(and__6534__auto__)){
return value;
} else {
return and__6534__auto__;
}
})())){
return (new goog.date.Interval(interval,(op.cljs$core$IFn$_invoke$arity$2 ? op.cljs$core$IFn$_invoke$arity$2((0),value) : op.call(null,(0),value))));
} else {
return null;
}
});})(date_SINGLEQUOTE_))
;
var seq__12506_12516 = cljs.core.seq(p);
var chunk__12507_12517 = null;
var count__12508_12518 = (0);
var i__12509_12519 = (0);
while(true){
if((i__12509_12519 < count__12508_12518)){
var vec__12510_12520 = chunk__12507_12517.cljs$core$IIndexed$_nth$arity$2(null,i__12509_12519);
var k_12521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12510_12520,(0),null);
var v_12522 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12510_12520,(1),null);
var temp__4655__auto___12523 = (cljs_time.core.periods.cljs$core$IFn$_invoke$arity$1 ? cljs_time.core.periods.cljs$core$IFn$_invoke$arity$1(k_12521) : cljs_time.core.periods.call(null,k_12521));
if(cljs.core.truth_(temp__4655__auto___12523)){
var period_12524 = temp__4655__auto___12523;
var temp__4657__auto___12525 = __GT_goog_interval(operator,period_12524,v_12522);
if(cljs.core.truth_(temp__4657__auto___12525)){
var i_12526 = temp__4657__auto___12525;
date_SINGLEQUOTE_.add(i_12526);
} else {
}
} else {
var temp__4657__auto___12527 = (cljs_time.core.period_fns.cljs$core$IFn$_invoke$arity$1 ? cljs_time.core.period_fns.cljs$core$IFn$_invoke$arity$1(k_12521) : cljs_time.core.period_fns.call(null,k_12521));
if(cljs.core.truth_(temp__4657__auto___12527)){
var f_12528 = temp__4657__auto___12527;
(f_12528.cljs$core$IFn$_invoke$arity$3 ? f_12528.cljs$core$IFn$_invoke$arity$3(date_SINGLEQUOTE_,operator,v_12522) : f_12528.call(null,date_SINGLEQUOTE_,operator,v_12522));
} else {
}
}

var G__12529 = seq__12506_12516;
var G__12530 = chunk__12507_12517;
var G__12531 = count__12508_12518;
var G__12532 = (i__12509_12519 + (1));
seq__12506_12516 = G__12529;
chunk__12507_12517 = G__12530;
count__12508_12518 = G__12531;
i__12509_12519 = G__12532;
continue;
} else {
var temp__4657__auto___12533 = cljs.core.seq(seq__12506_12516);
if(temp__4657__auto___12533){
var seq__12506_12534__$1 = temp__4657__auto___12533;
if(cljs.core.chunked_seq_QMARK_(seq__12506_12534__$1)){
var c__7357__auto___12535 = cljs.core.chunk_first(seq__12506_12534__$1);
var G__12536 = cljs.core.chunk_rest(seq__12506_12534__$1);
var G__12537 = c__7357__auto___12535;
var G__12538 = cljs.core.count(c__7357__auto___12535);
var G__12539 = (0);
seq__12506_12516 = G__12536;
chunk__12507_12517 = G__12537;
count__12508_12518 = G__12538;
i__12509_12519 = G__12539;
continue;
} else {
var vec__12513_12540 = cljs.core.first(seq__12506_12534__$1);
var k_12541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12513_12540,(0),null);
var v_12542 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12513_12540,(1),null);
var temp__4655__auto___12543 = (cljs_time.core.periods.cljs$core$IFn$_invoke$arity$1 ? cljs_time.core.periods.cljs$core$IFn$_invoke$arity$1(k_12541) : cljs_time.core.periods.call(null,k_12541));
if(cljs.core.truth_(temp__4655__auto___12543)){
var period_12544 = temp__4655__auto___12543;
var temp__4657__auto___12545__$1 = __GT_goog_interval(operator,period_12544,v_12542);
if(cljs.core.truth_(temp__4657__auto___12545__$1)){
var i_12546 = temp__4657__auto___12545__$1;
date_SINGLEQUOTE_.add(i_12546);
} else {
}
} else {
var temp__4657__auto___12547__$1 = (cljs_time.core.period_fns.cljs$core$IFn$_invoke$arity$1 ? cljs_time.core.period_fns.cljs$core$IFn$_invoke$arity$1(k_12541) : cljs_time.core.period_fns.call(null,k_12541));
if(cljs.core.truth_(temp__4657__auto___12547__$1)){
var f_12548 = temp__4657__auto___12547__$1;
(f_12548.cljs$core$IFn$_invoke$arity$3 ? f_12548.cljs$core$IFn$_invoke$arity$3(date_SINGLEQUOTE_,operator,v_12542) : f_12548.call(null,date_SINGLEQUOTE_,operator,v_12542));
} else {
}
}

var G__12549 = cljs.core.next(seq__12506_12534__$1);
var G__12550 = null;
var G__12551 = (0);
var G__12552 = (0);
seq__12506_12516 = G__12549;
chunk__12507_12517 = G__12550;
count__12508_12518 = G__12551;
i__12509_12519 = G__12552;
continue;
}
} else {
}
}
break;
}

return date_SINGLEQUOTE_;
});
});
goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$ = true;

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$year$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getYear();
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$month$arity$1 = (function (this$){
var this$__$1 = this;
return (this$__$1.getMonth() + (1));
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$day$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getDate();
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$day_of_week$arity$1 = (function (this$){
var this$__$1 = this;
var d = this$__$1.getDay();
if(cljs.core.truth_((cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(d,(0)) : cljs_time.core._EQ_.call(null,d,(0))))){
return (7);
} else {
return d;
}
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$hour$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getHours();
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$minute$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getMinutes();
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$second$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getSeconds();
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$milli$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getMilliseconds();
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$equal_QMARK_$arity$2 = (function (this$,that){
var this$__$1 = this;
return (this$__$1.getTime() === that.getTime());
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$after_QMARK_$arity$2 = (function (this$,that){
var this$__$1 = this;
return (this$__$1.getTime() > that.getTime());
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$before_QMARK_$arity$2 = (function (this$,that){
var this$__$1 = this;
return (this$__$1.getTime() < that.getTime());
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$plus_$arity$2 = (function (this$,period){
var this$__$1 = this;
return cljs_time.core.period_fn(period).call(null,cljs.core._PLUS_,this$__$1);
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$minus_$arity$2 = (function (this$,period){
var this$__$1 = this;
return cljs_time.core.period_fn(period).call(null,cljs.core._,this$__$1);
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$first_day_of_the_month_$arity$1 = (function (this$){
var this$__$1 = this;
return (new goog.date.UtcDateTime(this$__$1.getYear(),this$__$1.getMonth(),(1),(0),(0),(0),(0)));
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$last_day_of_the_month_$arity$1 = (function (this$){
var this$__$1 = this;
return cljs_time.core.minus_((new goog.date.UtcDateTime(this$__$1.getYear(),(this$__$1.getMonth() + (1)),(1),(0),(0),(0),(0))),cljs_time.core.period.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$days,(1)));
});

goog.date.UtcDateTime.prototype.cljs_time$core$DateTimeProtocol$week_number_of_year$arity$1 = (function (this$){
var this$__$1 = this;
var G__12553 = this$__$1.getYear();
var G__12554 = this$__$1.getMonth();
var G__12555 = this$__$1.getDate();
return goog.date.getWeekNumber(G__12553,G__12554,G__12555);
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$ = true;

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$year$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getYear();
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$month$arity$1 = (function (this$){
var this$__$1 = this;
return (this$__$1.getMonth() + (1));
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$day$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getDate();
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$day_of_week$arity$1 = (function (this$){
var this$__$1 = this;
var d = this$__$1.getDay();
if(cljs.core.truth_((cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(d,(0)) : cljs_time.core._EQ_.call(null,d,(0))))){
return (7);
} else {
return d;
}
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$hour$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getHours();
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$minute$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getMinutes();
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$second$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getSeconds();
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$milli$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getMilliseconds();
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$equal_QMARK_$arity$2 = (function (this$,that){
var this$__$1 = this;
return (this$__$1.getTime() === that.getTime());
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$after_QMARK_$arity$2 = (function (this$,that){
var this$__$1 = this;
return (this$__$1.getTime() > that.getTime());
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$before_QMARK_$arity$2 = (function (this$,that){
var this$__$1 = this;
return (this$__$1.getTime() < that.getTime());
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$plus_$arity$2 = (function (this$,period){
var this$__$1 = this;
return cljs_time.core.period_fn(period).call(null,cljs.core._PLUS_,this$__$1);
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$minus_$arity$2 = (function (this$,period){
var this$__$1 = this;
return cljs_time.core.period_fn(period).call(null,cljs.core._,this$__$1);
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$first_day_of_the_month_$arity$1 = (function (this$){
var this$__$1 = this;
return (new goog.date.DateTime(this$__$1.getYear(),this$__$1.getMonth(),(1),(0),(0),(0),(0)));
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$last_day_of_the_month_$arity$1 = (function (this$){
var this$__$1 = this;
return cljs_time.core.minus_((new goog.date.DateTime(this$__$1.getYear(),(this$__$1.getMonth() + (1)),(1),(0),(0),(0),(0))),cljs_time.core.period.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$days,(1)));
});

goog.date.DateTime.prototype.cljs_time$core$DateTimeProtocol$week_number_of_year$arity$1 = (function (this$){
var this$__$1 = this;
var G__12556 = this$__$1.getYear();
var G__12557 = this$__$1.getMonth();
var G__12558 = this$__$1.getDate();
return goog.date.getWeekNumber(G__12556,G__12557,G__12558);
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$ = true;

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$year$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getYear();
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$month$arity$1 = (function (this$){
var this$__$1 = this;
return (this$__$1.getMonth() + (1));
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$day$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.getDate();
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$day_of_week$arity$1 = (function (this$){
var this$__$1 = this;
var d = this$__$1.getDay();
if(cljs.core.truth_((cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(d,(0)) : cljs_time.core._EQ_.call(null,d,(0))))){
return (7);
} else {
return d;
}
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$hour$arity$1 = (function (this$){
var this$__$1 = this;
return null;
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$minute$arity$1 = (function (this$){
var this$__$1 = this;
return null;
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$second$arity$1 = (function (this$){
var this$__$1 = this;
return null;
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$milli$arity$1 = (function (this$){
var this$__$1 = this;
return null;
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$equal_QMARK_$arity$2 = (function (this$,that){
var this$__$1 = this;
return (this$__$1.getTime() === that.getTime());
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$after_QMARK_$arity$2 = (function (this$,that){
var this$__$1 = this;
return (this$__$1.getTime() > that.getTime());
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$before_QMARK_$arity$2 = (function (this$,that){
var this$__$1 = this;
return (this$__$1.getTime() < that.getTime());
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$plus_$arity$2 = (function (this$,period){
var this$__$1 = this;
return cljs_time.core.period_fn(period).call(null,cljs.core._PLUS_,this$__$1);
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$minus_$arity$2 = (function (this$,period){
var this$__$1 = this;
return cljs_time.core.period_fn(period).call(null,cljs.core._,this$__$1);
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$first_day_of_the_month_$arity$1 = (function (this$){
var this$__$1 = this;
return (new goog.date.Date(this$__$1.getYear(),this$__$1.getMonth(),(1)));
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$last_day_of_the_month_$arity$1 = (function (this$){
var this$__$1 = this;
return cljs_time.core.minus_((new goog.date.Date(this$__$1.getYear(),(this$__$1.getMonth() + (1)),(1))),cljs_time.core.period.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$days,(1)));
});

goog.date.Date.prototype.cljs_time$core$DateTimeProtocol$week_number_of_year$arity$1 = (function (this$){
var this$__$1 = this;
var G__12559 = this$__$1.getYear();
var G__12560 = this$__$1.getMonth();
var G__12561 = this$__$1.getDate();
return goog.date.getWeekNumber(G__12559,G__12560,G__12561);
});
cljs_time.core.utc = {"id": "UTC", "std_offset": (0), "names": new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["UTC"], null), "transitions": cljs.core.PersistentVector.EMPTY};
cljs_time.core.default_ms_fn = (function cljs_time$core$default_ms_fn(){
return (function (){
return (new goog.date.UtcDateTime()).getTime();
});
});
cljs_time.core.offset_ms_fn = (function cljs_time$core$offset_ms_fn(offset){
return (function (){
return ((new goog.date.UtcDateTime()).getTime() + offset);
});
});
cljs_time.core.static_ms_fn = (function cljs_time$core$static_ms_fn(ms){
return (function (){
return ms;
});
});
cljs_time.core._STAR_ms_fn_STAR_ = cljs_time.core.default_ms_fn();
/**
 * Returns a DateTime for the current instant in the UTC time zone.
 */
cljs_time.core.now = (function cljs_time$core$now(){
var G__12563 = (new goog.date.UtcDateTime());
G__12563.setTime((cljs_time.core._STAR_ms_fn_STAR_.cljs$core$IFn$_invoke$arity$0 ? cljs_time.core._STAR_ms_fn_STAR_.cljs$core$IFn$_invoke$arity$0() : cljs_time.core._STAR_ms_fn_STAR_.call(null)));

return G__12563;
});
/**
 * Returns a local DateTime for the current instant without date or time zone
 *   in the current time zone.
 */
cljs_time.core.time_now = (function cljs_time$core$time_now(){
var G__12565 = (new goog.date.DateTime());
G__12565.setTime((cljs_time.core._STAR_ms_fn_STAR_.cljs$core$IFn$_invoke$arity$0 ? cljs_time.core._STAR_ms_fn_STAR_.cljs$core$IFn$_invoke$arity$0() : cljs_time.core._STAR_ms_fn_STAR_.call(null)));

return G__12565;
});
cljs_time.core.at_midnight = (function cljs_time$core$at_midnight(datetime){
var datetime__$1 = datetime.clone();
var G__12567 = datetime__$1;
G__12567.setHours((0));

G__12567.setMinutes((0));

G__12567.setSeconds((0));

G__12567.setMilliseconds((0));

return G__12567;
});
/**
 * Returns a DateTime for today at midnight in the UTC time zone.
 */
cljs_time.core.today_at_midnight = (function cljs_time$core$today_at_midnight(){
return cljs_time.core.at_midnight(cljs_time.core.now());
});
/**
 * Returns a DateTime for the begining of the Unix epoch in the UTC time zone.
 */
cljs_time.core.epoch = (function cljs_time$core$epoch(){
var G__12569 = (new goog.date.UtcDateTime());
G__12569.setTime((0));

return G__12569;
});
/**
 * Constructs and returns a new DateTime at midnight in UTC.
 * 
 *   Specify the year, month of year, day of month. Note that month and day are
 *   1-indexed. Any number of least-significant components can be ommited, in
 *   which case they will default to 1.
 */
cljs_time.core.date_midnight = (function cljs_time$core$date_midnight(var_args){
var args12570 = [];
var len__7621__auto___12573 = arguments.length;
var i__7622__auto___12574 = (0);
while(true){
if((i__7622__auto___12574 < len__7621__auto___12573)){
args12570.push((arguments[i__7622__auto___12574]));

var G__12575 = (i__7622__auto___12574 + (1));
i__7622__auto___12574 = G__12575;
continue;
} else {
}
break;
}

var G__12572 = args12570.length;
switch (G__12572) {
case 1:
return cljs_time.core.date_midnight.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.core.date_midnight.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs_time.core.date_midnight.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12570.length)].join('')));

}
});

cljs_time.core.date_midnight.cljs$core$IFn$_invoke$arity$1 = (function (year){
return cljs_time.core.date_midnight.cljs$core$IFn$_invoke$arity$3(year,(1),(1));
});

cljs_time.core.date_midnight.cljs$core$IFn$_invoke$arity$2 = (function (year,month){
return cljs_time.core.date_midnight.cljs$core$IFn$_invoke$arity$3(year,month,(1));
});

cljs_time.core.date_midnight.cljs$core$IFn$_invoke$arity$3 = (function (year,month,day){
return (new goog.date.UtcDateTime(year,(month - (1)),day));
});

cljs_time.core.date_midnight.cljs$lang$maxFixedArity = 3;

/**
 * Constructs and returns a new DateTime in UTC.
 * 
 *   Specify the year, month of year, day of month, hour of day, minute if hour,
 *   second of minute, and millisecond of second. Note that month and day are
 *   1-indexed while hour, second, minute, and millis are 0-indexed.
 * 
 *   Any number of least-significant components can be ommited, in which case
 *   they will default to 1 or 0 as appropriate.
 */
cljs_time.core.date_time = (function cljs_time$core$date_time(var_args){
var args12577 = [];
var len__7621__auto___12580 = arguments.length;
var i__7622__auto___12581 = (0);
while(true){
if((i__7622__auto___12581 < len__7621__auto___12580)){
args12577.push((arguments[i__7622__auto___12581]));

var G__12582 = (i__7622__auto___12581 + (1));
i__7622__auto___12581 = G__12582;
continue;
} else {
}
break;
}

var G__12579 = args12577.length;
switch (G__12579) {
case 1:
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12577.length)].join('')));

}
});

cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$1 = (function (year){
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$7(year,(1),(1),(0),(0),(0),(0));
});

cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$2 = (function (year,month){
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$7(year,month,(1),(0),(0),(0),(0));
});

cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$3 = (function (year,month,day){
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$7(year,month,day,(0),(0),(0),(0));
});

cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$4 = (function (year,month,day,hour){
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$7(year,month,day,hour,(0),(0),(0));
});

cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$5 = (function (year,month,day,hour,minute){
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$7(year,month,day,hour,minute,(0),(0));
});

cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$6 = (function (year,month,day,hour,minute,second){
return cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$7(year,month,day,hour,minute,second,(0));
});

cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$7 = (function (year,month,day,hour,minute,second,millis){
return (new goog.date.UtcDateTime(year,(month - (1)),day,hour,minute,second,millis));
});

cljs_time.core.date_time.cljs$lang$maxFixedArity = 7;

/**
 * Constructs and returns a new local DateTime.
 * Specify the year, month of year, day of month, hour of day, minute of hour,
 * second of minute, and millisecond of second. Note that month and day are
 * 1-indexed while hour, second, minute, and millis are 0-indexed.
 * Any number of least-significant components can be ommited, in which case
 * they will default to 1 or 0 as appropriate.
 */
cljs_time.core.local_date_time = (function cljs_time$core$local_date_time(var_args){
var args12584 = [];
var len__7621__auto___12587 = arguments.length;
var i__7622__auto___12588 = (0);
while(true){
if((i__7622__auto___12588 < len__7621__auto___12587)){
args12584.push((arguments[i__7622__auto___12588]));

var G__12589 = (i__7622__auto___12588 + (1));
i__7622__auto___12588 = G__12589;
continue;
} else {
}
break;
}

var G__12586 = args12584.length;
switch (G__12586) {
case 1:
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12584.length)].join('')));

}
});

cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$1 = (function (year){
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$7(year,(1),(1),(0),(0),(0),(0));
});

cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$2 = (function (year,month){
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$7(year,month,(1),(0),(0),(0),(0));
});

cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$3 = (function (year,month,day){
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$7(year,month,day,(0),(0),(0),(0));
});

cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$4 = (function (year,month,day,hour){
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$7(year,month,day,hour,(0),(0),(0));
});

cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$5 = (function (year,month,day,hour,minute){
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$7(year,month,day,hour,minute,(0),(0));
});

cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$6 = (function (year,month,day,hour,minute,second){
return cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$7(year,month,day,hour,minute,second,(0));
});

cljs_time.core.local_date_time.cljs$core$IFn$_invoke$arity$7 = (function (year,month,day,hour,minute,second,millis){
return (new goog.date.DateTime(year,(month - (1)),day,hour,minute,second,millis));
});

cljs_time.core.local_date_time.cljs$lang$maxFixedArity = 7;

/**
 * Constructs and returns a new local DateTime.
 * Specify the year, month, and day. Does not deal with timezones.
 */
cljs_time.core.local_date = (function cljs_time$core$local_date(year,month,day){
return (new goog.date.Date(year,(month - (1)),day));
});
/**
 * Constructs and returns a new local DateTime representing today's date.
 *   local DateTime objects do not deal with timezones at all.
 */
cljs_time.core.today = (function cljs_time$core$today(){
var G__12592 = (new goog.date.Date());
G__12592.setTime((cljs_time.core._STAR_ms_fn_STAR_.cljs$core$IFn$_invoke$arity$0 ? cljs_time.core._STAR_ms_fn_STAR_.cljs$core$IFn$_invoke$arity$0() : cljs_time.core._STAR_ms_fn_STAR_.call(null)));

return G__12592;
});
/**
 * Returns a timezone map for the given offset, specified either in hours or
 *   hours and minutes.
 */
cljs_time.core.time_zone_for_offset = (function cljs_time$core$time_zone_for_offset(var_args){
var args12593 = [];
var len__7621__auto___12596 = arguments.length;
var i__7622__auto___12597 = (0);
while(true){
if((i__7622__auto___12597 < len__7621__auto___12596)){
args12593.push((arguments[i__7622__auto___12597]));

var G__12598 = (i__7622__auto___12597 + (1));
i__7622__auto___12597 = G__12598;
continue;
} else {
}
break;
}

var G__12595 = args12593.length;
switch (G__12595) {
case 1:
return cljs_time.core.time_zone_for_offset.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.core.time_zone_for_offset.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12593.length)].join('')));

}
});

cljs_time.core.time_zone_for_offset.cljs$core$IFn$_invoke$arity$1 = (function (hours){
return cljs_time.core.time_zone_for_offset.cljs$core$IFn$_invoke$arity$2(hours,null);
});

cljs_time.core.time_zone_for_offset.cljs$core$IFn$_invoke$arity$2 = (function (hours,minutes){
var sign = (((hours < (0)))?cljs.core.cst$kw$_DASH_:cljs.core.cst$kw$_PLUS_);
var fmt = [cljs.core.str("UTC%s%02d"),cljs.core.str((cljs.core.truth_(minutes)?":%02d":null))].join('');
var hours__$1 = (((hours < (0)))?((-1) * hours):hours);
var tz_name = (cljs.core.truth_(minutes)?cljs_time.internal.core.format.cljs$core$IFn$_invoke$arity$variadic(fmt,cljs.core.array_seq([cljs.core.name(sign),hours__$1,minutes], 0)):cljs_time.internal.core.format.cljs$core$IFn$_invoke$arity$variadic(fmt,cljs.core.array_seq([cljs.core.name(sign),hours__$1], 0)));
return cljs.core.with_meta(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$id,tz_name,cljs.core.cst$kw$offset,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [sign,hours__$1,(function (){var or__6546__auto__ = minutes;
if(cljs.core.truth_(or__6546__auto__)){
return or__6546__auto__;
} else {
return (0);
}
})(),(0)], null),cljs.core.cst$kw$rules,"-",cljs.core.cst$kw$names,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tz_name], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$cljs_DASH_time$core_SLASH_time_DASH_zone], null));
});

cljs_time.core.time_zone_for_offset.cljs$lang$maxFixedArity = 2;

/**
 * Returns the default timezone map for the current environment.
 */
cljs_time.core.default_time_zone = (function cljs_time$core$default_time_zone(){
var offset = (function (){var G__12601 = (new goog.date.DateTime());
G__12601.setTime((cljs_time.core._STAR_ms_fn_STAR_.cljs$core$IFn$_invoke$arity$0 ? cljs_time.core._STAR_ms_fn_STAR_.cljs$core$IFn$_invoke$arity$0() : cljs_time.core._STAR_ms_fn_STAR_.call(null)));

return G__12601;
})().getTimezoneOffset();
var hours = (((-1) * offset) / (60));
return cljs_time.core.time_zone_for_offset.cljs$core$IFn$_invoke$arity$2((hours | (0)),cljs.core.mod(hours,(1)));
});
/**
 * Assuming `dt` is in the UTC timezone, returns a DateTime
 *   corresponding to the same absolute instant in time as the given
 *   DateTime, but with calendar fields corresponding to the default
 *   (local) timezone.
 */
cljs_time.core.to_default_time_zone = (function cljs_time$core$to_default_time_zone(dt){
return (new goog.date.DateTime(dt));
});
/**
 * Assuming `dt` is in the Local timezone, returns a UtcDateTime
 *   corresponding to the same absolute instant in time as the given
 *   DateTime, but with calendar fields corresponding to the UTC
 *   timezone.
 */
cljs_time.core.to_utc_time_zone = (function cljs_time$core$to_utc_time_zone(dt){
var G__12603 = dt.getTime();
return goog.date.UtcDateTime.fromTimestamp(G__12603);
});
/**
 * Assuming `dt` is in the UTC timezone, returns a DateTime
 *   corresponding to the same point in calendar time as the given
 *   DateTime, but for a correspondingly different absolute instant in
 *   time in the default (local) timezone.
 * 
 *   Note: This implementation uses the ECMAScript 5.1 implementation which
 *   trades some historical daylight savings transition accuracy for simplicity.
 *   see http://es5.github.io/#x15.9.1.8
 *   
 */
cljs_time.core.from_default_time_zone = (function cljs_time$core$from_default_time_zone(dt){
return (new goog.date.DateTime(dt.getYear(),dt.getMonth(),dt.getDate(),dt.getHours(),dt.getMinutes(),dt.getSeconds(),dt.getMilliseconds()));
});
/**
 * Assuming `dt` is in the local timezone, returns a UtcDateTime
 *   corresponding to the same point in calendar time as the given
 *   DateTime, but for a correspondingly different absolute instant in
 *   time in the UTC timezone.
 * 
 *   Note: This implementation uses the ECMAScript 5.1 implementation which
 *   trades some historical daylight savings transition accuracy for simplicity.
 *   see http://es5.github.io/#x15.9.1.8
 *   
 */
cljs_time.core.from_utc_time_zone = (function cljs_time$core$from_utc_time_zone(dt){
var year = dt.getYear();
var month = dt.getMonth();
var date = dt.getDate();
if(cljs.core.truth_((function (){var G__12606 = goog.date.Date;
var G__12607 = cljs.core.type(dt);
return (cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__12606,G__12607) : cljs_time.core._EQ_.call(null,G__12606,G__12607));
})())){
return (new goog.date.UtcDateTime(year,month,date));
} else {
return (new goog.date.UtcDateTime(year,month,date,dt.getHours(),dt.getMinutes(),dt.getSeconds(),dt.getMilliseconds()));
}
});
/**
 * Given a number, returns a Period representing that many years.
 *   Without an argument, returns a Period representing only years.
 */
cljs_time.core.years = (function cljs_time$core$years(var_args){
var args12608 = [];
var len__7621__auto___12611 = arguments.length;
var i__7622__auto___12612 = (0);
while(true){
if((i__7622__auto___12612 < len__7621__auto___12611)){
args12608.push((arguments[i__7622__auto___12612]));

var G__12613 = (i__7622__auto___12612 + (1));
i__7622__auto___12612 = G__12613;
continue;
} else {
}
break;
}

var G__12610 = args12608.length;
switch (G__12610) {
case 0:
return cljs_time.core.years.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs_time.core.years.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12608.length)].join('')));

}
});

cljs_time.core.years.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs_time.core.years.cljs$core$IFn$_invoke$arity$1(null);
});

cljs_time.core.years.cljs$core$IFn$_invoke$arity$1 = (function (n){
return cljs_time.core.period.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$years,n);
});

cljs_time.core.years.cljs$lang$maxFixedArity = 1;

/**
 * Given a number, returns a Period representing that many months.
 *   Without an argument, returns a Period representing only months.
 */
cljs_time.core.months = (function cljs_time$core$months(var_args){
var args12615 = [];
var len__7621__auto___12618 = arguments.length;
var i__7622__auto___12619 = (0);
while(true){
if((i__7622__auto___12619 < len__7621__auto___12618)){
args12615.push((arguments[i__7622__auto___12619]));

var G__12620 = (i__7622__auto___12619 + (1));
i__7622__auto___12619 = G__12620;
continue;
} else {
}
break;
}

var G__12617 = args12615.length;
switch (G__12617) {
case 0:
return cljs_time.core.months.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs_time.core.months.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12615.length)].join('')));

}
});

cljs_time.core.months.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs_time.core.months.cljs$core$IFn$_invoke$arity$1(null);
});

cljs_time.core.months.cljs$core$IFn$_invoke$arity$1 = (function (n){
return cljs_time.core.period.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$months,n);
});

cljs_time.core.months.cljs$lang$maxFixedArity = 1;

/**
 * Given a number, returns a Period representing that many weeks.
 *   Without an argument, returns a Period representing only weeks.
 */
cljs_time.core.weeks = (function cljs_time$core$weeks(var_args){
var args12622 = [];
var len__7621__auto___12625 = arguments.length;
var i__7622__auto___12626 = (0);
while(true){
if((i__7622__auto___12626 < len__7621__auto___12625)){
args12622.push((arguments[i__7622__auto___12626]));

var G__12627 = (i__7622__auto___12626 + (1));
i__7622__auto___12626 = G__12627;
continue;
} else {
}
break;
}

var G__12624 = args12622.length;
switch (G__12624) {
case 0:
return cljs_time.core.weeks.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs_time.core.weeks.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12622.length)].join('')));

}
});

cljs_time.core.weeks.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs_time.core.weeks.cljs$core$IFn$_invoke$arity$1(null);
});

cljs_time.core.weeks.cljs$core$IFn$_invoke$arity$1 = (function (n){
return cljs_time.core.period.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$weeks,n);
});

cljs_time.core.weeks.cljs$lang$maxFixedArity = 1;

/**
 * Given a number, returns a Period representing that many days.
 *   Without an argument, returns a Period representing only days.
 */
cljs_time.core.days = (function cljs_time$core$days(var_args){
var args12629 = [];
var len__7621__auto___12632 = arguments.length;
var i__7622__auto___12633 = (0);
while(true){
if((i__7622__auto___12633 < len__7621__auto___12632)){
args12629.push((arguments[i__7622__auto___12633]));

var G__12634 = (i__7622__auto___12633 + (1));
i__7622__auto___12633 = G__12634;
continue;
} else {
}
break;
}

var G__12631 = args12629.length;
switch (G__12631) {
case 0:
return cljs_time.core.days.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs_time.core.days.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12629.length)].join('')));

}
});

cljs_time.core.days.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs_time.core.days.cljs$core$IFn$_invoke$arity$1(null);
});

cljs_time.core.days.cljs$core$IFn$_invoke$arity$1 = (function (n){
return cljs_time.core.period.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$days,n);
});

cljs_time.core.days.cljs$lang$maxFixedArity = 1;

/**
 * Given a number, returns a Period representing that many hours.
 *   Without an argument, returns a Period representing only hours.
 */
cljs_time.core.hours = (function cljs_time$core$hours(var_args){
var args12636 = [];
var len__7621__auto___12639 = arguments.length;
var i__7622__auto___12640 = (0);
while(true){
if((i__7622__auto___12640 < len__7621__auto___12639)){
args12636.push((arguments[i__7622__auto___12640]));

var G__12641 = (i__7622__auto___12640 + (1));
i__7622__auto___12640 = G__12641;
continue;
} else {
}
break;
}

var G__12638 = args12636.length;
switch (G__12638) {
case 0:
return cljs_time.core.hours.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs_time.core.hours.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12636.length)].join('')));

}
});

cljs_time.core.hours.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs_time.core.hours.cljs$core$IFn$_invoke$arity$1(null);
});

cljs_time.core.hours.cljs$core$IFn$_invoke$arity$1 = (function (n){
return cljs_time.core.period.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$hours,n);
});

cljs_time.core.hours.cljs$lang$maxFixedArity = 1;

/**
 * Given a number, returns a Period representing that many minutes.
 *   Without an argument, returns a Period representing only minutes.
 */
cljs_time.core.minutes = (function cljs_time$core$minutes(var_args){
var args12643 = [];
var len__7621__auto___12646 = arguments.length;
var i__7622__auto___12647 = (0);
while(true){
if((i__7622__auto___12647 < len__7621__auto___12646)){
args12643.push((arguments[i__7622__auto___12647]));

var G__12648 = (i__7622__auto___12647 + (1));
i__7622__auto___12647 = G__12648;
continue;
} else {
}
break;
}

var G__12645 = args12643.length;
switch (G__12645) {
case 0:
return cljs_time.core.minutes.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs_time.core.minutes.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12643.length)].join('')));

}
});

cljs_time.core.minutes.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs_time.core.minutes.cljs$core$IFn$_invoke$arity$1(null);
});

cljs_time.core.minutes.cljs$core$IFn$_invoke$arity$1 = (function (n){
return cljs_time.core.period.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$minutes,n);
});

cljs_time.core.minutes.cljs$lang$maxFixedArity = 1;

/**
 * Given a number, returns a Period representing that many seconds.
 *   Without an argument, returns a Period representing only seconds.
 */
cljs_time.core.seconds = (function cljs_time$core$seconds(var_args){
var args12650 = [];
var len__7621__auto___12653 = arguments.length;
var i__7622__auto___12654 = (0);
while(true){
if((i__7622__auto___12654 < len__7621__auto___12653)){
args12650.push((arguments[i__7622__auto___12654]));

var G__12655 = (i__7622__auto___12654 + (1));
i__7622__auto___12654 = G__12655;
continue;
} else {
}
break;
}

var G__12652 = args12650.length;
switch (G__12652) {
case 0:
return cljs_time.core.seconds.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs_time.core.seconds.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12650.length)].join('')));

}
});

cljs_time.core.seconds.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs_time.core.seconds.cljs$core$IFn$_invoke$arity$1(null);
});

cljs_time.core.seconds.cljs$core$IFn$_invoke$arity$1 = (function (n){
return cljs_time.core.period.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$seconds,n);
});

cljs_time.core.seconds.cljs$lang$maxFixedArity = 1;

/**
 * Given a number, returns a Period representing that many milliseconds.
 *   Without an argument, returns a Period representing only milliseconds.
 */
cljs_time.core.millis = (function cljs_time$core$millis(var_args){
var args12657 = [];
var len__7621__auto___12660 = arguments.length;
var i__7622__auto___12661 = (0);
while(true){
if((i__7622__auto___12661 < len__7621__auto___12660)){
args12657.push((arguments[i__7622__auto___12661]));

var G__12662 = (i__7622__auto___12661 + (1));
i__7622__auto___12661 = G__12662;
continue;
} else {
}
break;
}

var G__12659 = args12657.length;
switch (G__12659) {
case 0:
return cljs_time.core.millis.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs_time.core.millis.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12657.length)].join('')));

}
});

cljs_time.core.millis.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs_time.core.millis.cljs$core$IFn$_invoke$arity$1(null);
});

cljs_time.core.millis.cljs$core$IFn$_invoke$arity$1 = (function (n){
return cljs_time.core.period.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$millis,n);
});

cljs_time.core.millis.cljs$lang$maxFixedArity = 1;

/**
 * Returns a new date/time corresponding to the given date/time moved
 *   forwards by the given Period(s).
 */
cljs_time.core.plus = (function cljs_time$core$plus(var_args){
var args12664 = [];
var len__7621__auto___12670 = arguments.length;
var i__7622__auto___12671 = (0);
while(true){
if((i__7622__auto___12671 < len__7621__auto___12670)){
args12664.push((arguments[i__7622__auto___12671]));

var G__12672 = (i__7622__auto___12671 + (1));
i__7622__auto___12671 = G__12672;
continue;
} else {
}
break;
}

var G__12669 = args12664.length;
switch (G__12669) {
case 2:
return cljs_time.core.plus.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7640__auto__ = (new cljs.core.IndexedSeq(args12664.slice((2)),(0),null));
return cljs_time.core.plus.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7640__auto__);

}
});

cljs_time.core.plus.cljs$core$IFn$_invoke$arity$2 = (function (dt,p){
return cljs_time.core.plus_(dt,p);
});

cljs_time.core.plus.cljs$core$IFn$_invoke$arity$variadic = (function (dt,p,ps){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs_time.core.plus_,cljs_time.core.plus_(dt,p),ps);
});

cljs_time.core.plus.cljs$lang$applyTo = (function (seq12665){
var G__12666 = cljs.core.first(seq12665);
var seq12665__$1 = cljs.core.next(seq12665);
var G__12667 = cljs.core.first(seq12665__$1);
var seq12665__$2 = cljs.core.next(seq12665__$1);
return cljs_time.core.plus.cljs$core$IFn$_invoke$arity$variadic(G__12666,G__12667,seq12665__$2);
});

cljs_time.core.plus.cljs$lang$maxFixedArity = (2);

/**
 * Returns a new date/time object corresponding to the given date/time
 *   moved backwards by the given Period(s).
 */
cljs_time.core.minus = (function cljs_time$core$minus(var_args){
var args12674 = [];
var len__7621__auto___12680 = arguments.length;
var i__7622__auto___12681 = (0);
while(true){
if((i__7622__auto___12681 < len__7621__auto___12680)){
args12674.push((arguments[i__7622__auto___12681]));

var G__12682 = (i__7622__auto___12681 + (1));
i__7622__auto___12681 = G__12682;
continue;
} else {
}
break;
}

var G__12679 = args12674.length;
switch (G__12679) {
case 2:
return cljs_time.core.minus.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7640__auto__ = (new cljs.core.IndexedSeq(args12674.slice((2)),(0),null));
return cljs_time.core.minus.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7640__auto__);

}
});

cljs_time.core.minus.cljs$core$IFn$_invoke$arity$2 = (function (dt,p){
return cljs_time.core.minus_(dt,p);
});

cljs_time.core.minus.cljs$core$IFn$_invoke$arity$variadic = (function (dt,p,ps){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs_time.core.minus_,cljs_time.core.minus_(dt,p),ps);
});

cljs_time.core.minus.cljs$lang$applyTo = (function (seq12675){
var G__12676 = cljs.core.first(seq12675);
var seq12675__$1 = cljs.core.next(seq12675);
var G__12677 = cljs.core.first(seq12675__$1);
var seq12675__$2 = cljs.core.next(seq12675__$1);
return cljs_time.core.minus.cljs$core$IFn$_invoke$arity$variadic(G__12676,G__12677,seq12675__$2);
});

cljs_time.core.minus.cljs$lang$maxFixedArity = (2);

/**
 * Returns a DateTime a supplied period before the present.
 * 
 *   e.g. `(-> 5 years ago)`
 */
cljs_time.core.ago = (function cljs_time$core$ago(period){
return cljs_time.core.minus.cljs$core$IFn$_invoke$arity$2(cljs_time.core.now(),period);
});
/**
 * Returns a DateTime for yesterday relative to now
 */
cljs_time.core.yesterday = (function cljs_time$core$yesterday(){
return cljs_time.core.ago(cljs_time.core.days.cljs$core$IFn$_invoke$arity$1((1)));
});
/**
 * Returns a DateTime a supplied period after the present.
 *   e.g. `(-> 30 minutes from-now)`
 */
cljs_time.core.from_now = (function cljs_time$core$from_now(period){
return cljs_time.core.plus.cljs$core$IFn$_invoke$arity$2(cljs_time.core.now(),period);
});
/**
 * Returns the earliest of the supplied DateTimes
 */
cljs_time.core.earliest = (function cljs_time$core$earliest(var_args){
var args12684 = [];
var len__7621__auto___12687 = arguments.length;
var i__7622__auto___12688 = (0);
while(true){
if((i__7622__auto___12688 < len__7621__auto___12687)){
args12684.push((arguments[i__7622__auto___12688]));

var G__12689 = (i__7622__auto___12688 + (1));
i__7622__auto___12688 = G__12689;
continue;
} else {
}
break;
}

var G__12686 = args12684.length;
switch (G__12686) {
case 2:
return cljs_time.core.earliest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return cljs_time.core.earliest.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12684.length)].join('')));

}
});

cljs_time.core.earliest.cljs$core$IFn$_invoke$arity$2 = (function (dt1,dt2){
if(cljs.core.truth_(cljs_time.core.before_QMARK_(dt1,dt2))){
return dt1;
} else {
return dt2;
}
});

cljs_time.core.earliest.cljs$core$IFn$_invoke$arity$1 = (function (dts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs_time.core.earliest,dts);
});

cljs_time.core.earliest.cljs$lang$maxFixedArity = 2;

/**
 * Returns the latest of the supplied DateTimes
 */
cljs_time.core.latest = (function cljs_time$core$latest(var_args){
var args12691 = [];
var len__7621__auto___12694 = arguments.length;
var i__7622__auto___12695 = (0);
while(true){
if((i__7622__auto___12695 < len__7621__auto___12694)){
args12691.push((arguments[i__7622__auto___12695]));

var G__12696 = (i__7622__auto___12695 + (1));
i__7622__auto___12695 = G__12696;
continue;
} else {
}
break;
}

var G__12693 = args12691.length;
switch (G__12693) {
case 2:
return cljs_time.core.latest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return cljs_time.core.latest.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12691.length)].join('')));

}
});

cljs_time.core.latest.cljs$core$IFn$_invoke$arity$2 = (function (dt1,dt2){
if(cljs.core.truth_(cljs_time.core.after_QMARK_(dt1,dt2))){
return dt1;
} else {
return dt2;
}
});

cljs_time.core.latest.cljs$core$IFn$_invoke$arity$1 = (function (dts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs_time.core.latest,dts);
});

cljs_time.core.latest.cljs$lang$maxFixedArity = 2;

/**
 * Returns the start DateTime of an Interval.
 */
cljs_time.core.start = (function cljs_time$core$start(in$){
return cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(in$);
});
/**
 * Returns the end DateTime of an Interval.
 */
cljs_time.core.end = (function cljs_time$core$end(in$){
return cljs.core.cst$kw$end.cljs$core$IFn$_invoke$arity$1(in$);
});
/**
 * Returns an Interval with an end DateTime the specified Period after the end
 *   of the given Interval
 */
cljs_time.core.extend = (function cljs_time$core$extend(var_args){
var args__7628__auto__ = [];
var len__7621__auto___12700 = arguments.length;
var i__7622__auto___12701 = (0);
while(true){
if((i__7622__auto___12701 < len__7621__auto___12700)){
args__7628__auto__.push((arguments[i__7622__auto___12701]));

var G__12702 = (i__7622__auto___12701 + (1));
i__7622__auto___12701 = G__12702;
continue;
} else {
}
break;
}

var argseq__7629__auto__ = ((((1) < args__7628__auto__.length))?(new cljs.core.IndexedSeq(args__7628__auto__.slice((1)),(0),null)):null);
return cljs_time.core.extend.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7629__auto__);
});

cljs_time.core.extend.cljs$core$IFn$_invoke$arity$variadic = (function (in$,by){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(in$,cljs.core.cst$kw$end,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs_time.core.plus,cljs_time.core.end(in$),by));
});

cljs_time.core.extend.cljs$lang$maxFixedArity = (1);

cljs_time.core.extend.cljs$lang$applyTo = (function (seq12698){
var G__12699 = cljs.core.first(seq12698);
var seq12698__$1 = cljs.core.next(seq12698);
return cljs_time.core.extend.cljs$core$IFn$_invoke$arity$variadic(G__12699,seq12698__$1);
});

cljs_time.core.month_range = (function cljs_time$core$month_range(p__12705){
var map__12708 = p__12705;
var map__12708__$1 = ((((!((map__12708 == null)))?((((map__12708.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12708.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12708):map__12708);
var start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12708__$1,cljs.core.cst$kw$start);
var end = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12708__$1,cljs.core.cst$kw$end);
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (map__12708,map__12708__$1,start,end){
return (function (p1__12704_SHARP_){
return cljs.core.not(cljs_time.core.after_QMARK_(p1__12704_SHARP_,end));
});})(map__12708,map__12708__$1,start,end))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__12708,map__12708__$1,start,end){
return (function (p1__12703_SHARP_){
return cljs_time.core.plus.cljs$core$IFn$_invoke$arity$2(start,cljs_time.core.months.cljs$core$IFn$_invoke$arity$1((p1__12703_SHARP_ + (1))));
});})(map__12708,map__12708__$1,start,end))
,cljs.core.range.cljs$core$IFn$_invoke$arity$0()));
});
cljs_time.core.total_days_in_whole_months = (function cljs_time$core$total_days_in_whole_months(interval){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__12710_SHARP_){
return p1__12710_SHARP_.getNumberOfDaysInMonth();
}),cljs_time.core.month_range(interval));
});
/**
 * Returns the number of months in the given Interval.
 * 
 *   For example, the interval 2nd Jan 2012 midnight to 2nd Feb 2012 midnight,
 *   returns 1 month.
 * 
 *   Likewise, 29th Dec 2011 midnight to 29th Feb 2012 midnight returns 2 months.
 * 
 *   But also, 31st Dec 2011 midnight to 29th Feb 2012 midnight returns 2 months.
 * 
 *   And, 28th Dec 2012 midnight to 28th Feb 2013 midnight returns 2 months.
 */
cljs_time.core.in_months_ = (function cljs_time$core$in_months_(p__12711){
var map__12714 = p__12711;
var map__12714__$1 = ((((!((map__12714 == null)))?((((map__12714.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12714.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12714):map__12714);
var interval = map__12714__$1;
var start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12714__$1,cljs.core.cst$kw$start);
var end = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12714__$1,cljs.core.cst$kw$end);
return cljs.core.count(cljs_time.core.total_days_in_whole_months(interval));
});
/**
 * Returns the number of standard years in the given Interval.
 */
cljs_time.core.in_years_ = (function cljs_time$core$in_years_(p__12716){
var map__12719 = p__12716;
var map__12719__$1 = ((((!((map__12719 == null)))?((((map__12719.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12719.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12719):map__12719);
var start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12719__$1,cljs.core.cst$kw$start);
var end = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12719__$1,cljs.core.cst$kw$end);
var sm = cljs_time.core.month(start);
var sd = cljs_time.core.day(start);
var em = cljs_time.core.month(end);
var ed = cljs_time.core.day(end);
var d1 = (cljs.core.truth_((function (){var and__6534__auto__ = (cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(sm,(2)) : cljs_time.core._EQ_.call(null,sm,(2)));
if(cljs.core.truth_(and__6534__auto__)){
var and__6534__auto____$1 = (cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(sd,(29)) : cljs_time.core._EQ_.call(null,sd,(29)));
if(cljs.core.truth_(and__6534__auto____$1)){
var and__6534__auto____$2 = (cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(em,(2)) : cljs_time.core._EQ_.call(null,em,(2)));
if(cljs.core.truth_(and__6534__auto____$2)){
return (cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(ed,(28)) : cljs_time.core._EQ_.call(null,ed,(28)));
} else {
return and__6534__auto____$2;
}
} else {
return and__6534__auto____$1;
}
} else {
return and__6534__auto__;
}
})())?(0):(cljs.core.truth_(cljs_time.core.before_QMARK_(cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$3(cljs_time.core.year(start),sm,sd),cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$3(cljs_time.core.year(start),em,ed)))?(0):(cljs.core.truth_(cljs_time.core.after_QMARK_(cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$3(cljs_time.core.year(start),sm,sd),cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$3(cljs_time.core.year(start),em,ed)))?(1):(0)
)));
return ((cljs_time.core.year(end) - cljs_time.core.year(start)) - d1);
});
cljs_time.core.conversion_error = (function cljs_time$core$conversion_error(from,to){
var from__$1 = clojure.string.capitalize(cljs.core.name(from));
var to__$1 = cljs.core.name(to);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(cljs_time.internal.core.format.cljs$core$IFn$_invoke$arity$variadic("%s cannot be converted to %s",cljs.core.array_seq([from__$1,to__$1], 0)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$unsupported_DASH_operation], null));
});
cljs_time.core.Period.prototype.cljs_time$core$InTimeUnitProtocol$ = true;

cljs_time.core.Period.prototype.cljs_time$core$InTimeUnitProtocol$in_millis$arity$1 = (function (p__12721){
var map__12722 = p__12721;
var map__12722__$1 = ((((!((map__12722 == null)))?((((map__12722.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12722.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12722):map__12722);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12722__$1,cljs.core.cst$kw$millis);
var seconds = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12722__$1,cljs.core.cst$kw$seconds);
var minutes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12722__$1,cljs.core.cst$kw$minutes);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12722__$1,cljs.core.cst$kw$hours);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12722__$1,cljs.core.cst$kw$days);
var weeks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12722__$1,cljs.core.cst$kw$weeks);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12722__$1,cljs.core.cst$kw$months);
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12722__$1,cljs.core.cst$kw$years);
var map__12724 = this;
var map__12724__$1 = ((((!((map__12724 == null)))?((((map__12724.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12724.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12724):map__12724);
var millis__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12724__$1,cljs.core.cst$kw$millis);
var seconds__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12724__$1,cljs.core.cst$kw$seconds);
var minutes__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12724__$1,cljs.core.cst$kw$minutes);
var hours__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12724__$1,cljs.core.cst$kw$hours);
var days__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12724__$1,cljs.core.cst$kw$days);
var weeks__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12724__$1,cljs.core.cst$kw$weeks);
var months__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12724__$1,cljs.core.cst$kw$months);
var years__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12724__$1,cljs.core.cst$kw$years);
if(cljs.core.truth_(months__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$months,cljs.core.cst$kw$millis);
} else {
if(cljs.core.truth_(years__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$years,cljs.core.cst$kw$millis);
} else {
return (((((millis__$1 + (seconds__$1 * (1000))) + ((minutes__$1 * (60)) * (1000))) + (((hours__$1 * (60)) * (60)) * (1000))) + ((((days__$1 * (24)) * (60)) * (60)) * (1000))) + (((((weeks__$1 * (7)) * (24)) * (60)) * (60)) * (1000)));

}
}
});

cljs_time.core.Period.prototype.cljs_time$core$InTimeUnitProtocol$in_seconds$arity$1 = (function (this$){
var this$__$1 = this;
return ((cljs_time.core.in_millis(this$__$1) / (1000)) | (0));
});

cljs_time.core.Period.prototype.cljs_time$core$InTimeUnitProtocol$in_minutes$arity$1 = (function (this$){
var this$__$1 = this;
return ((cljs_time.core.in_seconds(this$__$1) / (60)) | (0));
});

cljs_time.core.Period.prototype.cljs_time$core$InTimeUnitProtocol$in_hours$arity$1 = (function (this$){
var this$__$1 = this;
return ((cljs_time.core.in_minutes(this$__$1) / (60)) | (0));
});

cljs_time.core.Period.prototype.cljs_time$core$InTimeUnitProtocol$in_days$arity$1 = (function (this$){
var this$__$1 = this;
return ((cljs_time.core.in_hours(this$__$1) / (24)) | (0));
});

cljs_time.core.Period.prototype.cljs_time$core$InTimeUnitProtocol$in_weeks$arity$1 = (function (this$){
var this$__$1 = this;
return ((cljs_time.core.in_days(this$__$1) / (7)) | (0));
});

cljs_time.core.Period.prototype.cljs_time$core$InTimeUnitProtocol$in_months$arity$1 = (function (p__12726){
var map__12727 = p__12726;
var map__12727__$1 = ((((!((map__12727 == null)))?((((map__12727.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12727.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12727):map__12727);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12727__$1,cljs.core.cst$kw$millis);
var seconds = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12727__$1,cljs.core.cst$kw$seconds);
var minutes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12727__$1,cljs.core.cst$kw$minutes);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12727__$1,cljs.core.cst$kw$hours);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12727__$1,cljs.core.cst$kw$days);
var weeks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12727__$1,cljs.core.cst$kw$weeks);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12727__$1,cljs.core.cst$kw$months);
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12727__$1,cljs.core.cst$kw$years);
var map__12729 = this;
var map__12729__$1 = ((((!((map__12729 == null)))?((((map__12729.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12729.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12729):map__12729);
var millis__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12729__$1,cljs.core.cst$kw$millis);
var seconds__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12729__$1,cljs.core.cst$kw$seconds);
var minutes__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12729__$1,cljs.core.cst$kw$minutes);
var hours__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12729__$1,cljs.core.cst$kw$hours);
var days__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12729__$1,cljs.core.cst$kw$days);
var weeks__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12729__$1,cljs.core.cst$kw$weeks);
var months__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12729__$1,cljs.core.cst$kw$months);
var years__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12729__$1,cljs.core.cst$kw$years);
if(cljs.core.truth_(millis__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$millis,cljs.core.cst$kw$months);
} else {
if(cljs.core.truth_(seconds__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$seconds,cljs.core.cst$kw$months);
} else {
if(cljs.core.truth_(minutes__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$minutes,cljs.core.cst$kw$months);
} else {
if(cljs.core.truth_(hours__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$hours,cljs.core.cst$kw$months);
} else {
if(cljs.core.truth_(days__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$days,cljs.core.cst$kw$months);
} else {
if(cljs.core.truth_(weeks__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$weeks,cljs.core.cst$kw$months);
} else {
if(cljs.core.truth_(months__$1)){
return (months__$1 + ((function (){var or__6546__auto__ = years__$1;
if(cljs.core.truth_(or__6546__auto__)){
return or__6546__auto__;
} else {
return (0);
}
})() * (12)));
} else {
if(cljs.core.truth_(years__$1)){
return (years__$1 * (12));
} else {
return null;
}
}
}
}
}
}
}
}
});

cljs_time.core.Period.prototype.cljs_time$core$InTimeUnitProtocol$in_years$arity$1 = (function (p__12731){
var map__12732 = p__12731;
var map__12732__$1 = ((((!((map__12732 == null)))?((((map__12732.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12732.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12732):map__12732);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12732__$1,cljs.core.cst$kw$millis);
var seconds = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12732__$1,cljs.core.cst$kw$seconds);
var minutes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12732__$1,cljs.core.cst$kw$minutes);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12732__$1,cljs.core.cst$kw$hours);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12732__$1,cljs.core.cst$kw$days);
var weeks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12732__$1,cljs.core.cst$kw$weeks);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12732__$1,cljs.core.cst$kw$months);
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12732__$1,cljs.core.cst$kw$years);
var map__12734 = this;
var map__12734__$1 = ((((!((map__12734 == null)))?((((map__12734.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12734.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12734):map__12734);
var millis__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12734__$1,cljs.core.cst$kw$millis);
var seconds__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12734__$1,cljs.core.cst$kw$seconds);
var minutes__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12734__$1,cljs.core.cst$kw$minutes);
var hours__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12734__$1,cljs.core.cst$kw$hours);
var days__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12734__$1,cljs.core.cst$kw$days);
var weeks__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12734__$1,cljs.core.cst$kw$weeks);
var months__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12734__$1,cljs.core.cst$kw$months);
var years__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12734__$1,cljs.core.cst$kw$years);
if(cljs.core.truth_(millis__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$millis,cljs.core.cst$kw$years);
} else {
if(cljs.core.truth_(seconds__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$seconds,cljs.core.cst$kw$years);
} else {
if(cljs.core.truth_(minutes__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$minutes,cljs.core.cst$kw$years);
} else {
if(cljs.core.truth_(hours__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$hours,cljs.core.cst$kw$years);
} else {
if(cljs.core.truth_(days__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$days,cljs.core.cst$kw$years);
} else {
if(cljs.core.truth_(weeks__$1)){
return cljs_time.core.conversion_error(cljs.core.cst$kw$weeks,cljs.core.cst$kw$years);
} else {
if(cljs.core.truth_(months__$1)){
return (((months__$1 / (12)) + years__$1) | (0));
} else {
if(cljs.core.truth_(years__$1)){
return years__$1;
} else {
return null;
}
}
}
}
}
}
}
}
});

cljs_time.core.Interval.prototype.cljs_time$core$InTimeUnitProtocol$ = true;

cljs_time.core.Interval.prototype.cljs_time$core$InTimeUnitProtocol$in_millis$arity$1 = (function (p__12736){
var map__12737 = p__12736;
var map__12737__$1 = ((((!((map__12737 == null)))?((((map__12737.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12737.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12737):map__12737);
var start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12737__$1,cljs.core.cst$kw$start);
var end = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12737__$1,cljs.core.cst$kw$end);
var map__12739 = this;
var map__12739__$1 = ((((!((map__12739 == null)))?((((map__12739.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12739.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12739):map__12739);
var start__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12739__$1,cljs.core.cst$kw$start);
var end__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12739__$1,cljs.core.cst$kw$end);
return (end__$1.getTime() - start__$1.getTime());
});

cljs_time.core.Interval.prototype.cljs_time$core$InTimeUnitProtocol$in_seconds$arity$1 = (function (this$){
var this$__$1 = this;
return ((cljs_time.core.in_millis(this$__$1) / (1000)) | (0));
});

cljs_time.core.Interval.prototype.cljs_time$core$InTimeUnitProtocol$in_minutes$arity$1 = (function (this$){
var this$__$1 = this;
return ((cljs_time.core.in_seconds(this$__$1) / (60)) | (0));
});

cljs_time.core.Interval.prototype.cljs_time$core$InTimeUnitProtocol$in_hours$arity$1 = (function (this$){
var this$__$1 = this;
return ((cljs_time.core.in_minutes(this$__$1) / (60)) | (0));
});

cljs_time.core.Interval.prototype.cljs_time$core$InTimeUnitProtocol$in_days$arity$1 = (function (this$){
var this$__$1 = this;
return ((cljs_time.core.in_hours(this$__$1) / (24)) | (0));
});

cljs_time.core.Interval.prototype.cljs_time$core$InTimeUnitProtocol$in_weeks$arity$1 = (function (this$){
var this$__$1 = this;
return ((cljs_time.core.in_days(this$__$1) / (7)) | (0));
});

cljs_time.core.Interval.prototype.cljs_time$core$InTimeUnitProtocol$in_months$arity$1 = (function (this$){
var this$__$1 = this;
return cljs_time.core.in_months_(this$__$1);
});

cljs_time.core.Interval.prototype.cljs_time$core$InTimeUnitProtocol$in_years$arity$1 = (function (this$){
var this$__$1 = this;
return cljs_time.core.in_years_(this$__$1);
});
/**
 * With 2 arguments: Returns true if the given Interval contains the given
 *   DateTime. Note that if the DateTime is exactly equal to the
 *   end of the interval, this function returns false.
 * 
 *   With 3 arguments: Returns true if the start DateTime is
 *   equal to or before and the end DateTime is equal to or after the test
 *   DateTime.
 */
cljs_time.core.within_QMARK_ = (function cljs_time$core$within_QMARK_(var_args){
var args12741 = [];
var len__7621__auto___12747 = arguments.length;
var i__7622__auto___12748 = (0);
while(true){
if((i__7622__auto___12748 < len__7621__auto___12747)){
args12741.push((arguments[i__7622__auto___12748]));

var G__12749 = (i__7622__auto___12748 + (1));
i__7622__auto___12748 = G__12749;
continue;
} else {
}
break;
}

var G__12743 = args12741.length;
switch (G__12743) {
case 2:
return cljs_time.core.within_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs_time.core.within_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12741.length)].join('')));

}
});

cljs_time.core.within_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (p__12744,date){
var map__12745 = p__12744;
var map__12745__$1 = ((((!((map__12745 == null)))?((((map__12745.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12745.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12745):map__12745);
var start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12745__$1,cljs.core.cst$kw$start);
var end = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12745__$1,cljs.core.cst$kw$end);
return cljs_time.core.within_QMARK_.cljs$core$IFn$_invoke$arity$3(start,end,date);
});

cljs_time.core.within_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (start,end,date){
var or__6546__auto__ = (cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(start,date) : cljs_time.core._EQ_.call(null,start,date));
if(cljs.core.truth_(or__6546__auto__)){
return or__6546__auto__;
} else {
var and__6534__auto__ = cljs_time.core.before_QMARK_(start,date);
if(cljs.core.truth_(and__6534__auto__)){
return cljs_time.core.after_QMARK_(end,date);
} else {
return and__6534__auto__;
}
}
});

cljs_time.core.within_QMARK_.cljs$lang$maxFixedArity = 3;

/**
 * With 2 arguments: Returns true of the two given Intervals overlap.
 *   Note that intervals that satisfy abuts? do not satisfy overlaps?
 * 
 *   With 4 arguments: Returns true if the range specified by start-a and end-a
 *   overlaps with the range specified by start-b and end-b.
 */
cljs_time.core.overlaps_QMARK_ = (function cljs_time$core$overlaps_QMARK_(var_args){
var args12751 = [];
var len__7621__auto___12760 = arguments.length;
var i__7622__auto___12761 = (0);
while(true){
if((i__7622__auto___12761 < len__7621__auto___12760)){
args12751.push((arguments[i__7622__auto___12761]));

var G__12762 = (i__7622__auto___12761 + (1));
i__7622__auto___12761 = G__12762;
continue;
} else {
}
break;
}

var G__12753 = args12751.length;
switch (G__12753) {
case 2:
return cljs_time.core.overlaps_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs_time.core.overlaps_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12751.length)].join('')));

}
});

cljs_time.core.overlaps_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (p__12754,p__12755){
var map__12756 = p__12754;
var map__12756__$1 = ((((!((map__12756 == null)))?((((map__12756.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12756.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12756):map__12756);
var start_a = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12756__$1,cljs.core.cst$kw$start);
var end_a = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12756__$1,cljs.core.cst$kw$end);
var map__12757 = p__12755;
var map__12757__$1 = ((((!((map__12757 == null)))?((((map__12757.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12757.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12757):map__12757);
var start_b = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12757__$1,cljs.core.cst$kw$start);
var end_b = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12757__$1,cljs.core.cst$kw$end);
var and__6534__auto__ = cljs.core.not((function (){var or__6546__auto__ = (cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_a,end_b) : cljs_time.core._EQ_.call(null,start_a,end_b));
if(cljs.core.truth_(or__6546__auto__)){
return or__6546__auto__;
} else {
return (cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(end_a,start_b) : cljs_time.core._EQ_.call(null,end_a,start_b));
}
})());
if(and__6534__auto__){
return cljs_time.core.overlaps_QMARK_.cljs$core$IFn$_invoke$arity$4(start_a,end_a,start_b,end_b);
} else {
return and__6534__auto__;
}
});

cljs_time.core.overlaps_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (start_a,end_a,start_b,end_b){
var or__6546__auto__ = (function (){var and__6534__auto__ = cljs_time.core.before_QMARK_(start_b,end_a);
if(cljs.core.truth_(and__6534__auto__)){
return cljs_time.core.after_QMARK_(end_b,start_a);
} else {
return and__6534__auto__;
}
})();
if(cljs.core.truth_(or__6546__auto__)){
return or__6546__auto__;
} else {
var or__6546__auto____$1 = (function (){var and__6534__auto__ = cljs_time.core.after_QMARK_(end_b,start_a);
if(cljs.core.truth_(and__6534__auto__)){
return cljs_time.core.before_QMARK_(start_b,end_a);
} else {
return and__6534__auto__;
}
})();
if(cljs.core.truth_(or__6546__auto____$1)){
return or__6546__auto____$1;
} else {
var or__6546__auto____$2 = (cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_a,end_b) : cljs_time.core._EQ_.call(null,start_a,end_b));
if(cljs.core.truth_(or__6546__auto____$2)){
return or__6546__auto____$2;
} else {
return (cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_b,end_a) : cljs_time.core._EQ_.call(null,start_b,end_a));
}
}
}
});

cljs_time.core.overlaps_QMARK_.cljs$lang$maxFixedArity = 4;

/**
 * Returns an Interval representing the overlap of the specified Intervals.
 *  Returns nil if the Intervals do not overlap.
 *  The first argument must not be nil.
 *  If the second argument is nil then the overlap of the first argument
 *  and a zero duration interval with both start and end times equal to the
 *  current time is returned.
 */
cljs_time.core.overlap = (function cljs_time$core$overlap(i_a,i_b){
if((i_b == null)){
var n = cljs_time.core.now();
return cljs_time$core$overlap(i_a,cljs_time.core.interval(n,n));
} else {
if(cljs.core.truth_(cljs_time.core.overlaps_QMARK_.cljs$core$IFn$_invoke$arity$2(i_a,i_b))){
return cljs_time.core.interval(cljs_time.core.latest.cljs$core$IFn$_invoke$arity$2(cljs_time.core.start(i_a),cljs_time.core.start(i_b)),cljs_time.core.earliest.cljs$core$IFn$_invoke$arity$2(cljs_time.core.end(i_a),cljs_time.core.end(i_b)));
} else {
return null;

}
}
});
/**
 * Returns true if Interval a abuts b, i.e. then end of a is exactly the
 *   beginning of b.
 */
cljs_time.core.abuts_QMARK_ = (function cljs_time$core$abuts_QMARK_(p__12766,p__12767){
var map__12772 = p__12766;
var map__12772__$1 = ((((!((map__12772 == null)))?((((map__12772.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12772.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12772):map__12772);
var start_a = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12772__$1,cljs.core.cst$kw$start);
var end_a = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12772__$1,cljs.core.cst$kw$end);
var map__12773 = p__12767;
var map__12773__$1 = ((((!((map__12773 == null)))?((((map__12773.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12773.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12773):map__12773);
var start_b = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12773__$1,cljs.core.cst$kw$start);
var end_b = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12773__$1,cljs.core.cst$kw$end);
var or__6546__auto__ = (cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_a,end_b) : cljs_time.core._EQ_.call(null,start_a,end_b));
if(cljs.core.truth_(or__6546__auto__)){
return or__6546__auto__;
} else {
return (cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs_time.core._EQ_.cljs$core$IFn$_invoke$arity$2(end_a,start_b) : cljs_time.core._EQ_.call(null,end_a,start_b));
}
});
cljs_time.core.date_QMARK_ = (function cljs_time$core$date_QMARK_(x){
if(!((x == null))){
if((false) || (x.cljs_time$core$DateTimeProtocol$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs_time.core.DateTimeProtocol,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs_time.core.DateTimeProtocol,x);
}
});
cljs_time.core.interval_QMARK_ = (function cljs_time$core$interval_QMARK_(x){
return (x instanceof cljs_time.core.Interval);
});
cljs_time.core.period_QMARK_ = (function cljs_time$core$period_QMARK_(x){
return (x instanceof cljs_time.core.Period);
});
cljs_time.core.period_type_QMARK_ = (function cljs_time$core$period_type_QMARK_(type,x){
var and__6534__auto__ = cljs_time.core.period_QMARK_(x);
if(cljs.core.truth_(and__6534__auto__)){
return cljs.core.contains_QMARK_(x,type);
} else {
return and__6534__auto__;
}
});
/**
 * Returns true if the given value is an instance of Years
 */
cljs_time.core.years_QMARK_ = (function cljs_time$core$years_QMARK_(val){
return cljs_time.core.period_type_QMARK_(cljs.core.cst$kw$years,val);
});
/**
 * Returns true if the given value is an instance of Months
 */
cljs_time.core.months_QMARK_ = (function cljs_time$core$months_QMARK_(val){
return cljs_time.core.period_type_QMARK_(cljs.core.cst$kw$months,val);
});
/**
 * Returns true if the given value is an instance of Weeks
 */
cljs_time.core.weeks_QMARK_ = (function cljs_time$core$weeks_QMARK_(val){
return cljs_time.core.period_type_QMARK_(cljs.core.cst$kw$weeks,val);
});
/**
 * Returns true if the given value is an instance of Days
 */
cljs_time.core.days_QMARK_ = (function cljs_time$core$days_QMARK_(val){
return cljs_time.core.period_type_QMARK_(cljs.core.cst$kw$days,val);
});
/**
 * Returns true if the given value is an instance of Hours
 */
cljs_time.core.hours_QMARK_ = (function cljs_time$core$hours_QMARK_(val){
return cljs_time.core.period_type_QMARK_(cljs.core.cst$kw$hours,val);
});
/**
 * Returns true if the given value is an instance of Minutes
 */
cljs_time.core.minutes_QMARK_ = (function cljs_time$core$minutes_QMARK_(val){
return cljs_time.core.period_type_QMARK_(cljs.core.cst$kw$minutes,val);
});
/**
 * Returns true if the given value is an instance of Seconds
 */
cljs_time.core.seconds_QMARK_ = (function cljs_time$core$seconds_QMARK_(val){
return cljs_time.core.period_type_QMARK_(cljs.core.cst$kw$seconds,val);
});
cljs_time.core.mins_ago = (function cljs_time$core$mins_ago(d){
return cljs_time.core.in_minutes(cljs_time.core.interval(d,cljs_time.core.now()));
});
cljs_time.core.last_day_of_the_month = (function cljs_time$core$last_day_of_the_month(var_args){
var args12778 = [];
var len__7621__auto___12781 = arguments.length;
var i__7622__auto___12782 = (0);
while(true){
if((i__7622__auto___12782 < len__7621__auto___12781)){
args12778.push((arguments[i__7622__auto___12782]));

var G__12783 = (i__7622__auto___12782 + (1));
i__7622__auto___12782 = G__12783;
continue;
} else {
}
break;
}

var G__12780 = args12778.length;
switch (G__12780) {
case 1:
return cljs_time.core.last_day_of_the_month.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.core.last_day_of_the_month.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12778.length)].join('')));

}
});

cljs_time.core.last_day_of_the_month.cljs$core$IFn$_invoke$arity$1 = (function (dt){
return cljs_time.core.last_day_of_the_month_(dt);
});

cljs_time.core.last_day_of_the_month.cljs$core$IFn$_invoke$arity$2 = (function (year,month){
return cljs_time.core.last_day_of_the_month_(cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$2(year,month));
});

cljs_time.core.last_day_of_the_month.cljs$lang$maxFixedArity = 2;

cljs_time.core.number_of_days_in_the_month = (function cljs_time$core$number_of_days_in_the_month(var_args){
var args12785 = [];
var len__7621__auto___12788 = arguments.length;
var i__7622__auto___12789 = (0);
while(true){
if((i__7622__auto___12789 < len__7621__auto___12788)){
args12785.push((arguments[i__7622__auto___12789]));

var G__12790 = (i__7622__auto___12789 + (1));
i__7622__auto___12789 = G__12790;
continue;
} else {
}
break;
}

var G__12787 = args12785.length;
switch (G__12787) {
case 1:
return cljs_time.core.number_of_days_in_the_month.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.core.number_of_days_in_the_month.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12785.length)].join('')));

}
});

cljs_time.core.number_of_days_in_the_month.cljs$core$IFn$_invoke$arity$1 = (function (dt){
return cljs_time.core.number_of_days_in_the_month.cljs$core$IFn$_invoke$arity$2(cljs_time.core.year(dt),cljs_time.core.month(dt));
});

cljs_time.core.number_of_days_in_the_month.cljs$core$IFn$_invoke$arity$2 = (function (year,month){
return cljs_time.core.last_day_of_the_month.cljs$core$IFn$_invoke$arity$2(year,month).getDate();
});

cljs_time.core.number_of_days_in_the_month.cljs$lang$maxFixedArity = 2;

cljs_time.core.first_day_of_the_month = (function cljs_time$core$first_day_of_the_month(var_args){
var args12792 = [];
var len__7621__auto___12795 = arguments.length;
var i__7622__auto___12796 = (0);
while(true){
if((i__7622__auto___12796 < len__7621__auto___12795)){
args12792.push((arguments[i__7622__auto___12796]));

var G__12797 = (i__7622__auto___12796 + (1));
i__7622__auto___12796 = G__12797;
continue;
} else {
}
break;
}

var G__12794 = args12792.length;
switch (G__12794) {
case 1:
return cljs_time.core.first_day_of_the_month.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.core.first_day_of_the_month.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12792.length)].join('')));

}
});

cljs_time.core.first_day_of_the_month.cljs$core$IFn$_invoke$arity$1 = (function (dt){
return cljs_time.core.first_day_of_the_month_(dt);
});

cljs_time.core.first_day_of_the_month.cljs$core$IFn$_invoke$arity$2 = (function (year,month){
return cljs_time.core.first_day_of_the_month_(cljs_time.core.date_time.cljs$core$IFn$_invoke$arity$2(year,month));
});

cljs_time.core.first_day_of_the_month.cljs$lang$maxFixedArity = 2;


/**
 * @interface
 */
cljs_time.core.IToPeriod = function(){};

cljs_time.core.__GT_period = (function cljs_time$core$__GT_period(obj){
if((!((obj == null))) && (!((obj.cljs_time$core$IToPeriod$__GT_period$arity$1 == null)))){
return obj.cljs_time$core$IToPeriod$__GT_period$arity$1(obj);
} else {
var x__7209__auto__ = (((obj == null))?null:obj);
var m__7210__auto__ = (cljs_time.core.__GT_period[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__7210__auto__.call(null,obj));
} else {
var m__7210__auto____$1 = (cljs_time.core.__GT_period["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(obj) : m__7210__auto____$1.call(null,obj));
} else {
throw cljs.core.missing_protocol("IToPeriod.->period",obj);
}
}
}
});

cljs_time.core.Interval.prototype.cljs_time$core$IToPeriod$ = true;

cljs_time.core.Interval.prototype.cljs_time$core$IToPeriod$__GT_period$arity$1 = (function (p__12799){
var map__12800 = p__12799;
var map__12800__$1 = ((((!((map__12800 == null)))?((((map__12800.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12800.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12800):map__12800);
var interval = map__12800__$1;
var start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12800__$1,cljs.core.cst$kw$start);
var end = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12800__$1,cljs.core.cst$kw$end);
var map__12802 = this;
var map__12802__$1 = ((((!((map__12802 == null)))?((((map__12802.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12802.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12802):map__12802);
var interval__$1 = map__12802__$1;
var start__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12802__$1,cljs.core.cst$kw$start);
var end__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12802__$1,cljs.core.cst$kw$end);
var years = cljs_time.core.in_years(interval__$1);
var start_year = cljs_time.core.year(start__$1);
var leap_years = cljs.core.count(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.false_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_time.internal.core.leap_year_QMARK_,cljs.core.range.cljs$core$IFn$_invoke$arity$2(start_year,(start_year + years)))));
var start_month = cljs_time.core.month(start__$1);
var days_in_months = cljs_time.core.total_days_in_whole_months(interval__$1);
var months = (cljs.core.count(days_in_months) - (years * (12)));
var days_to_remove = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,days_in_months);
var days = (cljs_time.core.in_days(interval__$1) - days_to_remove);
var hours_to_remove = ((24) * (days + days_to_remove));
var hours = (cljs_time.core.in_hours(interval__$1) - hours_to_remove);
var minutes_to_remove = ((60) * (hours + hours_to_remove));
var minutes = (cljs_time.core.in_minutes(interval__$1) - minutes_to_remove);
var seconds_to_remove = ((60) * (minutes + minutes_to_remove));
var seconds = (cljs_time.core.in_seconds(interval__$1) - seconds_to_remove);
return cljs_time.core.period.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$years,years,cljs.core.array_seq([cljs.core.cst$kw$months,months,cljs.core.cst$kw$days,days,cljs.core.cst$kw$hours,hours,cljs.core.cst$kw$minutes,minutes,cljs.core.cst$kw$seconds,seconds,cljs.core.cst$kw$millis,(cljs_time.core.in_millis(interval__$1) - ((1000) * (seconds + seconds_to_remove)))], 0));
});

cljs_time.core.Period.prototype.cljs_time$core$IToPeriod$ = true;

cljs_time.core.Period.prototype.cljs_time$core$IToPeriod$__GT_period$arity$1 = (function (period){
var period__$1 = this;
return period__$1;
});
cljs_time.core.today_at = (function cljs_time$core$today_at(var_args){
var args12804 = [];
var len__7621__auto___12808 = arguments.length;
var i__7622__auto___12809 = (0);
while(true){
if((i__7622__auto___12809 < len__7621__auto___12808)){
args12804.push((arguments[i__7622__auto___12809]));

var G__12810 = (i__7622__auto___12809 + (1));
i__7622__auto___12809 = G__12810;
continue;
} else {
}
break;
}

var G__12806 = args12804.length;
switch (G__12806) {
case 4:
return cljs_time.core.today_at.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return cljs_time.core.today_at.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return cljs_time.core.today_at.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12804.length)].join('')));

}
});

cljs_time.core.today_at.cljs$core$IFn$_invoke$arity$4 = (function (hours,minutes,seconds,millis){
var G__12807 = (new goog.date.UtcDateTime());
G__12807.setHours(hours);

G__12807.setMinutes(minutes);

G__12807.setSeconds(seconds);

G__12807.setMilliseconds(millis);

return G__12807;
});

cljs_time.core.today_at.cljs$core$IFn$_invoke$arity$3 = (function (hours,minutes,seconds){
return cljs_time.core.today_at.cljs$core$IFn$_invoke$arity$4(hours,minutes,seconds,(0));
});

cljs_time.core.today_at.cljs$core$IFn$_invoke$arity$2 = (function (hours,minutes){
return cljs_time.core.today_at.cljs$core$IFn$_invoke$arity$3(hours,minutes,(0));
});

cljs_time.core.today_at.cljs$lang$maxFixedArity = 4;

cljs_time.core.do_at_STAR_ = (function cljs_time$core$do_at_STAR_(base_date_time,body_fn){
var _STAR_ms_fn_STAR_12813 = cljs_time.core._STAR_ms_fn_STAR_;
cljs_time.core._STAR_ms_fn_STAR_ = cljs_time.core.static_ms_fn(base_date_time.getTime());

try{return (body_fn.cljs$core$IFn$_invoke$arity$0 ? body_fn.cljs$core$IFn$_invoke$arity$0() : body_fn.call(null));
}finally {cljs_time.core._STAR_ms_fn_STAR_ = _STAR_ms_fn_STAR_12813;
}});
/**
 * Floors the given date-time dt to the given time unit dt-fn,
 *  e.g. (floor (now) hour) returns (now) for all units
 *  up to and including the hour
 */
cljs_time.core.floor = (function cljs_time$core$floor(dt,dt_fn){
var dt_fns = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.core.year,cljs_time.core.month,cljs_time.core.day,cljs_time.core.hour,cljs_time.core.minute,cljs_time.core.second,cljs_time.core.milli], null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs_time.core.date_time,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.apply,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,dt_fn),dt_fns),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dt_fn], null)),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dt], null))));
});
