// Compiled by ClojureScript 1.9.89 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_time.coerce');
goog.require('cljs.core');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('goog.date.UtcDateTime');

/**
 * @interface
 */
cljs_time.coerce.ICoerce = function(){};

/**
 * Convert `obj` to a goog.date.DateTime instance.
 */
cljs_time.coerce.to_date_time = (function cljs_time$coerce$to_date_time(obj){
if((!((obj == null))) && (!((obj.cljs_time$coerce$ICoerce$to_date_time$arity$1 == null)))){
return obj.cljs_time$coerce$ICoerce$to_date_time$arity$1(obj);
} else {
var x__7209__auto__ = (((obj == null))?null:obj);
var m__7210__auto__ = (cljs_time.coerce.to_date_time[goog.typeOf(x__7209__auto__)]);
if(!((m__7210__auto__ == null))){
return (m__7210__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__7210__auto__.call(null,obj));
} else {
var m__7210__auto____$1 = (cljs_time.coerce.to_date_time["_"]);
if(!((m__7210__auto____$1 == null))){
return (m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7210__auto____$1.cljs$core$IFn$_invoke$arity$1(obj) : m__7210__auto____$1.call(null,obj));
} else {
throw cljs.core.missing_protocol("ICoerce.to-date-time",obj);
}
}
}
});

/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.from_long = (function cljs_time$coerce$from_long(millis){
var G__15614 = millis;
if((G__15614 == null)){
return null;
} else {
return (goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1 ? goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1(G__15614) : goog.date.UtcDateTime.fromTimestamp.call(null,G__15614));
}
});
/**
 * Returns DateTime instance from string using formatters in cljs-time.format,
 *   returning first which parses
 */
cljs_time.coerce.from_string = (function cljs_time$coerce$from_string(s){
if(cljs.core.truth_(s)){
return cljs.core.first((function (){var iter__7326__auto__ = (function cljs_time$coerce$from_string_$_iter__15625(s__15626){
return (new cljs.core.LazySeq(null,(function (){
var s__15626__$1 = s__15626;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__15626__$1);
if(temp__4657__auto__){
var s__15626__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__15626__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__15626__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__15628 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__15627 = (0);
while(true){
if((i__15627 < size__7325__auto__)){
var f = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__15627);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e15633){if((e15633 instanceof Error)){
var _ = e15633;
return null;
} else {
throw e15633;

}
}})();
if(cljs.core.truth_(d)){
cljs.core.chunk_append(b__15628,d);

var G__15635 = (i__15627 + (1));
i__15627 = G__15635;
continue;
} else {
var G__15636 = (i__15627 + (1));
i__15627 = G__15636;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__15628),cljs_time$coerce$from_string_$_iter__15625(cljs.core.chunk_rest(s__15626__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__15628),null);
}
} else {
var f = cljs.core.first(s__15626__$2);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e15634){if((e15634 instanceof Error)){
var _ = e15634;
return null;
} else {
throw e15634;

}
}})();
if(cljs.core.truth_(d)){
return cljs.core.cons(d,cljs_time$coerce$from_string_$_iter__15625(cljs.core.rest(s__15626__$2)));
} else {
var G__15637 = cljs.core.rest(s__15626__$2);
s__15626__$1 = G__15637;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7326__auto__(cljs.core.vals(cljs_time.format.formatters));
})());
} else {
return null;
}
});
/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   js Date object.
 */
cljs_time.coerce.from_date = (function cljs_time$coerce$from_date(date){
var G__15639 = date;
var G__15639__$1 = (((G__15639 == null))?null:G__15639.getTime());
if((G__15639__$1 == null)){
return null;
} else {
return cljs_time.coerce.from_long(G__15639__$1);
}
});
/**
 * Convert `obj` to the number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.to_long = (function cljs_time$coerce$to_long(obj){
var G__15641 = obj;
var G__15641__$1 = (((G__15641 == null))?null:cljs_time.coerce.to_date_time(G__15641));
if((G__15641__$1 == null)){
return null;
} else {
return G__15641__$1.getTime();
}
});
/**
 * Convert `obj` to Unix epoch.
 */
cljs_time.coerce.to_epoch = (function cljs_time$coerce$to_epoch(obj){
var millis = cljs_time.coerce.to_long(obj);
var and__6534__auto__ = millis;
if(cljs.core.truth_(and__6534__auto__)){
return cljs.core.quot(millis,(1000));
} else {
return and__6534__auto__;
}
});
/**
 * Convert `obj` to a JavaScript Date instance.
 */
cljs_time.coerce.to_date = (function cljs_time$coerce$to_date(obj){
var G__15643 = obj;
var G__15643__$1 = (((G__15643 == null))?null:cljs_time.coerce.to_date_time(G__15643));
var G__15643__$2 = (((G__15643__$1 == null))?null:G__15643__$1.getTime());
if((G__15643__$2 == null)){
return null;
} else {
return (new Date(G__15643__$2));
}
});
/**
 * Returns a string representation of obj in UTC time-zone
 *   using "yyyy-MM-dd'T'HH:mm:ss.SSSZZ" date-time representation.
 */
cljs_time.coerce.to_string = (function cljs_time$coerce$to_string(obj){
var G__15645 = obj;
var G__15645__$1 = (((G__15645 == null))?null:cljs_time.coerce.to_date_time(G__15645));
if((G__15645__$1 == null)){
return null;
} else {
return cljs_time.format.unparse(cljs.core.cst$kw$date_DASH_time.cljs$core$IFn$_invoke$arity$1(cljs_time.format.formatters),G__15645__$1);
}
});
/**
 * Convert `obj` to a goog.date.Date instance
 */
cljs_time.coerce.to_local_date = (function cljs_time$coerce$to_local_date(obj){
if(cljs.core.truth_(obj)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(goog.date.Date,cljs.core.type(obj))){
return obj;
} else {
var temp__4655__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
return (new goog.date.Date(dt.getYear(),dt.getMonth(),dt.getDate()));
} else {
return null;
}
}
} else {
return null;
}
});
/**
 * Convert `obj` to a goog.date.DateTime instance
 */
cljs_time.coerce.to_local_date_time = (function cljs_time$coerce$to_local_date_time(obj){
if(cljs.core.truth_(obj)){
var temp__4655__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
var G__15647 = (new goog.date.DateTime(dt.getYear(),dt.getMonth(),dt.getDate()));
G__15647.setHours(dt.getHours());

G__15647.setMinutes(dt.getMinutes());

G__15647.setSeconds(dt.getSeconds());

G__15647.setMilliseconds(dt.getMilliseconds());

return G__15647;
} else {
return null;
}
} else {
return null;
}
});
(cljs_time.coerce.ICoerce["null"] = true);

(cljs_time.coerce.to_date_time["null"] = (function (_){
return null;
}));

Date.prototype.cljs_time$coerce$ICoerce$ = true;

Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date){
var date__$1 = this;
return cljs_time.coerce.from_date(date__$1);
});

goog.date.Date.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date){
var local_date__$1 = this;
if(cljs.core.truth_(local_date__$1)){
return cljs_time.core.to_utc_time_zone(local_date__$1);
} else {
return null;
}
});

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date_time){
var local_date_time__$1 = this;
if(cljs.core.truth_(local_date_time__$1)){
return cljs_time.core.to_utc_time_zone(local_date_time__$1);
} else {
return null;
}
});

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date_time){
var date_time__$1 = this;
return date_time__$1;
});

(cljs_time.coerce.ICoerce["number"] = true);

(cljs_time.coerce.to_date_time["number"] = (function (long$){
return cljs_time.coerce.from_long(long$);
}));

(cljs_time.coerce.ICoerce["string"] = true);

(cljs_time.coerce.to_date_time["string"] = (function (string){
return cljs_time.coerce.from_string(string);
}));
