## Predis

Predis is a Clojure protocol for [Redis](http://redis.io/), which allows for multiple client implementations with a common API.
Most notably Predis provides an in-memory mock client implementation for testing purposes, similar to, and inspired by [brigade/mock_redis](https://github.com/brigade/mock_redis).





### Installation
TODO - clojars badge




### Usage
```clj
(require '[predis.core :as redis])

; Using the in-memory mock
(require '[predis.mock :as mock])
(def mock-client (mock/->redis))
(redis/set mock-client "foo" "bar") ; => "OK"
(redis/get mock-client "foo") ; => "bar"
```











### Usage
```clj
(require '[predis.core :as redis])

; Using the in-memory mock
(require '[predis.mock :as mock])
(def mock-client (mock/->redis))
(redis/set mock-client "foo" "bar")
(redis/get mock-client "foo") ; => "bar"
```

The API is the same for the real Carmine client:

```clj
(require '[predis.carmine :as carmine])

; Default config optionally shown
(def carmine-client (carmine/->redis {:pool {} :spec {:host "127.0.0.1" :port 6379}}))
(redis/set carmine-client "foo" "bar")
(redis/get carmine-client "foo") ; => "bar"
```

See the [API docs](TODO) for detailed command documentation.

### Not implemented
TODO: scripting commands, etc









### Contributing
Please use the [GitHub issues page](https://github.com/andrewberls/predis/issues) for questions/comments/suggestions (pull requests welcome!).
You can also find me on [Twitter](https://twitter.com/aberls).
