/*
 * Decompiled with CFR 0.152.
 */
package dialog.logger;

import clojure.lang.Keyword;

public enum Level {
    TRACE,
    DEBUG,
    INFO,
    WARN,
    ERROR,
    FATAL,
    OFF;

    public final Keyword keyword = Keyword.intern((String)this.name().toLowerCase());

    public static Level ofKeyword(Keyword keyword) {
        for (Level level : Level.values()) {
            if (!level.keyword.equals(keyword)) continue;
            return level;
        }
        throw new IllegalArgumentException("Not a valid level keyword: " + keyword);
    }

    public static boolean isValid(Keyword keyword) {
        for (Level level : Level.values()) {
            if (!level.keyword.equals(keyword)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllowed(Level level, Level level2) {
        if (level.equals((Object)OFF)) {
            return false;
        }
        return 0 <= level2.compareTo(level);
    }
}

