/*
 * Decompiled with CFR 0.152.
 */
package dialog.logger;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import dialog.logger.Level;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public final class DialogLogger
implements Serializable,
Logger {
    private static int cacheVersion = 0;
    private final String name;
    private final IFn getLevelFn;
    private final IFn logMessageFn;
    private Level cachedLevel;
    private int cachedAt;

    protected DialogLogger(String string, IFn iFn, IFn iFn2) {
        this.name = string;
        this.getLevelFn = iFn;
        this.logMessageFn = iFn2;
        this.cachedAt = -1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Var var = RT.var((String)"clojure.core", (String)"require");
        Symbol symbol = Symbol.intern((String)"dialog.logger");
        Object object = RT.REQUIRE_LOCK;
        synchronized (object) {
            var.invoke((Object)symbol);
        }
        objectInputStream.defaultReadObject();
    }

    public String getName() {
        return this.name;
    }

    public static void bumpCache() {
        ++cacheVersion;
    }

    public Level getLevel() {
        if (this.cachedLevel == null || this.cachedAt < cacheVersion) {
            IFn iFn = this.getLevelFn;
            Keyword keyword = (Keyword)iFn.invoke((Object)this.name);
            this.cachedLevel = Level.ofKeyword(keyword);
            this.cachedAt = cacheVersion;
        }
        return this.cachedLevel;
    }

    private boolean isEnabled(Level level) {
        return Level.isAllowed(this.getLevel(), level);
    }

    private void logMessage(Level level, String string, Throwable throwable) {
        IFn iFn = this.logMessageFn;
        iFn.invoke((Object)this.name, (Object)level.keyword, (Object)string, (Object)throwable);
    }

    private void logMessage(Level level, FormattingTuple formattingTuple) {
        this.logMessage(level, formattingTuple.getMessage(), formattingTuple.getThrowable());
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isEnabled(Level.TRACE);
    }

    public void trace(String string) {
        if (this.isEnabled(Level.TRACE)) {
            this.logMessage(Level.TRACE, string, null);
        }
    }

    public void trace(String string, Object object) {
        if (this.isEnabled(Level.TRACE)) {
            this.logMessage(Level.TRACE, MessageFormatter.format((String)string, (Object)object));
        }
    }

    public void trace(String string, Object object, Object object2) {
        if (this.isEnabled(Level.TRACE)) {
            this.logMessage(Level.TRACE, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    public void trace(String string, Object ... objectArray) {
        if (this.isEnabled(Level.TRACE)) {
            this.logMessage(Level.TRACE, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    public void trace(String string, Throwable throwable) {
        if (this.isEnabled(Level.TRACE)) {
            this.logMessage(Level.TRACE, string, throwable);
        }
    }

    public void trace(Marker marker, String string) {
        if (this.isEnabled(Level.TRACE)) {
            this.logMessage(Level.TRACE, string, null);
        }
    }

    public void trace(Marker marker, String string, Object object) {
        if (this.isEnabled(Level.TRACE)) {
            this.logMessage(Level.TRACE, MessageFormatter.format((String)string, (Object)object));
        }
    }

    public void trace(Marker marker, String string, Object object, Object object2) {
        if (this.isEnabled(Level.TRACE)) {
            this.logMessage(Level.TRACE, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    public void trace(Marker marker, String string, Object ... objectArray) {
        if (this.isEnabled(Level.TRACE)) {
            this.logMessage(Level.TRACE, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    public void trace(Marker marker, String string, Throwable throwable) {
        if (this.isEnabled(Level.TRACE)) {
            this.logMessage(Level.TRACE, string, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isEnabled(Level.DEBUG);
    }

    public void debug(String string) {
        if (this.isEnabled(Level.DEBUG)) {
            this.logMessage(Level.DEBUG, string, null);
        }
    }

    public void debug(String string, Object object) {
        if (this.isEnabled(Level.DEBUG)) {
            this.logMessage(Level.DEBUG, MessageFormatter.format((String)string, (Object)object));
        }
    }

    public void debug(String string, Object object, Object object2) {
        if (this.isEnabled(Level.DEBUG)) {
            this.logMessage(Level.DEBUG, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    public void debug(String string, Object ... objectArray) {
        if (this.isEnabled(Level.DEBUG)) {
            this.logMessage(Level.DEBUG, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.isEnabled(Level.DEBUG)) {
            this.logMessage(Level.DEBUG, string, throwable);
        }
    }

    public void debug(Marker marker, String string) {
        if (this.isEnabled(Level.DEBUG)) {
            this.logMessage(Level.DEBUG, string, null);
        }
    }

    public void debug(Marker marker, String string, Object object) {
        if (this.isEnabled(Level.DEBUG)) {
            this.logMessage(Level.DEBUG, MessageFormatter.format((String)string, (Object)object));
        }
    }

    public void debug(Marker marker, String string, Object object, Object object2) {
        if (this.isEnabled(Level.DEBUG)) {
            this.logMessage(Level.DEBUG, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    public void debug(Marker marker, String string, Object ... objectArray) {
        if (this.isEnabled(Level.DEBUG)) {
            this.logMessage(Level.DEBUG, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    public void debug(Marker marker, String string, Throwable throwable) {
        if (this.isEnabled(Level.DEBUG)) {
            this.logMessage(Level.DEBUG, string, throwable);
        }
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isEnabled(Level.INFO);
    }

    public void info(String string) {
        if (this.isEnabled(Level.INFO)) {
            this.logMessage(Level.INFO, string, null);
        }
    }

    public void info(String string, Object object) {
        if (this.isEnabled(Level.INFO)) {
            this.logMessage(Level.INFO, MessageFormatter.format((String)string, (Object)object));
        }
    }

    public void info(String string, Object object, Object object2) {
        if (this.isEnabled(Level.INFO)) {
            this.logMessage(Level.INFO, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    public void info(String string, Object ... objectArray) {
        if (this.isEnabled(Level.INFO)) {
            this.logMessage(Level.INFO, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    public void info(String string, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.logMessage(Level.INFO, string, throwable);
        }
    }

    public void info(Marker marker, String string) {
        if (this.isEnabled(Level.INFO)) {
            this.logMessage(Level.INFO, string, null);
        }
    }

    public void info(Marker marker, String string, Object object) {
        if (this.isEnabled(Level.INFO)) {
            this.logMessage(Level.INFO, MessageFormatter.format((String)string, (Object)object));
        }
    }

    public void info(Marker marker, String string, Object object, Object object2) {
        if (this.isEnabled(Level.INFO)) {
            this.logMessage(Level.INFO, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    public void info(Marker marker, String string, Object ... objectArray) {
        if (this.isEnabled(Level.INFO)) {
            this.logMessage(Level.INFO, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    public void info(Marker marker, String string, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.logMessage(Level.INFO, string, throwable);
        }
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isEnabled(Level.WARN);
    }

    public void warn(String string) {
        if (this.isEnabled(Level.WARN)) {
            this.logMessage(Level.WARN, string, null);
        }
    }

    public void warn(String string, Object object) {
        if (this.isEnabled(Level.WARN)) {
            this.logMessage(Level.WARN, MessageFormatter.format((String)string, (Object)object));
        }
    }

    public void warn(String string, Object object, Object object2) {
        if (this.isEnabled(Level.WARN)) {
            this.logMessage(Level.WARN, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    public void warn(String string, Object ... objectArray) {
        if (this.isEnabled(Level.WARN)) {
            this.logMessage(Level.WARN, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    public void warn(String string, Throwable throwable) {
        if (this.isEnabled(Level.WARN)) {
            this.logMessage(Level.WARN, string, throwable);
        }
    }

    public void warn(Marker marker, String string) {
        if (this.isEnabled(Level.WARN)) {
            this.logMessage(Level.WARN, string, null);
        }
    }

    public void warn(Marker marker, String string, Object object) {
        if (this.isEnabled(Level.WARN)) {
            this.logMessage(Level.WARN, MessageFormatter.format((String)string, (Object)object));
        }
    }

    public void warn(Marker marker, String string, Object object, Object object2) {
        if (this.isEnabled(Level.WARN)) {
            this.logMessage(Level.WARN, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    public void warn(Marker marker, String string, Object ... objectArray) {
        if (this.isEnabled(Level.WARN)) {
            this.logMessage(Level.WARN, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    public void warn(Marker marker, String string, Throwable throwable) {
        if (this.isEnabled(Level.WARN)) {
            this.logMessage(Level.WARN, string, throwable);
        }
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isEnabled(Level.ERROR);
    }

    public void error(String string) {
        if (this.isEnabled(Level.ERROR)) {
            this.logMessage(Level.ERROR, string, null);
        }
    }

    public void error(String string, Object object) {
        if (this.isEnabled(Level.ERROR)) {
            this.logMessage(Level.ERROR, MessageFormatter.format((String)string, (Object)object));
        }
    }

    public void error(String string, Object object, Object object2) {
        if (this.isEnabled(Level.ERROR)) {
            this.logMessage(Level.ERROR, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    public void error(String string, Object ... objectArray) {
        if (this.isEnabled(Level.ERROR)) {
            this.logMessage(Level.ERROR, MessageFormatter.format((String)string, (Object)objectArray));
        }
    }

    public void error(String string, Throwable throwable) {
        if (this.isEnabled(Level.ERROR)) {
            this.logMessage(Level.ERROR, string, throwable);
        }
    }

    public void error(Marker marker, String string) {
        if (this.isEnabled(Level.ERROR)) {
            this.logMessage(Level.ERROR, string, null);
        }
    }

    public void error(Marker marker, String string, Object object) {
        if (this.isEnabled(Level.ERROR)) {
            this.logMessage(Level.ERROR, MessageFormatter.format((String)string, (Object)object));
        }
    }

    public void error(Marker marker, String string, Object object, Object object2) {
        if (this.isEnabled(Level.ERROR)) {
            this.logMessage(Level.ERROR, MessageFormatter.format((String)string, (Object)object, (Object)object2));
        }
    }

    public void error(Marker marker, String string, Object ... objectArray) {
        if (this.isEnabled(Level.ERROR)) {
            this.logMessage(Level.ERROR, MessageFormatter.arrayFormat((String)string, (Object[])objectArray));
        }
    }

    public void error(Marker marker, String string, Throwable throwable) {
        if (this.isEnabled(Level.ERROR)) {
            this.logMessage(Level.ERROR, string, throwable);
        }
    }
}

