(ns repo.mongo
  (:require [monger.core :as mg]
            [monger.collection :as mc]))

(defn connect
  "connect takes `dbname` will give you a connection"
  [dbname]
  (mg/get-db (mg/connect {:host "localhost" :port 27017}) dbname))

(defn insert
  "will insert given document in given collection"
  [db coll doc]
  (mc/insert-and-return db (name coll) doc))

(defn find
  "will find you document using your given query and return as a clojure map"
  [db coll query]
  (mc/find-one-as-map db (name coll) query))

(defn find-all
  "will find all documents matching your given query and return as a vector of maps"
  [db coll query]
  (mc/find-maps db (name coll) query))

(defn remove
  "will remove a document matching your given query"
  [db coll query]
  (mc/remove (connect) (name coll) query))

(defn insert-all
  "given a vector of maps will insert all maps in given vector"
  [db coll docs]
  (for [doc docs]
      (insert [(name coll) doc])))

(defn exists?
  "check if given query exists in database "
  [db coll query]
  (let [count (count (mc/find-maps (connect) (name coll) query))]
    (if (not= count 0)
      true
      false)))

(defn count
  "count matching documents with your query"
  [db coll query]
  (count (mc/find-maps (connect) (name coll) query)))
