(ns render.render
  (:require [re-frame.core :as rf]
            [reagent.core :as r]
            ["@material-ui/core/Grid" :default Grid]
            ["@material-ui/core/Button" :default Button]
            ["@material-ui/core/Paper" :default Paper]
            ["@material-ui/core/Typography" :default Typography]
            ["@material-ui/core/TextField" :default TextField]))


(defn content []
  [{:type    :text
    :content {:src              "<p style=\"text-align: center;\">SAMPLE <span style=\"color: rgb(255, 0, 0);\"><strong><u>TEXT</u></strong></span></p>"
              :background-color "white"}}
   {:type    :text
    :content {:src              "<p style=\"text-align: center;\"><span style=\"font-size: 24px;\"><span style=\"color: rgb(241, 241, 241);\">ФИКСАТОР</span><span style=\"color: rgb(229, 216, 92);\">&nbsp;<span style=\"font-weight: 700;\">ГОЛЕНОСТОПА</span></span></span></p>"
              :background-color "rgb(46, 55, 67)"}}
   {:type    :image
    :content {:src "images/img_1.jpg"}}
   {:type    :image-set
    :content {:background-color "rgb(46, 55, 67)"
              :images           [{:src     "images/img_2_1.png"
                                  :caption {:src "<p>\n<p style=\"text-align: center;\"><span style=\"color: rgb(241, 241, 241);\">ФИКСАЦИЯ И&nbsp;</span></p>\n<p style=\"text-align: center;\"><span style=\"font-weight: 700; color: rgb(250, 237, 125);\">ПОДДЕРЖКА</span></p>\n</p>"}}
                                 {:src     "images/img_2_2.png"
                                  :caption {:src "<p>\n<p style=\"text-align: center;\"><span style=\"color: rgb(241, 241, 241);\">ФИКСАЦИЯ И&nbsp;</span></p>\n<p style=\"text-align: center;\"><span style=\"font-weight: 700; color: rgb(250, 237, 125);\">ПОДДЕРЖКА</span></p>\n</p>"}}
                                 {:src     "images/img_2_2.png"
                                  :caption {:src "<p>\n<p style=\"text-align: center;\"><span style=\"color: rgb(241, 241, 241);\">ФИКСАЦИЯ И&nbsp;</span></p>\n<p style=\"text-align: center;\"><span style=\"font-weight: 700; color: rgb(250, 237, 125);\">ПОДДЕРЖКА</span></p>\n</p>"}}]}}
   {:type    :price
    :content {:before   "309"
              :currency "UAH"
              :after    "12"}}
   {:type    :contact
    :content {:background-color "rgb(46, 55, 67)"
              :fields           [{:key   :email
                                  :label "E-Mail"}
                                 {:key   :phone
                                  :label "Phone number"}
                                 {:key   :quantity
                                  :label "Quantity"}]
              :button           {:label "Buy"
                                 :props {:palette-color "secondary"
                                         :variant       "outlined"}}}}])

(defn render-text
  [{:keys [src background-color]}]
  [:> Grid {:item  true
            :xs    12
            :style {:background-color background-color}}
   [:div {:dangerouslySetInnerHTML {:__html src}}]])

(defn render-image
  [{:keys [src width caption] :or {width "100%"}} & [xs]]
  [:> Grid {:item true
            :xs   (or xs 12)}
   (let [element [:img {:src   src
                        :width width}]]
     (if caption
       [:> Grid {:item      true
                 :container true}
        [:> Grid {:item true
                  :xs   12}
         element]
        [:> Grid {:item true
                  :xs   12}
         (render-text caption)]]
       element))])

(defn render-price
  [{:keys [before after currency]}]
  [:> Grid {:item      true
            :container true
            :xs        12
            :style     {:background-image "url(images/currency.svg)"}}
   [:> Grid {:item true
             :xs   6}
    [:> Grid {:item        true
              :justify     "center"
              :align-items "flex-end"
              :container   true}
     [:> Typography {:variant "body1"} "Обычная цена:"]]]
   [:> Grid {:item true
             :xs   6}
    [:> Grid {:item        true
              :justify     "center"
              :align-items "flex-end"
              :container   true}
     [:> Typography {:variant "body1"} "Цена по акции:"]]]
   [:> Grid {:item true
             :xs   6}
    [:> Grid {:item        true
              :justify     "center"
              :align-items "flex-end"
              :container   true}
     [:> Typography {:variant "h4"
                     :style   {:text-decoration "line-through"}} before]
     [:> Typography {:variant "h5"} currency]]]
   [:> Grid {:item true
             :xs   6}
    [:> Grid {:item        true
              :justify     "center"
              :align-items "flex-end"
              :container   true}
     [:> Typography {:variant "h4"} after]
     [:> Typography {:variant "h5"} currency]]]])

(defn render-image-set
  [{:keys [images background-color]}]
  (let [len (count images)]
    (into [:> Grid {:item      true
                    :container true
                    :xs        12
                    :style     {:background-color background-color}}]
          (mapv
            #(render-image % (/ 12 len))
            images))))

(defn render-contact
  [{:keys [fields button background-color]}]
  (let [form (r/atom {})]
    [:> Grid {:container true
              :style     {:padding          24
                          :background-color background-color}}
     (conj (into [:> Grid {:container true
                           :spacing   3
                           :direction "column"}]
                 (mapv
                   (fn [f]
                     [:> Grid {:item true}
                      [:> TextField
                       (merge {:variant    "outlined"
                               :on-change  #(swap! form merge {(:key f) (-> % .-target .-value)})
                               :full-width true}
                              f)]])
                   fields))
           [:> Grid {:item true
                     :xs   true}
            [:> Button
             (merge {:full-width true
                     :variant    "outlined"
                     :color      "secondary"
                     :on-click   #(print @form)}
                    (:props button)) (or (:label button) "Buy")]])]))

(defn render
  [content]
  (into
    [:> Grid {:container true}]
    (mapv
      (fn [{:keys [type content]}]
        (case type
          :text (render-text content)
          :image (render-image content)
          :image-set (render-image-set content)
          :price (render-price content)
          :contact (render-contact content)
          (str "not supported type:" type)))
      content)))