(ns lambda.uuid
  (:import (java.util UUID)))

(defn gen
  []
  (UUID/randomUUID))

(defn from-number
  [i]
  (UUID/fromString
   (format "00000000-0000-0000-0000-%012d" i)))

(defn parse
  [id]
  (when id
    (if (= (type id) UUID)
      id
      (UUID/fromString id))))

(defn named
  [^String name]
  (UUID/nameUUIDFromBytes (.getBytes name)))
